/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import org.fcrepo.http.commons.domain.Range;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest {
    @Test
    public void testUnboundedRange() {
        Range range = new Range(5L);
        Assert.assertEquals((long)5L, (long)range.start());
        Assert.assertEquals((long)-1L, (long)range.end());
    }

    @Test
    public void testRangeParsing() {
        Range range = Range.convert((String)"bytes=50-100");
        Assert.assertEquals((long)50L, (long)range.start());
        Assert.assertEquals((long)100L, (long)range.end());
        Assert.assertEquals((long)51L, (long)range.size());
        Assert.assertTrue((boolean)range.hasRange());
    }

    @Test
    public void testUnboundedUpperRangeParsing() {
        Range range = Range.convert((String)"bytes=50-");
        Assert.assertEquals((long)50L, (long)range.start());
        Assert.assertEquals((long)-1L, (long)range.end());
        Assert.assertEquals((long)-1L, (long)range.size());
        Assert.assertTrue((boolean)range.hasRange());
    }

    @Test
    public void testUnboundedLowerRangeParsing() {
        Range range = Range.convert((String)"bytes=-50");
        Assert.assertEquals((long)0L, (long)range.start());
        Assert.assertEquals((long)50L, (long)range.end());
        Assert.assertEquals((long)51L, (long)range.size());
        Assert.assertTrue((boolean)range.hasRange());
    }

    @Test
    public void testGarbageRangeParsing() {
        Range range = Range.convert((String)"something-thats-not-a-range");
        Assert.assertFalse((boolean)range.hasRange());
        Assert.assertEquals((long)0L, (long)range.start());
        Assert.assertEquals((long)-1L, (long)range.end());
        Assert.assertEquals((long)-1L, (long)range.size());
    }
}

