/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain.ldp;

import org.fcrepo.http.commons.domain.PreferTag;
import org.fcrepo.http.commons.domain.ldp.LdpPreferTag;
import org.fcrepo.kernel.api.RdfLexicon;
import org.junit.Assert;
import org.junit.Test;

public class LdpPreferTagTest {
    private LdpPreferTag testObj;

    @Test
    public void testMinimalHandling() {
        this.testObj = new LdpPreferTag(new PreferTag("handling=lenient; received=\"minimal\""));
        Assert.assertFalse((boolean)this.testObj.prefersServerManaged());
        Assert.assertFalse((boolean)this.testObj.prefersContainment());
        Assert.assertFalse((boolean)this.testObj.prefersMembership());
        Assert.assertFalse((boolean)this.testObj.prefersEmbed());
        Assert.assertFalse((boolean)this.testObj.prefersReferences());
    }

    @Test
    public void testMinimalContainer() {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersServerManaged());
        Assert.assertFalse((boolean)this.testObj.prefersReferences());
        Assert.assertFalse((boolean)this.testObj.prefersContainment());
        Assert.assertFalse((boolean)this.testObj.prefersMembership());
        Assert.assertFalse((boolean)this.testObj.prefersEmbed());
    }

    @Test
    public void testPreferMembership() {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer http://www.w3.org/ns/ldp#PreferMembership\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersMembership());
    }

    @Test
    public void testPreferContainment() {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMinimalContainer http://www.w3.org/ns/ldp#PreferContainment\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersContainment());
    }

    @Test
    public void testPreferContainmentAndMembership() {
        PreferTag prefer = new PreferTag("return=representation; include=\"http://www.w3.org/ns/ldp#PreferMembership http://www.w3.org/ns/ldp#PreferContainment\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersMembership());
        Assert.assertTrue((boolean)this.testObj.prefersContainment());
    }

    @Test
    public void testPreferOmitContainmentAndMembership() {
        PreferTag prefer = new PreferTag("return=representation; omit=\"http://www.w3.org/ns/ldp#PreferMembership http://www.w3.org/ns/ldp#PreferContainment\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertFalse((boolean)this.testObj.prefersMembership());
        Assert.assertFalse((boolean)this.testObj.prefersContainment());
    }

    @Test
    public void testPreferReference() {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + RdfLexicon.INBOUND_REFERENCES + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.prefersReferences());
    }

    @Test
    public void testEmbedDefault() {
        this.testObj = new LdpPreferTag(PreferTag.emptyTag());
        Assert.assertFalse((boolean)this.testObj.prefersEmbed());
    }

    @Test
    public void testEmbedContained() {
        this.testObj = new LdpPreferTag(new PreferTag("return=representation; include=\"" + RdfLexicon.EMBED_CONTAINED + "\""));
        Assert.assertTrue((boolean)this.testObj.prefersEmbed());
    }
}

