/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.test.util;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Base64;
import java.util.Collections;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import org.glassfish.grizzly.http.server.GrizzlyPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAuthenticationRequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TestAuthenticationRequestFilter.class);
    private static final String FEDORA_ADMIN_USER = "fedoraAdmin";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String username = TestAuthenticationRequestFilter.getUsername(req);
        Set<String> containerRoles = Collections.emptySet();
        if (username == null) {
            log.debug("ANONYMOUS");
        } else if (FEDORA_ADMIN_USER.equals(username)) {
            containerRoles = Collections.singleton(FEDORA_ADMIN_USER);
            log.debug("ADMIN AUTHENTICATED");
        } else if ("noroles".equals(username)) {
            log.debug("USER (without roles); AUTHENTICATED");
        } else {
            containerRoles = Collections.singleton("fedoraUser");
            log.debug("USER AUTHENTICATED");
        }
        ServletRequest proxy = TestAuthenticationRequestFilter.proxy(req, username, containerRoles);
        chain.doFilter(proxy, response);
    }

    private static ServletRequest proxy(HttpServletRequest request, String username, final Set<String> containerRoles) {
        GrizzlyPrincipal user = username != null ? new GrizzlyPrincipal(username) : null;
        HttpServletRequest result = (HttpServletRequest)Proxy.newProxyInstance(request.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler((Principal)user, username, request){
            final /* synthetic */ Principal val$user;
            final /* synthetic */ String val$username;
            final /* synthetic */ HttpServletRequest val$request;
            {
                this.val$user = principal;
                this.val$username = string;
                this.val$request = httpServletRequest;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("isUserInRole")) {
                    String role = (String)args[0];
                    return containerRoles.contains(role);
                }
                if (method.getName().equals("getUserPrincipal")) {
                    return this.val$user;
                }
                if (method.getName().equals("getRemoteUser")) {
                    return this.val$username;
                }
                return method.invoke((Object)this.val$request, args);
            }
        });
        return result;
    }

    private static String getUsername(HttpServletRequest request) {
        String authentication = request.getHeader("Authorization");
        if (authentication == null) {
            return null;
        }
        if (!authentication.startsWith("Basic ")) {
            return null;
        }
        authentication = authentication.substring("Basic ".length());
        String[] values = new String(Base64.getDecoder().decode(authentication)).split(":");
        if (values.length < 2) {
            throw new WebApplicationException(400);
        }
        String username = values[0];
        String password = values[1];
        if (username == null || password == null) {
            return null;
        }
        return username;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

