/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain.ldp;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.fcrepo.http.commons.domain.PreferTag;
import org.fcrepo.kernel.api.RdfLexicon;

public class LdpPreferTag
extends PreferTag {
    private final boolean membership;
    private final boolean containment;
    private final boolean references;
    private final boolean embed;
    private final boolean managedProperties;

    public LdpPreferTag(PreferTag preferTag) {
        super(preferTag);
        Optional<String> include = Optional.ofNullable(preferTag.getParams().get("include"));
        Optional<String> omit = Optional.ofNullable(preferTag.getParams().get("omit"));
        Optional<String> received = Optional.ofNullable(preferTag.getParams().get("received"));
        List<String> includes = Arrays.asList(include.orElse(" ").split(" "));
        List<String> omits = Arrays.asList(omit.orElse(" ").split(" "));
        boolean minimal = preferTag.getValue().equals("minimal") || received.orElse("").equals("minimal");
        boolean preferMinimalContainer = includes.contains("http://www.w3.org/ns/ldp#PreferMinimalContainer") || minimal;
        this.membership = !preferMinimalContainer && !omits.contains("http://www.w3.org/ns/ldp#PreferMembership") || includes.contains("http://www.w3.org/ns/ldp#PreferMembership");
        this.containment = !preferMinimalContainer && !omits.contains("http://www.w3.org/ns/ldp#PreferContainment") && !omits.contains(RdfLexicon.PREFER_SERVER_MANAGED.toString()) || includes.contains("http://www.w3.org/ns/ldp#PreferContainment");
        this.references = includes.contains(RdfLexicon.INBOUND_REFERENCES.toString());
        this.embed = includes.contains(RdfLexicon.EMBED_CONTAINED.toString());
        this.managedProperties = includes.contains(RdfLexicon.PREFER_SERVER_MANAGED.toString()) || !omits.contains(RdfLexicon.PREFER_SERVER_MANAGED.toString()) && !minimal;
    }

    public boolean prefersMembership() {
        return this.membership;
    }

    public boolean prefersContainment() {
        return this.containment;
    }

    public boolean prefersReferences() {
        return this.references;
    }

    public boolean prefersEmbed() {
        return this.embed;
    }

    public boolean prefersServerManaged() {
        return this.managedProperties;
    }
}

