/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import com.google.common.base.Throwables;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.fcrepo.http.commons.exceptionhandlers.RepositoryExceptionMapper;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RepositoryRuntimeExceptionMapper
implements ExceptionMapper<RepositoryRuntimeException>,
ExceptionDebugLogging {
    private final Providers providers;
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryExceptionMapper.class);

    public RepositoryRuntimeExceptionMapper(@Context Providers providers) {
        this.providers = providers;
    }

    public Response toResponse(RepositoryRuntimeException e) {
        Throwable cause = e.getCause();
        ExceptionMapper exceptionMapper = this.providers.getExceptionMapper(cause.getClass());
        if (exceptionMapper != null) {
            return exceptionMapper.toResponse(cause);
        }
        LOGGER.error("Caught a repository exception: {}", (Object)e.getMessage());
        this.debugException(this, cause, LOGGER);
        return Response.serverError().entity((Object)Throwables.getStackTraceAsString((Throwable)e)).type("text/plain;charset=utf-8").build();
    }
}

