/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.responses.RdfNamespacedStream;
import org.fcrepo.http.commons.responses.RdfStreamStreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"text/turtle", "text/rdf+n3", "text/n3", "application/rdf+xml", "application/n-triples", "text/plain", "application/x-turtle", "application/ld+json"})
public class RdfStreamProvider
implements MessageBodyWriter<RdfNamespacedStream> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamProvider.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        LOGGER.debug("Checking to see if we can serialize type: {} to mimeType: {}", (Object)type.getName(), (Object)mediaType.toString());
        if (!RdfNamespacedStream.class.isAssignableFrom(type)) {
            return false;
        }
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) || mediaType.getType().equals("application") && mediaType.getSubtype().equals("html")) {
            LOGGER.debug("Was asked for an HTML mimeType, returning false.");
            return false;
        }
        LOGGER.debug("Assuming that this is an attempt to retrieve RDF, returning true.");
        return true;
    }

    public long getSize(RdfNamespacedStream t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(RdfNamespacedStream nsStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        LOGGER.debug("Serializing an RdfStream to mimeType: {}", (Object)mediaType);
        RdfStreamStreamingOutput streamOutput = new RdfStreamStreamingOutput(nsStream.stream, nsStream.namespaces, mediaType);
        streamOutput.write(entityStream);
    }
}

