/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import javax.jcr.RepositoryException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Providers;
import org.fcrepo.http.commons.exceptionhandlers.RepositoryRuntimeExceptionMapper;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RepositoryRuntimeExceptionMapperTest {
    @Mock
    private Providers mockProviders;
    private RepositoryRuntimeExceptionMapper testObj;
    @Mock
    private ExceptionMapper<RepositoryException> mockProvider;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new RepositoryRuntimeExceptionMapper(this.mockProviders);
    }

    @Test
    public void testToResponseWithHandledRepositoryException() {
        Mockito.when((Object)this.mockProviders.getExceptionMapper(RepositoryException.class)).thenReturn(this.mockProvider);
        RepositoryException cause = new RepositoryException("xyz");
        RepositoryRuntimeException ex = new RepositoryRuntimeException((Throwable)cause);
        this.testObj.toResponse(ex);
        ((ExceptionMapper)Mockito.verify(this.mockProvider)).toResponse((Throwable)cause);
    }

    @Test
    public void testToResponseWithUnhandledRepositoryException() {
        Mockito.when((Object)this.mockProviders.getExceptionMapper(Exception.class)).thenReturn(null);
        Exception cause = new Exception("xyz");
        RepositoryRuntimeException ex = new RepositoryRuntimeException((Throwable)cause);
        Response response = this.testObj.toResponse(ex);
        Assert.assertEquals((long)500L, (long)response.getStatus());
    }
}

