/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import org.fcrepo.http.commons.responses.ViewHelpers;
import org.fcrepo.http.commons.test.util.TestHelpers;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.services.VersionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewHelpersTest {
    private ViewHelpers testObj;
    private static final String REPOSITORY_ROOT_URI = "fedora:RepositoryRoot".replaceAll("fedora:", "http://fedora.info/definitions/v4/repository#");

    @Before
    public void setUp() {
        this.testObj = ViewHelpers.getInstance();
    }

    @Test
    public void testGetVersions() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        String resource_version = "http://localhost/fcrepo/abc/fcr:versions";
        Instant recent = Instant.now();
        Node version = NodeFactory.createURI((String)("http://localhost/fcrepo/abc/fcr:versions/" + VersionService.MEMENTO_LABEL_FORMATTER.format(recent)));
        mem.add(new Triple(NodeFactory.createURI((String)"http://localhost/fcrepo/abc/fcr:versions"), RdfLexicon.CONTAINS.asNode(), version));
        mem.add(new Triple(version, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)VersionService.MEMENTO_RFC_1123_FORMATTER.format(recent))));
        Assert.assertEquals((String)"Version should be available.", (Object)version, this.testObj.getVersions(mem, NodeFactory.createURI((String)"http://localhost/fcrepo/abc/fcr:versions")).next());
    }

    @Test
    public void testGetOrderedVersions() {
        Node resource_version = NodeFactory.createURI((String)"http://localhost/fcrepo/abc/fcr:versions");
        Instant recent = Instant.now();
        Instant past = recent.minus(3L, ChronoUnit.DAYS);
        Instant way_past = recent.minus(60L, ChronoUnit.DAYS);
        Node v1 = NodeFactory.createURI((String)("http://localhost/fcrepo/abc/fcr:versions/" + VersionService.MEMENTO_LABEL_FORMATTER.format(recent)));
        Node v2 = NodeFactory.createURI((String)("http://localhost/fcrepo/abc/fcr:versions/" + VersionService.MEMENTO_LABEL_FORMATTER.format(past)));
        Node v3 = NodeFactory.createURI((String)("http://localhost/fcrepo/abc/fcr:versions/" + VersionService.MEMENTO_LABEL_FORMATTER.format(way_past)));
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(resource_version, RdfLexicon.CONTAINS.asNode(), v1));
        mem.add(new Triple(resource_version, RdfLexicon.CONTAINS.asNode(), v2));
        mem.add(new Triple(resource_version, RdfLexicon.CONTAINS.asNode(), v3));
        mem.add(new Triple(v1, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)VersionService.MEMENTO_RFC_1123_FORMATTER.format(recent))));
        mem.add(new Triple(v2, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)VersionService.MEMENTO_RFC_1123_FORMATTER.format(past))));
        mem.add(new Triple(v3, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)VersionService.MEMENTO_RFC_1123_FORMATTER.format(way_past))));
        Iterator versions = this.testObj.getOrderedVersions(mem, resource_version, (Resource)RdfLexicon.CONTAINS);
        Assert.assertTrue((boolean)versions.hasNext());
        Node r1 = (Node)versions.next();
        Assert.assertEquals((String)"Version is out of order", (Object)v3, (Object)r1);
        Node r2 = (Node)versions.next();
        Assert.assertEquals((String)"Version is out of order", (Object)v2, (Object)r2);
        Node r3 = (Node)versions.next();
        Assert.assertEquals((String)"Latest version should be last.", (Object)v1, (Object)r3);
    }

    @Test
    public void shouldConvertAUriToNodeBreadcrumbs() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        Map nodeBreadcrumbs = this.testObj.getNodeBreadcrumbs(mockUriInfo, ResourceFactory.createResource((String)"http://localhost/fcrepo/a/b/c").asNode());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"http://localhost/fcrepo/a", (Object)"a", (Object)"http://localhost/fcrepo/a/b", (Object)"b", (Object)"http://localhost/fcrepo/a/b/c", (Object)"c"), (Object)nodeBreadcrumbs);
    }

    @Test
    public void shouldRefuseToConvertAForeignUriToNodeBreadcrumbs() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        Map nodeBreadcrumbs = this.testObj.getNodeBreadcrumbs(mockUriInfo, ResourceFactory.createResource((String)"http://somewhere/else/a/b/c").asNode());
        Assert.assertTrue((boolean)nodeBreadcrumbs.isEmpty());
    }

    @Test
    public void testIsVersionedNode() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RDF.type.asNode(), NodeFactory.createURI((String)"http://mementoweb.org/ns#Memento")));
        Assert.assertTrue((String)"Node is a versioned node.", (boolean)this.testObj.isVersionedNode(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testRdfResource() {
        String ns = "http://any/namespace#";
        String rdfType = "anyType";
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b"), RDF.type.asNode(), ResourceFactory.createResource((String)"http://any/namespace#anyType").asNode()));
        Assert.assertTrue((String)"Node is a anyType node.", (boolean)this.testObj.isRdfResource(mem, NodeFactory.createURI((String)"a/b"), "http://any/namespace#", "anyType"));
        Assert.assertFalse((String)"Node is not a anyType node.", (boolean)this.testObj.isRdfResource(mem, NodeFactory.createURI((String)"a/b"), "http://any/namespace#", "otherType"));
    }

    @Test
    public void shouldFindVersionRoot() {
        UriInfo mockUriInfo = TestHelpers.getUriInfoImpl();
        String nodeUri = this.testObj.getVersionSubjectUrl(mockUriInfo, ResourceFactory.createResource((String)"http://localhost/fcrepo/a/b/fcr:versions/c").asNode());
        Assert.assertEquals((Object)"http://localhost/fcrepo/a/b", (Object)nodeUri);
    }

    @Test
    public void testGetVersionDate() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        String date_str = "20011231050505";
        Node subject = NodeFactory.createURI((String)"a/b/c/20011231050505");
        Instant date = Instant.from(VersionService.MEMENTO_LABEL_FORMATTER.parse("20011231050505"));
        mem.add(new Triple(subject, RdfLexicon.CREATED_DATE.asNode(), NodeFactory.createLiteral((String)VersionService.MEMENTO_RFC_1123_FORMATTER.format(date))));
        Assert.assertEquals((String)"Date should be available.", (Object)date, (Object)this.testObj.getVersionDate(mem, subject));
    }

    @Test
    public void shouldExtractTitleFromNode() {
        this.shouldExtractTitleFromNode(DC.title);
        this.shouldExtractTitleFromNode(DCTerms.title);
        this.shouldExtractTitleFromNode(RDFS.label);
        this.shouldExtractTitleFromNode(SKOS.prefLabel);
    }

    private void shouldExtractTitleFromNode(Property property) {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), property.asNode(), NodeFactory.createLiteral((String)"abc")));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectTitle(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUseTheObjectUriIfATitleIsNotAvailable() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), DC.title.asNode(), NodeFactory.createURI((String)"d/e/f")));
        Assert.assertEquals((Object)"a/b/c", (Object)this.testObj.getObjectTitle(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void shouldUsetheBNodeIdIfItIsABNode() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Node anon = NodeFactory.createBlankNode();
        Assert.assertEquals((Object)anon.getBlankNodeLabel(), (Object)this.testObj.getObjectTitle(mem, anon));
    }

    @Test
    public void shouldJustUseTheStringIfItIsALiteral() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Node lit = NodeFactory.createLiteral((String)"xyz");
        Assert.assertEquals((Object)"\"xyz\"", (Object)this.testObj.getObjectTitle(mem, lit));
    }

    @Test
    public void shouldConvertRdfObjectsToStrings() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a/b/c"), NodeFactory.createLiteral((String)"abc")));
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-numeric-type"), ResourceFactory.createTypedLiteral((Object)0).asNode()));
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"an-empty-string"), NodeFactory.createLiteral((String)"")));
        mem.add(new Triple(NodeFactory.createURI((String)"subject"), NodeFactory.createURI((String)"a-uri"), NodeFactory.createURI((String)"some-uri")));
        Assert.assertEquals((Object)"abc", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a/b/c"), true));
        Assert.assertEquals((Object)"0", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-numeric-type"), true));
        Assert.assertEquals((Object)"<empty>", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"an-empty-string"), true));
        Assert.assertEquals((Object)"&lt;<a href=\"some-uri\">some-uri</a>&gt;", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-uri"), true));
        Assert.assertEquals((Object)"some-uri", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-uri"), false));
        Assert.assertEquals((Object)"", (Object)this.testObj.getObjectsAsString(mem, NodeFactory.createURI((String)"subject"), ResourceFactory.createResource((String)"a-nonexistent-uri"), true));
    }

    @Test
    public void shouldExtractNamespaceAndPrefix() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Assert.assertEquals((Object)"prefix:", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "namespace", false));
        Assert.assertEquals((Object)"some-other-namespace", (Object)this.testObj.getNamespacePrefix((PrefixMapping)model, "some-other-namespace", false));
    }

    @Test
    public void shouldSortTriplesForDisplay() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        Property propertyA = model.createProperty("namespace", "a");
        Property propertyB = model.createProperty("namespace", "b");
        Property propertyC = model.createProperty("c");
        Literal literalA = model.createLiteral("a");
        Literal literalB = model.createLiteral("b");
        Resource resourceB = model.createResource("b");
        model.add(resourceB, propertyA, (RDFNode)literalA);
        Resource a = model.createResource("a");
        model.add(a, propertyC, (RDFNode)literalA);
        model.add(a, propertyB, (RDFNode)literalA);
        model.add(a, propertyA, (RDFNode)literalA);
        model.add(a, propertyA, (RDFNode)literalB);
        ExtendedIterator iterator = model.getGraph().find(null, null, null);
        List sortedTriples = this.testObj.getSortedTriples(model, (Iterator)iterator);
        ((Triple)sortedTriples.get(0)).matches(a.asNode(), propertyA.asNode(), literalA.asNode());
        ((Triple)sortedTriples.get(1)).matches(a.asNode(), propertyA.asNode(), literalB.asNode());
        ((Triple)sortedTriples.get(2)).matches(a.asNode(), propertyB.asNode(), literalA.asNode());
        ((Triple)sortedTriples.get(3)).matches(a.asNode(), propertyC.asNode(), literalA.asNode());
        ((Triple)sortedTriples.get(4)).matches(resourceB.asNode(), propertyC.asNode(), literalA.asNode());
    }

    @Test
    public void shouldConvertPrefixMappingToSparqlUpdatePrefixPreamble() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("prefix", "namespace");
        String prefixPreamble = this.testObj.getPrefixPreamble((PrefixMapping)model);
        Assert.assertEquals((Object)"PREFIX prefix: <namespace>\n\n", (Object)prefixPreamble);
    }

    @Test
    public void shouldConvertStringLiteralsToNodes() {
        String uri = "fedora:resource";
        Literal URIRES = ResourceFactory.createPlainLiteral((String)"fedora:resource");
        Assert.assertEquals((Object)URIRES.asNode(), (Object)this.testObj.asLiteralStringNode("fedora:resource"));
    }

    @Test
    public void testGetNumChildren() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.CONTAINS.asNode(), ResourceFactory.createResource((String)"a/b/c/1").asNode()));
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.CONTAINS.asNode(), ResourceFactory.createResource((String)"a/b/c/2").asNode()));
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.CONTAINS.asNode(), ResourceFactory.createResource((String)"a/b/c/3").asNode()));
        mem.add(new Triple(NodeFactory.createURI((String)"a/b/c"), RdfLexicon.CONTAINS.asNode(), ResourceFactory.createResource((String)"a/b/c/4").asNode()));
        Assert.assertEquals((long)4L, (long)this.testObj.getNumChildren(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testGetNumChildrenEmpty() {
        Graph mem = ModelFactory.createDefaultModel().getGraph();
        Assert.assertEquals((long)0L, (long)this.testObj.getNumChildren(mem, NodeFactory.createURI((String)"a/b/c")));
    }

    @Test
    public void testIsRepositoryRoot() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("fedora", "http://fedora.info/definitions/v4/repository#");
        Graph mem = model.getGraph();
        Node root = NodeFactory.createURI((String)"http://localhost/root");
        Node child = NodeFactory.createURI((String)"http://localhost/not_root");
        mem.add(new Triple(root, RDF.type.asNode(), RdfLexicon.BASIC_CONTAINER.asNode()));
        mem.add(new Triple(root, RDF.type.asNode(), NodeFactory.createURI((String)REPOSITORY_ROOT_URI)));
        mem.add(new Triple(child, RDF.type.asNode(), RdfLexicon.BASIC_CONTAINER.asNode()));
        Assert.assertTrue((String)"Root should be a Repository Root", (boolean)this.testObj.isRootResource(mem, root));
        Assert.assertFalse((String)"Child should not be a Repository Root", (boolean)this.testObj.isRootResource(mem, child));
    }
}

