/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.Principal;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.servlet.ServletContext;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.test.util.CloseableDataset;
import org.fcrepo.kernel.api.services.functions.ConfigurableHierarchicalSupplier;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class TestHelpers {
    public static ServletContext getServletContextImpl() {
        ServletContext sc = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)sc.getContextPath()).thenReturn((Object)"/fcrepo");
        return sc;
    }

    public static UriInfo getUriInfoImpl() {
        UriInfo ui = (UriInfo)Mockito.mock(UriInfo.class);
        Answer<UriBuilder> answer = new Answer<UriBuilder>(){

            public UriBuilder answer(InvocationOnMock invocation) {
                return UriBuilder.fromUri((String)"http://localhost/fcrepo");
            }
        };
        Mockito.when((Object)ui.getRequestUri()).thenReturn((Object)URI.create("http://localhost/fcrepo"));
        Mockito.when((Object)ui.getBaseUri()).thenReturn((Object)URI.create("http://localhost/fcrepo"));
        Mockito.when((Object)ui.getBaseUriBuilder()).thenAnswer((Answer)answer);
        Mockito.when((Object)ui.getAbsolutePathBuilder()).thenAnswer((Answer)answer);
        return ui;
    }

    public static Session mockSession(AbstractResource testObj) {
        SecurityContext mockSecurityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal mockPrincipal = (Principal)Mockito.mock(Principal.class);
        String mockUser = "testuser";
        Session mockSession = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)mockSession.getUserID()).thenReturn((Object)"testuser");
        Mockito.when((Object)mockSecurityContext.getUserPrincipal()).thenReturn((Object)mockPrincipal);
        Mockito.when((Object)mockPrincipal.getName()).thenReturn((Object)"testuser");
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        Mockito.when((Object)mockWorkspace.getName()).thenReturn((Object)"default");
        TestHelpers.setField(testObj, "uriInfo", TestHelpers.getUriInfoImpl());
        TestHelpers.setField(testObj, "pidMinter", new ConfigurableHierarchicalSupplier());
        return mockSession;
    }

    private static String getRdfSerialization(HttpEntity entity) {
        Lang lang = RDFLanguages.contentTypeToLang((String)ContentType.parse((String)entity.getContentType().getValue()).getMimeType());
        Assert.assertNotNull((String)"Entity is not an RDF serialization", (Object)lang);
        return lang.getName();
    }

    public static CloseableDataset parseTriples(HttpEntity entity) throws IOException {
        return TestHelpers.parseTriples(entity.getContent(), TestHelpers.getRdfSerialization(entity));
    }

    public static CloseableDataset parseTriples(InputStream content) {
        return TestHelpers.parseTriples(content, "N3");
    }

    public static CloseableDataset parseTriples(InputStream content, String contentType) {
        Model model = ModelFactory.createDefaultModel();
        model.read(content, "", contentType);
        return new CloseableDataset(model);
    }

    public static void setField(Object parent, String name, Object obj) {
        try {
            Field f = TestHelpers.findField(parent.getClass(), name);
            f.setAccessible(true);
            f.set(parent, obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field findField(Class<?> clazz, String name) throws NoSuchFieldException {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        if (clazz.getSuperclass() == null) {
            throw new NoSuchFieldException("Field " + name + " could not be found");
        }
        return TestHelpers.findField(clazz.getSuperclass(), name);
    }
}

