/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpIdentifierConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpIdentifierConverter.class);
    private final UriBuilder uriBuilder;
    private final UriTemplate uriTemplate;

    private static String trimTrailingSlashes(String string) {
        return string.replaceAll("/+$", "");
    }

    public HttpIdentifierConverter(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
        this.uriTemplate = new UriTemplate(uriBuilder.toTemplate());
    }

    public HttpIdentifierConverter() {
        this.uriBuilder = null;
        this.uriTemplate = null;
    }

    public String toInternalId(String httpUri) {
        LOGGER.trace("Translating http URI {} to Fedora ID", (Object)httpUri);
        String path = this.getPath(httpUri);
        if (path != null) {
            String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8);
            String fedoraId = HttpIdentifierConverter.trimTrailingSlashes(decodedPath);
            return "info:fedora" + fedoraId;
        }
        throw new IllegalArgumentException("Cannot translate NULL path");
    }

    public boolean inExternalDomain(String httpUri) {
        LOGGER.trace("Checking if http URI {} is in domain", (Object)httpUri);
        return this.getPath(httpUri) != null;
    }

    public String toExternalId(String fedoraId) {
        LOGGER.trace("Translating Fedora ID {} to Http URI", (Object)fedoraId);
        if (this.inInternalDomain(fedoraId)) {
            String path = fedoraId.substring("info:fedora".length()).replaceFirst("\\/", "");
            UriBuilder uri = this.uriBuilder();
            if (path.contains("#")) {
                String[] split = path.split("#", 2);
                uri.resolveTemplate("path", (Object)split[0], false);
                uri.fragment(split[1]);
            } else {
                uri.resolveTemplate("path", (Object)path, false);
            }
            return uri.build(new Object[0]).toString();
        }
        throw new IllegalArgumentException("Cannot translate IDs without our prefix");
    }

    public boolean inInternalDomain(String fedoraId) {
        LOGGER.trace("Checking if fedora ID {} is in domain", (Object)fedoraId);
        return fedoraId.startsWith("info:fedora");
    }

    private UriBuilder uriBuilder() {
        return UriBuilder.fromUri((String)this.uriBuilder.toTemplate());
    }

    public String toDomain(String path) {
        String realPath = path == null ? "" : (path.startsWith("/") ? path.substring(1) : path);
        UriBuilder uri = this.uriBuilder();
        if (realPath.contains("#")) {
            String[] split = realPath.split("#", 2);
            uri.resolveTemplate("path", (Object)split[0], false);
            uri.fragment(split[1]);
        } else {
            uri.resolveTemplate("path", (Object)realPath, false);
        }
        return uri.build(new Object[0]).toString();
    }

    public FedoraId pathToInternalId(String externalPath) {
        return FedoraId.create((String[])new String[]{this.toInternalId(this.toDomain(externalPath))});
    }

    private String getPath(String httpUri) {
        HashMap values = new HashMap();
        if (this.uriTemplate.match((CharSequence)httpUri, values) && values.containsKey("path")) {
            return "/" + (String)values.get("path");
        }
        if (this.isRootWithoutTrailingSlash(httpUri)) {
            return "/";
        }
        if (httpUri.startsWith("info:/rest")) {
            return this.mapInternalRestUri(httpUri);
        }
        return null;
    }

    private boolean isRootWithoutTrailingSlash(String httpUri) {
        HashMap values = new HashMap();
        return this.uriTemplate.match((CharSequence)(httpUri + "/"), values) && values.containsKey("path") && ((String)values.get("path")).isEmpty();
    }

    private String mapInternalRestUri(String httpUri) {
        String internalRestString = this.internalIdPrefix() + "/rest";
        if (httpUri.startsWith(internalRestString)) {
            String realpath = httpUri.substring(internalRestString.length());
            if (realpath.startsWith("/")) {
                realpath = realpath.substring(1);
            }
            String fullUri = this.uriBuilder.build(new Object[]{realpath}).toString();
            return this.getPath(fullUri);
        }
        return null;
    }

    private String internalIdPrefix() {
        String internalPrefix = "info:fedora";
        if (internalPrefix.contains(":")) {
            internalPrefix = internalPrefix.substring(0, internalPrefix.indexOf(":") + 1);
        }
        return internalPrefix;
    }
}

