/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.exceptionhandlers.ConstraintExceptionMapper;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.fcrepo.kernel.api.exception.MultipleConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class MultipleConstraintViolationExceptionMapper
extends ConstraintExceptionMapper<MultipleConstraintViolationException>
implements ExceptionDebugLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleConstraintViolationExceptionMapper.class);
    @Context
    private UriInfo uriInfo;
    @Context
    private ServletContext context;

    public Response toResponse(MultipleConstraintViolationException e) {
        this.debugException(this, (Throwable)e, LOGGER);
        String msg = e.getMessage();
        Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)msg).type("text/plain;charset=utf-8");
        Link[] constraintLinks = (Link[])e.getExceptionTypes().stream().map(Object::getClass).distinct().map(c -> MultipleConstraintViolationExceptionMapper.buildConstraintLink(c, this.context, this.uriInfo)).toArray(Link[]::new);
        return response.links(constraintLinks).build();
    }
}

