/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ExceptionMapper;
import org.fcrepo.http.commons.api.rdf.HttpIdentifierConverter;
import org.fcrepo.http.commons.exceptionhandlers.TombstoneExceptionMapper;
import org.fcrepo.kernel.api.exception.TombstoneException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TombstoneExceptionMapperTest {
    @Mock
    private FedoraResource mockResource;
    private final FedoraId fedoraId = FedoraId.create((String[])new String[]{"/some:uri"});
    private final Instant deleteTime = Instant.now();
    private ExceptionMapper<TombstoneException> testObj;
    private static final String SERVER_URI = "http://localhost:8080/rest(.*)";
    private final HttpIdentifierConverter idConverter = new HttpIdentifierConverter(UriBuilder.fromUri((String)"http://localhost:8080/rest(.*)"));

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResource.getFedoraId()).thenReturn((Object)this.fedoraId);
        Mockito.when((Object)this.mockResource.getLastModifiedDate()).thenReturn((Object)this.deleteTime);
        this.testObj = new TombstoneExceptionMapper();
    }

    @Test
    public void testUrilessException() {
        Response response = this.testObj.toResponse((Throwable)new TombstoneException(this.mockResource));
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)response.getStatus());
        this.assertTombstone(response, this.fedoraId.getFullIdPath(), null);
    }

    @Test
    public void testExceptionWithUri() {
        String tombstone = this.idConverter.toExternalId(this.fedoraId.asTombstone().getFullId());
        Response response = this.testObj.toResponse((Throwable)new TombstoneException(this.mockResource, tombstone));
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)response.getStatus());
        this.assertTombstone(response, this.fedoraId.getFullIdPath(), tombstone);
    }

    private void assertTombstone(Response response, String tombstoneAt, String tombstoneUri) {
        if (tombstoneUri == null) {
            Assert.assertNull((Object)response.getHeaderString("Link"));
        } else {
            Link link = Link.valueOf((String)response.getHeaderString("Link"));
            Assert.assertEquals((Object)tombstoneUri, (Object)link.getUri().toString());
            Assert.assertEquals((Object)"hasTombstone", (Object)link.getRel());
        }
        String expectedString = "Discovered tombstone resource at " + tombstoneAt + ", departed at: " + DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).format(this.deleteTime);
        Assert.assertEquals((Object)expectedString, (Object)response.getEntity().toString());
    }
}

