/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain.ldp;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.fcrepo.http.commons.domain.PreferTag;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.rdf.LdpTriplePreferences;

public class LdpPreferTag
extends PreferTag
implements LdpTriplePreferences {
    private final boolean getMinimal;
    private final boolean membership;
    private final boolean containment;
    private final boolean references;
    private final boolean embed;
    private final boolean managedProperties;
    private final boolean noMinimal;

    public LdpPreferTag(PreferTag preferTag) {
        super(preferTag);
        Optional<String> include = Optional.ofNullable(preferTag.getParams().get("include"));
        Optional<String> omit = Optional.ofNullable(preferTag.getParams().get("omit"));
        Optional<String> received = Optional.ofNullable(preferTag.getParams().get("received"));
        List<String> includes = Arrays.asList(include.orElse(" ").split(" "));
        List<String> omits = Arrays.asList(omit.orElse(" ").split(" "));
        this.getMinimal = preferTag.getValue().equals("minimal") || received.orElse("").equals("minimal");
        boolean preferMinimalContainer = !omits.contains(RdfLexicon.PREFER_MINIMAL_CONTAINER.toString()) && (includes.contains(RdfLexicon.PREFER_MINIMAL_CONTAINER.toString()) || this.getMinimal);
        this.noMinimal = omits.contains(RdfLexicon.PREFER_MINIMAL_CONTAINER.toString());
        this.membership = !preferMinimalContainer && !omits.contains(RdfLexicon.PREFER_MEMBERSHIP.toString()) || includes.contains(RdfLexicon.PREFER_MEMBERSHIP.toString());
        this.containment = !preferMinimalContainer && !omits.contains(RdfLexicon.PREFER_CONTAINMENT.toString()) && !omits.contains(RdfLexicon.PREFER_SERVER_MANAGED.toString()) || includes.contains(RdfLexicon.PREFER_CONTAINMENT.toString());
        this.references = includes.contains(RdfLexicon.INBOUND_REFERENCES.toString());
        this.embed = includes.contains(RdfLexicon.EMBED_CONTAINED.toString());
        this.managedProperties = includes.contains(RdfLexicon.PREFER_SERVER_MANAGED.toString()) || !omits.contains(RdfLexicon.PREFER_SERVER_MANAGED.toString()) && !this.getMinimal;
    }

    public boolean getMinimal() {
        return this.getMinimal;
    }

    public boolean prefersMembership() {
        return this.membership;
    }

    public boolean prefersContainment() {
        return this.containment;
    }

    public boolean prefersReferences() {
        return this.references;
    }

    public boolean prefersEmbed() {
        return this.embed;
    }

    public boolean prefersServerManaged() {
        return this.managedProperties;
    }

    public boolean preferNoUserRdf() {
        return this.noMinimal;
    }
}

