/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.exception.TransactionRuntimeException;
import org.glassfish.hk2.api.Factory;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProvider
implements Factory<Transaction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionProvider.class);
    static final String JMS_BASEURL_PROP = "fcrepo.jms.baseUrl";
    private final TransactionManager txManager;
    private final HttpServletRequest request;
    private final Pattern txIdPattern;
    private final URI baseUri;

    public TransactionProvider(TransactionManager txManager, HttpServletRequest request, URI baseUri) {
        this.txManager = txManager;
        this.request = request;
        this.txIdPattern = Pattern.compile("(^|" + baseUri + "fcr:tx/)([0-9a-f\\-]+)$");
        this.baseUri = baseUri;
    }

    public Transaction provide() {
        Transaction transaction = this.getTransactionForRequest();
        if (!transaction.isShortLived()) {
            transaction.refresh();
        }
        LOGGER.trace("Providing new transaction {}", (Object)transaction.getId());
        return transaction;
    }

    public void dispose(Transaction transaction) {
        if (transaction.isShortLived()) {
            LOGGER.trace("Disposing transaction {}", (Object)transaction.getId());
            transaction.expire();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Transaction getTransactionForRequest() {
        Matcher txMatcher;
        String txId = null;
        String txUri = this.request.getHeader("Atomic-ID");
        if (!StringUtils.isEmpty((CharSequence)txUri)) {
            txMatcher = this.txIdPattern.matcher(txUri);
            if (!txMatcher.matches()) throw new TransactionRuntimeException("Invalid transaction id");
            txId = txMatcher.group(2);
        } else {
            txUri = this.request.getPathInfo();
            if (txUri != null && (txMatcher = this.txIdPattern.matcher(txUri)).matches()) {
                txId = txMatcher.group(2);
            }
        }
        if (!StringUtils.isEmpty(txId)) {
            return this.txManager.get(txId);
        }
        Transaction transaction = this.txManager.create();
        transaction.setUserAgent(this.request.getHeader("user-agent"));
        transaction.setBaseUri(this.resolveBaseUri());
        return transaction;
    }

    private String resolveBaseUri() {
        String baseURL = this.getBaseUrlProperty();
        if (baseURL.length() > 0) {
            return baseURL;
        }
        return this.baseUri.toString();
    }

    private String getBaseUrlProperty() {
        String propBaseURL = System.getProperty(JMS_BASEURL_PROP, "");
        if (propBaseURL.length() > 0 && propBaseURL.startsWith("http")) {
            URI propBaseUri = URI.create(propBaseURL);
            if (propBaseUri.getPort() < 0) {
                return JerseyUriBuilder.fromUri((URI)this.baseUri).port(-1).uri(propBaseUri).toString();
            }
            return JerseyUriBuilder.fromUri((URI)this.baseUri).uri(propBaseUri).toString();
        }
        return "";
    }
}

