/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.fcrepo.http.commons.exceptionhandlers.WebApplicationExceptionMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WebApplicationExceptionMapperTest {
    private WebApplicationExceptionMapper testObj;

    @Before
    public void setUp() {
        this.testObj = new WebApplicationExceptionMapper();
    }

    @Test
    public void testToResponse() {
        WebApplicationException input = new WebApplicationException();
        Response actual = this.testObj.toResponse(input);
        Assert.assertEquals((long)input.getResponse().getStatus(), (long)actual.getStatus());
    }

    @Test
    public void testNoEntityBody() {
        Stream.of(204, 205, 304).forEach(status -> {
            WebApplicationException input = new WebApplicationException("Error message", status.intValue());
            Response actual = this.testObj.toResponse(input);
            Assert.assertNull((String)("Responses with a " + status + " status code MUST NOT carry an entity body."), (Object)actual.getEntity());
        });
        WebApplicationException input = new WebApplicationException("Error message", 500);
        Response actual = this.testObj.toResponse(input);
        Assert.assertEquals((Object)"Error message", (Object)actual.getEntity());
    }
}

