/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.session;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.http.commons.session.TransactionProvider;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ContainerRequest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class TransactionProviderTest {
    @Mock
    private TransactionManager transactionManager;
    @Mock
    private HttpServletRequest request;
    @Mock
    private Transaction transaction;

    @Before
    public void setup() {
        Mockito.when((Object)this.transactionManager.create()).thenReturn((Object)this.transaction);
    }

    private TransactionProvider createProvider(UriInfo uriInfo, String jmsBaseUrl) {
        return new TransactionProvider(this.transactionManager, this.request, uriInfo.getBaseUri(), jmsBaseUrl);
    }

    @Test
    public void testSetUserAgent() {
        URI baseUri = URI.create("http://localhost/fcrepo");
        URI requestUri = URI.create("http://localhost/fcrepo/foo");
        ContainerRequest req = new ContainerRequest(baseUri, requestUri, "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        UriInfo info = (UriInfo)Mockito.spy((Object)req.getUriInfo());
        String expectedBaseUrl = baseUri.toString();
        String expectedUserAgent = "fedoraAdmin";
        Mockito.when((Object)this.request.getHeader("user-agent")).thenReturn((Object)"fedoraAdmin");
        this.createProvider(info, "").provide();
        ((Transaction)Mockito.verify((Object)this.transaction)).setBaseUri(expectedBaseUrl);
        ((Transaction)Mockito.verify((Object)this.transaction)).setUserAgent("fedoraAdmin");
        ((UriInfo)Mockito.verify((Object)info)).getBaseUri();
    }

    @Test
    public void testJmsBaseUrlDefault() {
        URI baseUri = URI.create("http://localhost/fcrepo");
        URI requestUri = URI.create("http://localhost/fcrepo/foo");
        ContainerRequest req = new ContainerRequest(baseUri, requestUri, "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        UriInfo info = (UriInfo)Mockito.spy((Object)req.getUriInfo());
        String expectedBaseUrl = baseUri.toString();
        this.createProvider(info, "").provide();
        ((Transaction)Mockito.verify((Object)this.transaction)).setBaseUri(expectedBaseUrl);
        ((UriInfo)Mockito.verify((Object)info)).getBaseUri();
    }

    @Test
    public void testJmsBaseUrlOverrideHost() {
        URI baseUri = URI.create("http://localhost/fcrepo");
        URI requestUri = URI.create("http://localhost/fcrepo/foo");
        ContainerRequest req = new ContainerRequest(baseUri, requestUri, "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        UriInfo info = (UriInfo)Mockito.spy((Object)req.getUriInfo());
        String baseUrl = "http://example.org";
        String expectedBaseUrl = "http://example.org" + baseUri.getPath();
        this.createProvider(info, "http://example.org").provide();
        ((Transaction)Mockito.verify((Object)this.transaction)).setBaseUri(expectedBaseUrl);
    }

    @Test
    public void testJmsBaseUrlOverrideHostAndPort() {
        URI baseUri = URI.create("http://localhost/fcrepo");
        URI requestUri = URI.create("http://localhost/fcrepo/foo");
        ContainerRequest req = new ContainerRequest(baseUri, requestUri, "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        UriInfo info = (UriInfo)Mockito.spy((Object)req.getUriInfo());
        String baseUrl = "http://example.org:9090";
        String expectedBaseUrl = "http://example.org:9090" + baseUri.getPath();
        this.createProvider(info, "http://example.org:9090").provide();
        ((Transaction)Mockito.verify((Object)this.transaction)).setBaseUri(expectedBaseUrl);
    }

    @Test
    public void testJmsBaseUrlOverrideUrl() {
        URI baseUri = URI.create("http://localhost/fcrepo");
        URI requestUri = URI.create("http://localhost/fcrepo/foo");
        ContainerRequest req = new ContainerRequest(baseUri, requestUri, "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        UriInfo info = (UriInfo)Mockito.spy((Object)req.getUriInfo());
        String expectedBaseUrl = "http://example.org/fcrepo/rest";
        this.createProvider(info, "http://example.org/fcrepo/rest").provide();
        ((Transaction)Mockito.verify((Object)this.transaction)).setBaseUri("http://example.org/fcrepo/rest");
    }

    @Test
    public void testJmsBaseUrlOverrideRequestUrlWithPort8080() {
        URI baseUri = URI.create("http://localhost:8080/fcrepo/rest");
        URI reqUri = URI.create("http://localhost:8080/fcrepo/rest/foo");
        ContainerRequest req = new ContainerRequest(baseUri, reqUri, "GET", (SecurityContext)Mockito.mock(SecurityContext.class), (PropertiesDelegate)Mockito.mock(PropertiesDelegate.class));
        UriInfo info = (UriInfo)Mockito.spy((Object)req.getUriInfo());
        String expectedBaseUrl = "http://example.org/fcrepo/rest/";
        this.createProvider(info, "http://example.org/fcrepo/rest/").provide();
        ((Transaction)Mockito.verify((Object)this.transaction)).setBaseUri("http://example.org/fcrepo/rest/");
    }
}

