/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.fcrepo.http.commons.api.rdf.HttpIdentifierConverter;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class HttpIdentifierConverterTest {
    private HttpIdentifierConverter converter;
    private static final String uriBase = "http://localhost:8080/some";
    private static final String uriTemplate = "http://localhost:8080/some/{path: .*}";
    private UriBuilder uriBuilder;

    @Before
    public void setUp() {
        this.uriBuilder = UriBuilder.fromUri((String)uriTemplate);
        this.converter = new HttpIdentifierConverter(this.uriBuilder);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBlankUri() {
        String testUri = "";
        this.converter.toInternalId("");
    }

    @Test
    public void testBlankToDomain() {
        String testUri = "";
        String fedoraUri = this.converter.toDomain("");
        Assert.assertEquals((Object)"http://localhost:8080/some/", (Object)fedoraUri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBlankId() {
        String testId = "";
        String fedoraId = this.converter.toExternalId("");
    }

    @Test
    public void testinExternalDomainSuccess() {
        String testURI = "http://localhost:8080/some/someurl/thatWeWant";
        Assert.assertTrue((boolean)this.converter.inExternalDomain("http://localhost:8080/some/someurl/thatWeWant"));
    }

    @Test
    public void testinExternalDomainFailure() {
        String testURI = "http://someplace.com/whatHappened";
        Assert.assertFalse((boolean)this.converter.inExternalDomain("http://someplace.com/whatHappened"));
    }

    @Test
    public void testinInternalDomainSuccess() {
        String testID = "info:fedora/myLittleResource";
        Assert.assertTrue((boolean)this.converter.inInternalDomain("info:fedora/myLittleResource"));
    }

    @Test
    public void testinInternalDomainFailure() {
        String testID = "info:test/myLittleResource";
        Assert.assertFalse((boolean)this.converter.inInternalDomain("info:test/myLittleResource"));
    }

    @Test
    public void testRootUriWithTrailingSlash() {
        String testUri = "http://localhost:8080/some/";
        String fedoraId = this.converter.toInternalId("http://localhost:8080/some/");
        Assert.assertEquals((Object)"info:fedora", (Object)fedoraId);
        String httpUri = this.converter.toExternalId(fedoraId);
        Assert.assertEquals((Object)"http://localhost:8080/some/", (Object)httpUri);
    }

    @Test
    public void testRootUriWithoutTrailingSlash() {
        String testUri = uriBase;
        String fedoraId = this.converter.toInternalId(uriBase);
        Assert.assertEquals((Object)"info:fedora", (Object)fedoraId);
        String httpUri = this.converter.toExternalId(fedoraId);
        Assert.assertEquals((Object)"http://localhost:8080/some/", (Object)httpUri);
    }

    @Test
    public void testFirstLevel() {
        String baseUid = HttpIdentifierConverterTest.getUniqueId();
        String testUri = "http://localhost:8080/some/" + baseUid;
        String fedoraId = this.converter.toInternalId(testUri);
        Assert.assertEquals((Object)("info:fedora/" + baseUid), (Object)fedoraId);
        String httpUri = this.converter.toExternalId(fedoraId);
        Assert.assertEquals((Object)testUri, (Object)httpUri);
    }

    @Test
    public void testFirstLevelExternalPath() {
        String baseUid = HttpIdentifierConverterTest.getUniqueId();
        String testUri = "/" + baseUid;
        String fedoraId = this.converter.toInternalId(this.converter.toDomain(testUri));
        Assert.assertEquals((Object)("info:fedora/" + baseUid), (Object)fedoraId);
        String httpUri = this.converter.toExternalId(fedoraId);
        Assert.assertEquals((Object)(uriBase + testUri), (Object)httpUri);
    }

    @Test
    public void testFirstLevelWithAcl() {
        String testUri = "/" + HttpIdentifierConverterTest.getUniqueId() + "/fcr:acl";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testFirstLevelWithMetadata() {
        String baseUid = HttpIdentifierConverterTest.getUniqueId();
        String testUri = "/" + baseUid + "/fcr:metadata";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testFirstLevelWithVersions() {
        String baseUid = HttpIdentifierConverterTest.getUniqueId();
        String testUri = "/" + baseUid + "/fcr:versions";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testFirstLevelWithMemento() {
        String memento = "20190926133245";
        String baseUid = HttpIdentifierConverterTest.getUniqueId();
        String testUri = "/" + baseUid + "/fcr:versions/20190926133245";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testSecondLevel() {
        String testUri = "/" + HttpIdentifierConverterTest.getUniqueId() + "/" + HttpIdentifierConverterTest.getUniqueId();
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testSecondLevelWithAcl() {
        String baseUid = "/" + HttpIdentifierConverterTest.getUniqueId() + "/" + HttpIdentifierConverterTest.getUniqueId();
        String testUri = baseUid + "/fcr:acl";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testSecondLevelWithMetadata() {
        String baseUid = "/" + HttpIdentifierConverterTest.getUniqueId() + "/" + HttpIdentifierConverterTest.getUniqueId();
        String testUri = baseUid + "/fcr:metadata";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testSecondLevelWithVersions() {
        String baseUid = "/" + HttpIdentifierConverterTest.getUniqueId() + "/" + HttpIdentifierConverterTest.getUniqueId();
        String testUri = baseUid + "/fcr:versions";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testSecondLevelWithMemento() {
        String memento = "20190926133245";
        String baseUid = "/" + HttpIdentifierConverterTest.getUniqueId() + "/" + HttpIdentifierConverterTest.getUniqueId();
        String testUri = baseUid + "/fcr:versions/20190926133245";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testItemWithDoubleAcl() {
        String baseUid = HttpIdentifierConverterTest.getUniqueId();
        String testUri = "/" + baseUid + "/fcr:acl/fcr:acl";
        String external = uriBase + testUri;
        String internal = "info:fedora" + testUri;
        String fedoraId = this.converter.toInternalId(external);
        Assert.assertEquals((Object)internal, (Object)fedoraId);
        String httpUri = this.converter.toExternalId(internal);
        Assert.assertEquals((Object)external, (Object)httpUri);
    }

    @Test
    public void testWithEncodedColon() {
        String externalOriginal = "http://localhost:8080/some/some%3Atest";
        String internal = "info:fedora/some:test";
        String externalNew = "http://localhost:8080/some/some:test";
        String fedoraId = this.converter.toInternalId("http://localhost:8080/some/some%3Atest");
        Assert.assertEquals((Object)"info:fedora/some:test", (Object)fedoraId);
        String httpUri = this.converter.toExternalId("info:fedora/some:test");
        Assert.assertEquals((Object)"http://localhost:8080/some/some:test", (Object)httpUri);
    }

    @Test
    public void testBlankPathToId() {
        String testUri = "";
        FedoraId fedoraUri = this.converter.pathToInternalId("");
        Assert.assertEquals((Object)FedoraId.getRepositoryRootId(), (Object)fedoraUri);
    }

    @Test
    public void testSinglePathToId() {
        String externalOriginal = "/object";
        FedoraId internal = FedoraId.create((String[])new String[]{"object"});
        FedoraId id = this.converter.pathToInternalId("/object");
        Assert.assertEquals((Object)internal, (Object)id);
        String externalOriginal2 = "object";
        FedoraId id2 = this.converter.pathToInternalId("object");
        Assert.assertEquals((Object)internal, (Object)id2);
    }

    @Test
    public void testDoublePathToId() {
        String externalOriginal = "/object/child";
        FedoraId internal = FedoraId.create((String[])new String[]{"object", "child"});
        FedoraId id = this.converter.pathToInternalId("/object/child");
        Assert.assertEquals((Object)internal, (Object)id);
        String externalOriginal2 = "object/child";
        FedoraId id2 = this.converter.pathToInternalId("object/child");
        Assert.assertEquals((Object)internal, (Object)id2);
    }

    private static String getUniqueId() {
        return UUID.randomUUID().toString();
    }
}

