/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.jena.query.QueryParseException;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class QueryParseExceptionMapper
implements ExceptionMapper<QueryParseException>,
ExceptionDebugLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryParseExceptionMapper.class);

    public Response toResponse(QueryParseException e) {
        Pattern namespacePattern;
        Matcher namespaceMatch;
        LOGGER.error("Captured a query parse exception {}", (Object)e.getMessage());
        this.debugException(this, (Throwable)e, LOGGER);
        if (e.getMessage().matches(".* Unresolved prefixed name: .*") && (namespaceMatch = (namespacePattern = Pattern.compile("Unresolved prefixed name: (\\w+:\\w+)")).matcher(e.getMessage())).find()) {
            String msg = String.format("There are one or more undefined namespace(s) in your request [ %s ], please define them before retrying", namespaceMatch.group(1));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).type("text/plain;charset=utf-8").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).type("text/plain;charset=utf-8").build();
    }
}

