/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.kernel.api.RdfLexicon;
import org.glassfish.jersey.message.internal.HttpHeaderReader;

public class PreferTag
implements Comparable<PreferTag> {
    private final String tag;
    private String value = "";
    private Map<String, String> params = new HashMap<String, String>();

    public static PreferTag emptyTag() {
        return new PreferTag((String)null);
    }

    protected PreferTag(PreferTag preferTag) {
        this.tag = preferTag.getTag();
        this.value = preferTag.getValue();
        this.params = preferTag.getParams();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PreferTag(HttpHeaderReader reader) {
        reader.hasNext();
        if (reader.hasNext()) {
            try {
                this.tag = Optional.ofNullable(reader.nextToken()).map(CharSequence::toString).orElse(null);
                if (reader.hasNextSeparator('=', true)) {
                    reader.next();
                    this.value = Optional.ofNullable(reader.nextTokenOrQuotedString()).map(CharSequence::toString).orElse(null);
                }
                if (!reader.hasNext()) return;
                this.params = HttpHeaderReader.readParameters((HttpHeaderReader)reader);
                if (this.params != null) return;
                this.params = new HashMap<String, String>();
                return;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse 'Prefer' header", e);
            }
        } else {
            this.tag = "";
        }
    }

    public PreferTag(String inputTag) {
        this(HttpHeaderReader.newInstance((String)inputTag));
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void addResponseHeaders(HttpServletResponse servletResponse) {
        String receivedParam = Optional.ofNullable(this.params.get("received")).orElse("");
        List<String> includes = Arrays.asList(Optional.ofNullable(this.params.get("include")).orElse(" ").split(" "));
        List<String> omits = Arrays.asList(Optional.ofNullable(this.params.get("omit")).orElse(" ").split(" "));
        StringBuilder includeBuilder = new StringBuilder();
        StringBuilder omitBuilder = new StringBuilder();
        if (!this.value.equals("minimal") && !receivedParam.equals("minimal")) {
            List<String> appliedPrefs = Arrays.asList(RdfLexicon.PREFER_SERVER_MANAGED.toString(), RdfLexicon.PREFER_MINIMAL_CONTAINER.toString(), RdfLexicon.PREFER_MEMBERSHIP.toString(), RdfLexicon.PREFER_CONTAINMENT.toString());
            List<String> includePrefs = Arrays.asList(RdfLexicon.EMBED_CONTAINED.toString(), RdfLexicon.INBOUND_REFERENCES.toString());
            includes.forEach(param -> includeBuilder.append((String)(appliedPrefs.contains(param) || includePrefs.contains(param) ? param + " " : "")));
            omits.forEach(param -> omitBuilder.append((String)(appliedPrefs.contains(param) && !includes.contains(param) ? param + " " : "")));
        }
        String appliedReturn = this.value.equals("minimal") ? "return=minimal" : "return=representation";
        String appliedReceived = receivedParam.equals("minimal") ? "received=minimal" : "";
        StringBuilder preferenceAppliedBuilder = new StringBuilder(appliedReturn);
        preferenceAppliedBuilder.append((String)(appliedReceived.length() > 0 ? "; " + appliedReceived : ""));
        this.appendHeaderParam(preferenceAppliedBuilder, "include", includeBuilder.toString().trim());
        this.appendHeaderParam(preferenceAppliedBuilder, "omit", omitBuilder.toString().trim());
        servletResponse.addHeader("Preference-Applied", preferenceAppliedBuilder.toString().trim());
        servletResponse.addHeader("Vary", "Prefer");
    }

    private void appendHeaderParam(StringBuilder builder, String paramName, String paramValue) {
        if (paramValue.length() > 0) {
            builder.append("; " + paramName + "=\"" + paramValue.trim() + "\"");
        }
    }

    @Override
    public int compareTo(PreferTag otherTag) {
        return this.getTag().compareTo(otherTag.getTag());
    }

    public boolean equals(Object obj) {
        if (obj instanceof PreferTag) {
            return this.getTag().equals(((PreferTag)obj).getTag());
        }
        return false;
    }

    public int hashCode() {
        if (this.getTag() == null) {
            return 0;
        }
        return this.getTag().hashCode();
    }
}

