/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fcrepo.http.commons.domain.PreferTag;

public class SinglePrefer {
    private final Set<PreferTag> preferTags = new TreeSet<PreferTag>();

    public SinglePrefer(String header) {
        this.preferTags.addAll(Arrays.stream(header.split(",")).map(PreferTag::new).collect(Collectors.toSet()));
    }

    public Boolean hasReturn() {
        return this.preferTags().stream().map(PreferTag::getTag).anyMatch("return"::equals);
    }

    public Boolean hasHandling() {
        return this.preferTags().stream().map(PreferTag::getTag).anyMatch("handling"::equals);
    }

    public PreferTag getReturn() {
        return this.preferTags().stream().filter(x -> x.getTag().equals("return")).findFirst().orElse(PreferTag.emptyTag());
    }

    public PreferTag getHandling() {
        return this.preferTags().stream().filter(x -> x.getTag().equals("handling")).findFirst().orElse(PreferTag.emptyTag());
    }

    protected Set<PreferTag> preferTags() {
        return this.preferTags;
    }
}

