/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.api.rdf;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.ws.rs.core.UriBuilder;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.glassfish.jersey.uri.UriTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpIdentifierConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpIdentifierConverter.class);
    private final UriBuilder uriBuilder;
    private final UriTemplate uriTemplate;

    private static String trimTrailingSlashes(String string) {
        return string.replaceAll("/+$", "");
    }

    public HttpIdentifierConverter(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
        this.uriTemplate = new UriTemplate(uriBuilder.toTemplate());
    }

    public String toInternalId(String httpUri) {
        return this.toInternalId(httpUri, false);
    }

    public String toInternalId(String httpUri, boolean encoded) {
        LOGGER.trace("Translating http URI {} to Fedora ID with encoded set to {}", (Object)httpUri, (Object)encoded);
        String path = this.getPath(httpUri);
        if (path != null) {
            String decodedPath = !encoded ? URLDecoder.decode(path, StandardCharsets.UTF_8) : path;
            String fedoraId = HttpIdentifierConverter.trimTrailingSlashes(decodedPath);
            return "info:fedora" + fedoraId;
        }
        throw new IllegalArgumentException("Cannot translate NULL path extracted from URI " + httpUri);
    }

    public boolean inExternalDomain(String httpUri) {
        LOGGER.trace("Checking if http URI {} is in domain", (Object)httpUri);
        return this.getPath(httpUri) != null;
    }

    public String translateUri(String httpUri) {
        if (this.inExternalDomain(httpUri)) {
            return this.toInternalId(httpUri, true);
        }
        if (httpUri.startsWith("/")) {
            URI uri = this.uriBuilder.build(new Object[]{"placeholder"});
            return uri.resolve(httpUri).toString();
        }
        return httpUri;
    }

    public String toExternalId(String fedoraId) {
        LOGGER.trace("Translating Fedora ID {} to Http URI", (Object)fedoraId);
        if (this.inInternalDomain(fedoraId)) {
            String path = fedoraId.substring("info:fedora".length()).replaceFirst("/", "");
            return this.buildUri(path);
        }
        throw new IllegalArgumentException("Cannot translate IDs without our prefix");
    }

    public boolean inInternalDomain(String fedoraId) {
        LOGGER.trace("Checking if fedora ID {} is in domain", (Object)fedoraId);
        return fedoraId.startsWith("info:fedora");
    }

    private UriBuilder uriBuilder() {
        return UriBuilder.fromUri((String)this.uriBuilder.toTemplate());
    }

    public String toDomain(String path) {
        String realPath = path == null ? "" : (path.startsWith("/") ? path.substring(1) : path);
        return this.buildUri(realPath);
    }

    public FedoraId pathToInternalId(String externalPath) {
        return FedoraId.create((String[])new String[]{externalPath});
    }

    private String buildUri(String path) {
        UriBuilder uri = this.uriBuilder();
        if (path.contains("#")) {
            String[] split = path.split("#", 2);
            uri.resolveTemplateFromEncoded("path", (Object)split[0]);
            uri.fragment(split[1]);
        } else {
            uri.resolveTemplateFromEncoded("path", (Object)path);
        }
        return uri.build(new Object[0]).toString();
    }

    private String getPath(String httpUri) {
        HashMap values = new HashMap();
        if (this.uriTemplate.match((CharSequence)httpUri, values) && values.containsKey("path")) {
            return "/" + (String)values.get("path");
        }
        if (this.isRootWithoutTrailingSlash(httpUri)) {
            return "/";
        }
        return null;
    }

    private boolean isRootWithoutTrailingSlash(String httpUri) {
        HashMap values = new HashMap();
        return this.uriTemplate.match((CharSequence)(httpUri + "/"), values) && values.containsKey("path") && ((String)values.get("path")).isEmpty();
    }
}

