/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.test.util;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.fcrepo.http.commons.webxml.WebAppConfig;
import org.fcrepo.http.commons.webxml.bind.ContextParam;
import org.fcrepo.http.commons.webxml.bind.Filter;
import org.fcrepo.http.commons.webxml.bind.FilterMapping;
import org.fcrepo.http.commons.webxml.bind.InitParam;
import org.fcrepo.http.commons.webxml.bind.Listener;
import org.fcrepo.http.commons.webxml.bind.Servlet;
import org.fcrepo.http.commons.webxml.bind.UrlMappable;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ContainerWrapper
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ContainerWrapper.class);
    private static final int DEFAULT_PORT = 8080;
    @Value(value="${fcrepo.dynamic.test.port:8080}")
    private String port;
    private HttpServer server;
    private WebappContext appContext;
    private String configLocation;

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation.replaceFirst("^classpath:", "/");
    }

    public void setPort(int port) {
        this.port = Integer.toString(port);
    }

    private int resolvePort() {
        if (Strings.isNullOrEmpty((String)this.port)) {
            return 8080;
        }
        return Integer.parseInt(this.port);
    }

    @PostConstruct
    public void start() throws Exception {
        Collection<UrlMappable> mappings;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WebAppConfig.class});
        Unmarshaller u = context.createUnmarshaller();
        WebAppConfig o = (WebAppConfig)u.unmarshal(this.getClass().getResource(this.configLocation));
        URI uri = URI.create("http://localhost:" + this.resolvePort());
        this.server = GrizzlyHttpServerFactory.createHttpServer((URI)uri);
        this.appContext = new WebappContext(o.displayName(), "/");
        for (ContextParam p : o.contextParams()) {
            this.appContext.addContextInitParameter(p.name(), p.value());
        }
        for (Listener l : o.listeners()) {
            this.appContext.addListener(l.className());
        }
        for (Servlet s : o.servlets()) {
            ServletRegistration servlet = this.appContext.addServlet(s.servletName(), s.servletClass());
            mappings = o.servletMappings(s.servletName());
            for (UrlMappable sm : mappings) {
                servlet.addMapping(new String[]{sm.urlPattern()});
            }
            for (InitParam p : s.initParams()) {
                servlet.setInitParameter(p.name(), p.value());
            }
        }
        for (Filter f : o.filters()) {
            FilterRegistration filter = this.appContext.addFilter(f.filterName(), f.filterClass());
            mappings = o.filterMappings(f.filterName());
            for (UrlMappable sm : mappings) {
                String urlPattern = sm.urlPattern();
                String servletName = ((FilterMapping)sm).servletName();
                if (urlPattern != null) {
                    filter.addMappingForUrlPatterns(null, new String[]{urlPattern});
                    continue;
                }
                filter.addMappingForServletNames(null, new String[]{servletName});
            }
            for (InitParam p : f.initParams()) {
                filter.setInitParameter(p.name(), p.value());
            }
        }
        this.appContext.deploy(this.server);
        logger.debug("started grizzly webserver endpoint at " + this.server.getHttpHandler().getName());
    }

    @PreDestroy
    public void stop() {
        try {
            this.appContext.undeploy();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.server.shutdownNow();
        }
    }

    public ApplicationContext getSpringAppContext() {
        return WebApplicationContextUtils.findWebApplicationContext((ServletContext)this.appContext);
    }

    public void setApplicationContext(ApplicationContext springAppContext) throws BeansException {
    }
}

