/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain.ldp;

import org.fcrepo.http.commons.domain.PreferTag;
import org.fcrepo.http.commons.domain.ldp.LdpPreferTag;
import org.fcrepo.kernel.api.RdfLexicon;
import org.junit.Assert;
import org.junit.Test;

public class LdpPreferTagTest {
    private LdpPreferTag testObj;

    @Test
    public void testDefaultDecisions() {
        PreferTag prefer = PreferTag.emptyTag();
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertFalse((boolean)this.testObj.displayReferences());
        Assert.assertTrue((boolean)this.testObj.displayContainment());
        Assert.assertTrue((boolean)this.testObj.displayMembership());
        Assert.assertFalse((boolean)this.testObj.displayEmbed());
    }

    @Test
    public void testMinimalContainer() {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + String.valueOf(RdfLexicon.PREFER_MINIMAL_CONTAINER) + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertFalse((boolean)this.testObj.displayReferences());
        Assert.assertFalse((boolean)this.testObj.displayContainment());
        Assert.assertFalse((boolean)this.testObj.displayMembership());
        Assert.assertFalse((boolean)this.testObj.displayEmbed());
    }

    @Test
    public void testPreferMembership() {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + String.valueOf(RdfLexicon.PREFER_MINIMAL_CONTAINER) + " " + String.valueOf(RdfLexicon.PREFER_MEMBERSHIP) + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertFalse((boolean)this.testObj.displayReferences());
        Assert.assertFalse((boolean)this.testObj.displayContainment());
        Assert.assertTrue((boolean)this.testObj.displayMembership());
        Assert.assertFalse((boolean)this.testObj.displayEmbed());
    }

    @Test
    public void testPreferContainment() {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + String.valueOf(RdfLexicon.PREFER_MINIMAL_CONTAINER) + " " + String.valueOf(RdfLexicon.PREFER_CONTAINMENT) + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertFalse((boolean)this.testObj.displayReferences());
        Assert.assertTrue((boolean)this.testObj.displayContainment());
        Assert.assertFalse((boolean)this.testObj.displayMembership());
        Assert.assertFalse((boolean)this.testObj.displayEmbed());
    }

    @Test
    public void testPreferContainmentAndMembership() {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + String.valueOf(RdfLexicon.PREFER_MEMBERSHIP) + " " + String.valueOf(RdfLexicon.PREFER_CONTAINMENT) + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertFalse((boolean)this.testObj.displayReferences());
        Assert.assertTrue((boolean)this.testObj.displayContainment());
        Assert.assertTrue((boolean)this.testObj.displayMembership());
        Assert.assertFalse((boolean)this.testObj.displayEmbed());
    }

    @Test
    public void testPreferOmitContainmentAndMembership() {
        PreferTag prefer = new PreferTag("return=representation; omit=\"" + String.valueOf(RdfLexicon.PREFER_MEMBERSHIP) + " " + String.valueOf(RdfLexicon.PREFER_CONTAINMENT) + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertFalse((boolean)this.testObj.displayReferences());
        Assert.assertFalse((boolean)this.testObj.displayContainment());
        Assert.assertFalse((boolean)this.testObj.displayMembership());
        Assert.assertFalse((boolean)this.testObj.displayEmbed());
    }

    @Test
    public void testPreferReference() {
        PreferTag prefer = new PreferTag("return=representation; include=\"" + String.valueOf(RdfLexicon.INBOUND_REFERENCES) + "\"");
        this.testObj = new LdpPreferTag(prefer);
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertTrue((boolean)this.testObj.displayReferences());
        Assert.assertTrue((boolean)this.testObj.displayContainment());
        Assert.assertTrue((boolean)this.testObj.displayMembership());
        Assert.assertFalse((boolean)this.testObj.displayEmbed());
    }

    @Test
    public void testEmbedContained() {
        this.testObj = new LdpPreferTag(new PreferTag("return=representation; include=\"" + String.valueOf(RdfLexicon.EMBED_CONTAINED) + "\""));
        Assert.assertTrue((boolean)this.testObj.displayUserRdf());
        Assert.assertTrue((boolean)this.testObj.displayServerManaged());
        Assert.assertFalse((boolean)this.testObj.displayReferences());
        Assert.assertTrue((boolean)this.testObj.displayContainment());
        Assert.assertTrue((boolean)this.testObj.displayMembership());
        Assert.assertTrue((boolean)this.testObj.displayEmbed());
    }
}

