/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.webxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.fcrepo.http.commons.webxml.bind.ContextParam;
import org.fcrepo.http.commons.webxml.bind.Displayable;
import org.fcrepo.http.commons.webxml.bind.Filter;
import org.fcrepo.http.commons.webxml.bind.FilterMapping;
import org.fcrepo.http.commons.webxml.bind.Listener;
import org.fcrepo.http.commons.webxml.bind.Servlet;
import org.fcrepo.http.commons.webxml.bind.ServletMapping;

@XmlRootElement(namespace="http://java.sun.com/xml/ns/javaee", name="web-app")
public class WebAppConfig
extends Displayable {
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="context-param")})
    List<ContextParam> contextParams;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="listener")})
    List<Listener> listeners;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="servlet")})
    List<Servlet> servlets;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="filter")})
    List<Filter> filters;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="servlet-mapping")})
    List<ServletMapping> servletMappings;
    @XmlElements(value={@XmlElement(namespace="http://java.sun.com/xml/ns/javaee", name="filter-mapping")})
    List<FilterMapping> filterMappings;
    private static final List<ContextParam> NO_CP = Collections.unmodifiableList(new ArrayList(0));
    private static final List<Servlet> NO_S = Collections.unmodifiableList(new ArrayList(0));
    private static final List<Filter> NO_F = Collections.unmodifiableList(new ArrayList(0));
    private static final List<Listener> NO_L = Collections.unmodifiableList(new ArrayList(0));

    public Collection<ServletMapping> servletMappings(String servletName) {
        return this.servletMappings.stream().filter(new SMapFilter(servletName)).collect(Collectors.toList());
    }

    public Collection<FilterMapping> filterMappings(String filterName) {
        return this.filterMappings.stream().filter(new FMapFilter(filterName)).collect(Collectors.toList());
    }

    public Collection<ContextParam> contextParams() {
        return this.contextParams != null ? this.contextParams : NO_CP;
    }

    public Collection<Servlet> servlets() {
        return this.servlets != null ? this.servlets : NO_S;
    }

    public Collection<Filter> filters() {
        return this.filters != null ? this.filters : NO_F;
    }

    public Collection<Listener> listeners() {
        return this.listeners != null ? this.listeners : NO_L;
    }

    private static class SMapFilter
    implements Predicate<ServletMapping> {
        final String servletName;

        SMapFilter(String sName) {
            this.servletName = sName;
        }

        @Override
        public boolean test(ServletMapping input) {
            return this.servletName == null ? input.servletName() == null : this.servletName.equals(input.servletName());
        }
    }

    private static class FMapFilter
    implements Predicate<FilterMapping> {
        final String filterName;

        FMapFilter(String sName) {
            this.filterName = sName;
        }

        @Override
        public boolean test(FilterMapping input) {
            return this.filterName == null ? input.filterName() == null : this.filterName.equals(input.filterName());
        }
    }
}

