/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Range {
    private final long start;
    private final long end;
    private static final Pattern rangePattern = Pattern.compile("^bytes\\s*=\\s*(\\d*)\\s*-\\s*(\\d*)");

    private Range() {
        this(-1L, -1L);
    }

    protected Range(long start) {
        this(start, -1L);
    }

    private Range(long start, long end) {
        this.start = start;
        this.end = end;
    }

    protected boolean hasRange() {
        return this.start != -1L || this.end != -1L;
    }

    protected long size() {
        if (this.end == -1L) {
            return -1L;
        }
        if (this.start == -1L) {
            return this.end;
        }
        return this.end - this.start + 1L;
    }

    protected long start() {
        return this.start;
    }

    protected long end() {
        return this.end;
    }

    public static Range convert(String source) {
        Matcher matcher = rangePattern.matcher(source);
        if (!matcher.matches()) {
            return new Range();
        }
        String from = matcher.group(1);
        String to = matcher.group(2);
        long start = from.equals("") ? -1L : Long.parseLong(from);
        long end = to.equals("") ? -1L : Long.parseLong(to);
        return new Range(start, end);
    }

    public RangeOfLength rangeOfLength(long length) {
        long end = this.end() == -1L || this.end() >= length || this.start() == -1L ? length - 1L : this.end();
        long start = this.start() == -1L ? length - this.size() : this.start();
        return new RangeOfLength(start, end, length);
    }

    public static class RangeOfLength {
        private final long start;
        private final long end;
        private final boolean satisfiable;

        protected RangeOfLength(long start, long end, long length) {
            this.start = start;
            this.end = end;
            this.satisfiable = start < length && (this.end() == -1L || end >= start) && start != -1L && end != -1L;
        }

        public long start() {
            return this.start;
        }

        public String startAsString() {
            return Long.toString(this.start);
        }

        public long end() {
            return this.end;
        }

        public String endAsString() {
            return Long.toString(this.end);
        }

        public boolean isSatisfiable() {
            return this.satisfiable;
        }

        public long size() {
            return this.end - this.start + 1L;
        }
    }
}

