/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain.ldp;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.jena.rdf.model.Property;
import org.fcrepo.http.commons.domain.PreferTag;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.rdf.LdpTriplePreferences;

public class LdpPreferTag
extends PreferTag
implements LdpTriplePreferences {
    private final LdpTriplePreferences.PreferChoice minimal;
    private final LdpTriplePreferences.PreferChoice membership;
    private final LdpTriplePreferences.PreferChoice containment;
    private final LdpTriplePreferences.PreferChoice references;
    private final LdpTriplePreferences.PreferChoice embed;
    private final LdpTriplePreferences.PreferChoice managedProperties;
    final List<String> includes;
    final List<String> omits;

    public LdpPreferTag(PreferTag preferTag) {
        super(preferTag);
        Optional<String> include = Optional.ofNullable(preferTag.getParams().get("include"));
        Optional<String> omit = Optional.ofNullable(preferTag.getParams().get("omit"));
        this.includes = Arrays.asList(include.orElse(" ").split(" "));
        this.omits = Arrays.asList(omit.orElse(" ").split(" "));
        this.minimal = this.getChoice(RdfLexicon.PREFER_MINIMAL_CONTAINER);
        this.membership = this.getChoice(RdfLexicon.PREFER_MEMBERSHIP);
        this.containment = this.getChoice(RdfLexicon.PREFER_CONTAINMENT);
        this.references = this.getChoice(RdfLexicon.INBOUND_REFERENCES);
        this.embed = this.getChoice(RdfLexicon.EMBED_CONTAINED);
        this.managedProperties = this.getChoice(RdfLexicon.PREFER_SERVER_MANAGED);
    }

    private LdpTriplePreferences.PreferChoice getChoice(Property tag) {
        if (this.includes.contains(tag.toString())) {
            return LdpTriplePreferences.PreferChoice.INCLUDE;
        }
        if (this.omits.contains(tag.toString())) {
            return LdpTriplePreferences.PreferChoice.EXCLUDE;
        }
        return LdpTriplePreferences.PreferChoice.SILENT;
    }

    public boolean displayUserRdf() {
        return !this.minimal.equals((Object)LdpTriplePreferences.PreferChoice.EXCLUDE);
    }

    public boolean displayMembership() {
        return this.membership.equals((Object)LdpTriplePreferences.PreferChoice.INCLUDE) || this.notIncludeMinimal() && this.notExcludeManaged() && !this.membership.equals((Object)LdpTriplePreferences.PreferChoice.EXCLUDE);
    }

    public boolean displayContainment() {
        return this.containment.equals((Object)LdpTriplePreferences.PreferChoice.INCLUDE) || this.notIncludeMinimal() && this.notExcludeManaged() && !this.containment.equals((Object)LdpTriplePreferences.PreferChoice.EXCLUDE);
    }

    public boolean displayReferences() {
        return this.references.equals((Object)LdpTriplePreferences.PreferChoice.INCLUDE);
    }

    public boolean displayEmbed() {
        return this.embed.equals((Object)LdpTriplePreferences.PreferChoice.INCLUDE);
    }

    public boolean displayServerManaged() {
        return !this.minimal.equals((Object)LdpTriplePreferences.PreferChoice.EXCLUDE) && this.notExcludeManaged();
    }

    private boolean notIncludeMinimal() {
        return !this.minimal.equals((Object)LdpTriplePreferences.PreferChoice.INCLUDE);
    }

    private boolean notExcludeManaged() {
        return !this.managedProperties.equals((Object)LdpTriplePreferences.PreferChoice.EXCLUDE);
    }
}

