/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.http.commons.api.rdf.HttpIdentifierConverter;
import org.fcrepo.http.commons.domain.RDFMediaType;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.fcrepo.http.commons.responses.ConcurrentExceptionResponse;
import org.fcrepo.kernel.api.exception.ConcurrentUpdateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ConcurrentUpdateExceptionMapper
implements ExceptionMapper<ConcurrentUpdateException>,
ExceptionDebugLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentUpdateExceptionMapper.class);
    @Inject
    private FedoraPropsConfig config;
    @Context
    private UriInfo uriInfo;

    public Response toResponse(ConcurrentUpdateException e) {
        this.debugException(this, (Throwable)e, LOGGER);
        ConcurrentExceptionResponse response = new ConcurrentExceptionResponse(e.getResponseMessage());
        if (this.config.includeTransactionOnConflict()) {
            HttpIdentifierConverter identifierConverter = new HttpIdentifierConverter(this.uriInfo.getBaseUriBuilder().clone().path("/{path: .*}"));
            String existingId = "info:fedora/fcr:tx/" + e.getExistingTransactionId();
            String conflictingId = "info:fedora/fcr:tx/" + e.getConflictingTransactionId();
            response.setExistingTransactionId(identifierConverter.toExternalId(existingId));
            response.setConflictingTransactionId(identifierConverter.toExternalId(conflictingId));
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)response).type(RDFMediaType.APPLICATION_JSON_TYPE).build();
    }
}

