/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.fcrepo.http.commons.exceptionhandlers.ExceptionDebugLogging;
import org.fcrepo.kernel.api.exception.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RepositoryExceptionMapper
implements ExceptionMapper<RepositoryException>,
ExceptionDebugLogging {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryExceptionMapper.class);

    public Response toResponse(RepositoryException e) {
        LOGGER.error("Caught a repository exception", (Throwable)e);
        if (e.getMessage().matches("Error converting \".+\" from String to a Name")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).type("text/plain;charset=utf-8").build();
        }
        return Response.serverError().entity((Object)e.getMessage()).type("text/plain;charset=utf-8").build();
    }
}

