/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.responses;

import com.google.common.util.concurrent.AbstractFuture;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NsIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.fcrepo.http.commons.responses.SynchonizedStreamRDFWrapper;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfStreamStreamingOutput
extends AbstractFuture<Void>
implements StreamingOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfStreamStreamingOutput.class);
    private static final String JSONLD_COMPACTED = "http://www.w3.org/ns/json-ld#compacted";
    private static final String JSONLD_FLATTENED = "http://www.w3.org/ns/json-ld#flattened";
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private final Lang format;
    private final MediaType mediaType;
    private final RdfStream rdfStream;
    private final Map<String, String> namespaces;

    public RdfStreamStreamingOutput(RdfStream rdfStream, Map<String, String> namespaces, MediaType mediaType) {
        Lang format2;
        if (LOGGER.isDebugEnabled()) {
            RDFLanguages.getRegisteredLanguages().forEach(format -> LOGGER.debug("Discovered RDF writer writeableFormats: {} with mimeTypes: {}", (Object)format.getName(), (Object)String.join((CharSequence)" ", format.getAltContentTypes())));
        }
        if ((format2 = RDFLanguages.contentTypeToLang((String)(mediaType.getType() + "/" + mediaType.getSubtype()))) == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        this.format = format2;
        this.mediaType = mediaType;
        LOGGER.debug("Setting up to serialize to: {}", (Object)format2);
        this.rdfStream = rdfStream;
        this.namespaces = namespaces;
    }

    public void write(OutputStream output) {
        try {
            LOGGER.debug("Serializing RDF stream in: {}", (Object)this.format);
            RdfStreamStreamingOutput.write(this.rdfStream, output, this.format, this.mediaType, this.namespaces);
        }
        catch (RiotException e) {
            this.setException(e);
            LOGGER.debug("Error serializing RDF: {}", (Object)e.getMessage());
            throw new WebApplicationException((Throwable)e);
        }
    }

    private static void write(RdfStream rdfStream, OutputStream output, Lang dataFormat, MediaType dataMediaType, Map<String, String> nsPrefixes) {
        RDFFormat format = StreamRDFWriter.defaultSerialization((Lang)dataFormat);
        if (format != null) {
            LOGGER.debug("Stream-based serialization of {}", (Object)dataFormat.toString());
            if (RDFFormat.NTRIPLES.equals((Object)format)) {
                RdfStreamStreamingOutput.serializeNTriples(rdfStream, format, output);
            } else {
                RdfStreamStreamingOutput.serializeBlockStreamed(rdfStream, output, format, nsPrefixes);
            }
        } else {
            LOGGER.debug("Non-stream serialization of {}", (Object)dataFormat.toString());
            RdfStreamStreamingOutput.serializeNonStreamed(rdfStream, output, dataFormat, dataMediaType, nsPrefixes);
        }
    }

    private static void serializeNTriples(RdfStream rdfStream, RDFFormat format, OutputStream output) {
        SynchonizedStreamRDFWrapper stream = new SynchonizedStreamRDFWrapper(StreamRDFWriter.getWriterStream((OutputStream)output, (Lang)format.getLang()));
        stream.start();
        rdfStream.forEach(arg_0 -> ((StreamRDF)stream).triple(arg_0));
        stream.finish();
    }

    private static void serializeBlockStreamed(RdfStream rdfStream, OutputStream output, RDFFormat format, Map<String, String> nsPrefixes) {
        HashSet namespacesPresent = new HashSet();
        SynchonizedStreamRDFWrapper stream = new SynchonizedStreamRDFWrapper(StreamRDFWriter.getWriterStream((OutputStream)output, (Lang)format.getLang()));
        stream.start();
        List<Triple> tripleList = rdfStream.peek(t -> {
            namespacesPresent.add(t.getPredicate().getNameSpace());
            if (RDF_TYPE.equals(t.getPredicate().getURI()) && t.getObject().isURI()) {
                namespacesPresent.add(t.getObject().getNameSpace());
            }
        }).collect(Collectors.toList());
        nsPrefixes.forEach((arg_0, arg_1) -> RdfStreamStreamingOutput.lambda$serializeBlockStreamed$2(namespacesPresent, (StreamRDF)stream, arg_0, arg_1));
        tripleList.forEach(arg_0 -> ((StreamRDF)stream).triple(arg_0));
        stream.finish();
    }

    private static void serializeNonStreamed(RdfStream rdfStream, OutputStream output, Lang dataFormat, MediaType dataMediaType, Map<String, String> nsPrefixes) {
        Model model = (Model)rdfStream.collect(RdfCollectors.toModel());
        model.setNsPrefixes(RdfStreamStreamingOutput.filterNamespacesToPresent(model, nsPrefixes));
        if (Lang.RDFXML.equals((Object)dataFormat)) {
            RDFDataMgr.write((OutputStream)output, (Graph)model.getGraph(), (RDFFormat)RDFFormat.RDFXML_PLAIN);
        } else if (Lang.JSONLD.equals((Object)dataFormat)) {
            RDFFormat jsonldFormat = RdfStreamStreamingOutput.getFormatFromMediaType(dataMediaType);
            RDFDataMgr.write((OutputStream)output, (Graph)model.getGraph(), (RDFFormat)jsonldFormat);
        } else {
            RDFDataMgr.write((OutputStream)output, (Graph)model.getGraph(), (Lang)dataFormat);
        }
    }

    private static Map<String, String> filterNamespacesToPresent(Model model, Map<String, String> nsPrefixes) {
        HashMap<String, String> resultNses = new HashMap<String, String>();
        Set<Map.Entry<String, String>> nsSet = nsPrefixes.entrySet();
        NsIterator nsIt = model.listNameSpaces();
        while (nsIt.hasNext()) {
            String ns = (String)nsIt.next();
            Optional<Map.Entry> nsOpt = nsSet.stream().filter(nsEntry -> ((String)nsEntry.getValue()).equals(ns)).findFirst();
            if (!nsOpt.isPresent()) continue;
            Map.Entry nsMatch = nsOpt.get();
            resultNses.put((String)nsMatch.getKey(), (String)nsMatch.getValue());
        }
        return resultNses;
    }

    private static RDFFormat getFormatFromMediaType(MediaType mediaType) {
        String profile = mediaType.getParameters().getOrDefault("profile", "");
        if (profile.equals(JSONLD_COMPACTED)) {
            return RDFFormat.JSONLD_COMPACT_FLAT;
        }
        if (profile.equals(JSONLD_FLATTENED)) {
            return RDFFormat.JSONLD_FLATTEN_FLAT;
        }
        return RDFFormat.JSONLD_EXPAND_FLAT;
    }

    private static /* synthetic */ void lambda$serializeBlockStreamed$2(Set namespacesPresent, StreamRDF stream, String prefix, String uri) {
        if (namespacesPresent.contains(uri)) {
            stream.prefix(prefix, uri);
        }
    }
}

