/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.domain;

import org.fcrepo.http.commons.domain.Range;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest {
    @Test
    public void testUnboundedRange() {
        Range range = new Range(5L);
        Assert.assertEquals((long)5L, (long)range.start());
        Assert.assertEquals((long)-1L, (long)range.end());
        Assert.assertEquals((long)-1L, (long)range.size());
    }

    @Test
    public void testRangeParsing() {
        Range range = Range.convert((String)"bytes=50-100");
        Assert.assertEquals((long)50L, (long)range.start());
        Assert.assertEquals((long)100L, (long)range.end());
        Assert.assertEquals((long)51L, (long)range.size());
        Assert.assertTrue((boolean)range.hasRange());
    }

    @Test
    public void testUnboundedUpperRangeParsing() {
        Range range = Range.convert((String)"bytes=50-");
        Assert.assertEquals((long)50L, (long)range.start());
        Assert.assertEquals((long)-1L, (long)range.end());
        Assert.assertEquals((long)-1L, (long)range.size());
        Assert.assertTrue((boolean)range.hasRange());
    }

    @Test
    public void testUnboundedLowerRangeParsing() {
        Range range = Range.convert((String)"bytes=-50");
        Assert.assertEquals((long)-1L, (long)range.start());
        Assert.assertEquals((long)50L, (long)range.end());
        Assert.assertEquals((long)50L, (long)range.size());
        Assert.assertTrue((boolean)range.hasRange());
    }

    @Test
    public void testGarbageRangeParsing() {
        Range range = Range.convert((String)"something-thats-not-a-range");
        Assert.assertFalse((boolean)range.hasRange());
    }

    @Test
    public void testRangeIsSatisfiable1() {
        Range range = Range.convert((String)"bytes=0-100");
        Assert.assertTrue((boolean)range.rangeOfLength(101L).isSatisfiable());
        Assert.assertTrue((boolean)range.rangeOfLength(5L).isSatisfiable());
        Assert.assertTrue((boolean)range.rangeOfLength(10L).isSatisfiable());
        Assert.assertTrue((boolean)range.rangeOfLength(200L).isSatisfiable());
    }

    @Test
    public void testRangeIsSatisfiable2() {
        Range range = Range.convert((String)"bytes=101-200");
        Assert.assertFalse((boolean)range.rangeOfLength(100L).isSatisfiable());
        Assert.assertFalse((boolean)range.rangeOfLength(5L).isSatisfiable());
    }

    @Test
    public void testRangeIsSatisfiable3() {
        Range range = Range.convert((String)"bytes=0-8199");
        Assert.assertTrue((boolean)range.rangeOfLength(9040L).isSatisfiable());
    }

    @Test
    public void testRangeOfContentLength1() {
        Range range = Range.convert((String)"bytes=0-100");
        Range.RangeOfLength rangeOfLength = range.rangeOfLength(200L);
        Assert.assertEquals((long)0L, (long)rangeOfLength.start());
        Assert.assertEquals((long)100L, (long)rangeOfLength.end());
        Assert.assertEquals((long)101L, (long)rangeOfLength.size());
    }

    @Test
    public void testRangeOfContentLength2() {
        Range range = Range.convert((String)"bytes=5-");
        Range.RangeOfLength rangeOfLength = range.rangeOfLength(200L);
        Assert.assertEquals((long)5L, (long)rangeOfLength.start());
        Assert.assertEquals((long)199L, (long)rangeOfLength.end());
        Assert.assertEquals((long)195L, (long)rangeOfLength.size());
    }

    @Test
    public void testRangeOfContentLength3() {
        Range range = Range.convert((String)"bytes=-150");
        Range.RangeOfLength rangeOfLength = range.rangeOfLength(200L);
        Assert.assertEquals((long)50L, (long)rangeOfLength.start());
        Assert.assertEquals((long)199L, (long)rangeOfLength.end());
        Assert.assertEquals((long)150L, (long)rangeOfLength.size());
    }

    @Test
    public void testRangeSizeIsValid() {
        Range range = Range.convert((String)"bytes=0-100");
        Range.RangeOfLength rangeOfLength = range.rangeOfLength(90L);
        Assert.assertEquals((long)0L, (long)rangeOfLength.start());
        Assert.assertEquals((long)89L, (long)rangeOfLength.end());
        Assert.assertEquals((long)90L, (long)rangeOfLength.size());
    }

    @Test
    public void testSpecExamples() {
        Range range1 = Range.convert((String)"bytes=-500");
        Range.RangeOfLength rangeOfLength1 = range1.rangeOfLength(10000L);
        Assert.assertEquals((long)9500L, (long)rangeOfLength1.start());
        Assert.assertEquals((long)9999L, (long)rangeOfLength1.end());
        Assert.assertEquals((long)500L, (long)rangeOfLength1.size());
        Range range2 = Range.convert((String)"bytes=9500-");
        Range.RangeOfLength rangeOfLength2 = range2.rangeOfLength(10000L);
        Assert.assertEquals((long)9500L, (long)rangeOfLength2.start());
        Assert.assertEquals((long)9999L, (long)rangeOfLength2.end());
        Assert.assertEquals((long)500L, (long)rangeOfLength2.size());
    }

    @Test
    public void testZeroRange() {
        Range range = Range.convert((String)"bytes=0-0");
        Range.RangeOfLength rangeOfLength = range.rangeOfLength(100L);
        Assert.assertEquals((long)0L, (long)rangeOfLength.start());
        Assert.assertEquals((long)0L, (long)rangeOfLength.end());
        Assert.assertEquals((long)1L, (long)rangeOfLength.size());
        Assert.assertTrue((boolean)rangeOfLength.isSatisfiable());
    }
}

