/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.http.commons.exceptionhandlers;

import java.net.URI;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ExceptionMapper;
import org.fcrepo.http.commons.api.rdf.HttpIdentifierConverter;
import org.fcrepo.http.commons.exceptionhandlers.TombstoneExceptionMapper;
import org.fcrepo.kernel.api.exception.TombstoneException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TombstoneExceptionMapperTest {
    @Mock
    private FedoraResource mockResource;
    private final FedoraId fedoraId = FedoraId.create((String[])new String[]{"/some:uri"});
    private final Instant deleteTime = Instant.now();
    private ExceptionMapper<TombstoneException> testObj;
    private static final String SERVER_URI = "http://localhost:8080/rest(.*)";
    private final HttpIdentifierConverter idConverter = new HttpIdentifierConverter(UriBuilder.fromUri((String)"http://localhost:8080/rest(.*)"));

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResource.getFedoraId()).thenReturn((Object)this.fedoraId);
        Mockito.when((Object)this.mockResource.getLastModifiedDate()).thenReturn((Object)this.deleteTime);
        this.testObj = new TombstoneExceptionMapper();
    }

    @Test
    public void testUrilessException() {
        Response response = this.testObj.toResponse((Throwable)new TombstoneException(this.mockResource));
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)response.getStatus());
        this.assertTombstone(response, this.fedoraId.getFullIdPath(), null);
    }

    @Test
    public void testExceptionWithUri() {
        String tombstone = this.idConverter.toExternalId(this.fedoraId.asTombstone().getFullId());
        String timemap = this.idConverter.toExternalId(this.fedoraId.resolve("fcr:versions").getFullId());
        Response response = this.testObj.toResponse((Throwable)new TombstoneException(this.mockResource, tombstone, timemap));
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)response.getStatus());
        this.assertTombstone(response, this.fedoraId.getFullIdPath(), tombstone);
        List<Link> links = Arrays.stream(response.getHeaderString("Link").split(",")).map(Link::valueOf).collect(Collectors.toList());
        this.assertLinkHeaderExists(links, timemap, "timemap");
    }

    private void assertTombstone(Response response, String tombstoneAt, String tombstoneUri) {
        if (tombstoneUri == null) {
            Assert.assertNull((Object)response.getHeaderString("Link"));
        } else {
            List<Link> links = Arrays.stream(response.getHeaderString("Link").split(",")).map(Link::valueOf).collect(Collectors.toList());
            this.assertLinkHeaderExists(links, tombstoneUri, "hasTombstone");
        }
        String expectedString = "Discovered tombstone resource at " + tombstoneAt + ", departed at: " + DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).format(this.deleteTime);
        Assert.assertEquals((Object)expectedString, (Object)response.getEntity().toString());
    }

    private void assertLinkHeaderExists(List<Link> links, String uri, String rel) {
        URI uriUri = URI.create(uri);
        if (links.stream().noneMatch(l -> l.getUri().equals(uriUri) && l.getRel().equals(rel))) {
            Assert.fail((String)String.format("Did not find expected Link header with uri (%s) and rel (%s)", uri, rel));
        }
    }
}

