/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Set;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.HttpInputStream;
import org.fcrepo.client.search.SearchResultParser;
import org.fcrepo.client.utility.AutoPurger;
import org.fcrepo.client.utility.ingest.Ingest;
import org.fcrepo.client.utility.ingest.IngestCounter;
import org.fcrepo.common.Constants;
import org.fcrepo.server.access.FedoraAPIA;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.test.FedoraTestCase;
import org.fcrepo.test.ManagedContentTranslator;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class FedoraServerTestCase
extends FedoraTestCase
implements Constants {
    public FedoraServerTestCase() {
    }

    public FedoraServerTestCase(String name) {
        super(name);
    }

    public Document getXMLQueryResult(String location) throws Exception {
        return this.getXMLQueryResult(FedoraServerTestCase.getFedoraClient(), location);
    }

    public Document getXMLQueryResult(FedoraClient client, String location) throws Exception {
        HttpInputStream is = client.get(FedoraServerTestCase.getBaseURL() + location, true, true);
        Document result = XMLUnit.buildControlDocument((InputSource)new InputSource((InputStream)is));
        is.close();
        return result;
    }

    public static boolean testingMETS() {
        String format = System.getProperty("demo.format");
        return format != null && format.equalsIgnoreCase("mets");
    }

    public static boolean testingAtom() {
        String format = System.getProperty("demo.format");
        return format != null && format.equalsIgnoreCase("atom");
    }

    public static boolean testingAtomZip() {
        String format = System.getProperty("demo.format");
        return format != null && format.equalsIgnoreCase("atom-zip");
    }

    public static void ingestDemoObjects() throws Exception {
        FedoraServerTestCase.ingestDemoObjects("/");
    }

    public static void ingestDemoObjects(String path) throws Exception {
        String ingestFormat;
        File dir = null;
        String specificPath = File.separator + path;
        if (FedoraServerTestCase.testingMETS()) {
            System.out.println("Ingesting demo objects in METS format from " + specificPath);
            dir = new File(FEDORA_HOME, "client/demo/mets" + specificPath);
            ingestFormat = FedoraServerTestCase.METS_EXT1_1.uri;
        } else if (FedoraServerTestCase.testingAtom()) {
            System.out.println("Ingesting demo objects in Atom format from " + specificPath);
            dir = new File(FEDORA_HOME, "client/demo/atom" + specificPath);
            ingestFormat = FedoraServerTestCase.ATOM1_1.uri;
        } else if (FedoraServerTestCase.testingAtomZip()) {
            System.out.println("Ingesting all demo objects in Atom Zip format from " + specificPath);
            dir = new File(FEDORA_HOME, "client/demo/atom-zip" + specificPath);
            ingestFormat = FedoraServerTestCase.ATOM_ZIP1_1.uri;
        } else {
            System.out.println("Ingesting demo objects in FOXML format from " + specificPath);
            dir = new File(FEDORA_HOME, "client/demo/foxml" + specificPath);
            ingestFormat = FedoraServerTestCase.FOXML1_1.uri;
        }
        FedoraClient client = FedoraTestCase.getFedoraClient();
        Ingest.multiFromDirectory((File)dir, (String)ingestFormat, (FedoraAPIA)client.getAPIA(), (FedoraAPIM)client.getAPIM(), null, (PrintStream)new PrintStream(File.createTempFile("demo", null)), (IngestCounter)new IngestCounter());
        try {
            ManagedContentTranslator.createManagedClone(client.getAPIM(), "demo:SmileyPens", "demo:SmileyPens_M");
            ManagedContentTranslator.createManagedClone(client.getAPIM(), "demo:SmileyBeerGlass", "demo:SmileyBeerGlass_M");
        }
        catch (Exception e) {
            System.out.println("Could not create managed clone test objects: " + e.getMessage());
        }
    }

    public static Set<String> getDemoObjects() throws Exception {
        FedoraClient client = FedoraServerTestCase.getFedoraClient();
        HttpInputStream queryResult = client.get(FedoraServerTestCase.getBaseURL() + "/search?query=pid~demo:*" + "&maxResults=1000&pid=true&xml=true", true, true);
        SearchResultParser parser = new SearchResultParser((InputStream)queryResult);
        return parser.getPIDs();
    }

    public static void purgeDemoObjects() throws Exception {
        FedoraClient client = FedoraServerTestCase.getFedoraClient();
        FedoraAPIM apim = client.getAPIM();
        for (String pid : FedoraServerTestCase.getDemoObjects()) {
            AutoPurger.purge((FedoraAPIM)apim, (String)pid, null);
        }
    }

    public static void main(String[] args) {
        TestRunner.run(FedoraServerTestCase.class);
    }
}

