/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test;

import junit.extensions.TestSetup;
import junit.framework.Test;
import org.fcrepo.common.Constants;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.test.FedoraTestCase;

public class OneEmptyObjectTestSetup
extends TestSetup
implements Constants {
    private final String m_pid;
    private FedoraAPIM m_apim;

    public OneEmptyObjectTestSetup(Test test, String pid) {
        super(test);
        this.m_pid = pid;
    }

    private static byte[] getTestObjectBytes(String pid) throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<foxml:digitalObject VERSION=\"1.1\" xmlns:xsi=\"" + OneEmptyObjectTestSetup.XSI.uri + "\"\n");
        xml.append("           xmlns:foxml=\"" + OneEmptyObjectTestSetup.FOXML.uri + "\"\n");
        xml.append("           xsi:schemaLocation=\"" + OneEmptyObjectTestSetup.FOXML.uri + " " + OneEmptyObjectTestSetup.FOXML1_1.xsdLocation + "\"\n");
        xml.append("\n           PID=\"" + pid + "\">\n");
        xml.append("  <foxml:objectProperties>\n");
        xml.append("    <foxml:property NAME=\"" + OneEmptyObjectTestSetup.MODEL.LABEL.uri + "\" VALUE=\"label\"/>\n");
        xml.append("  </foxml:objectProperties>\n");
        xml.append("</foxml:digitalObject>");
        return xml.toString().getBytes("UTF-8");
    }

    public void setUp() throws Exception {
        System.out.println("Ingesting test object: " + this.m_pid);
        this.m_apim = FedoraTestCase.getFedoraClient().getAPIM();
        this.m_apim.ingest(OneEmptyObjectTestSetup.getTestObjectBytes(this.m_pid), OneEmptyObjectTestSetup.FOXML1_1.uri, "");
    }

    public void tearDown() throws Exception {
        System.out.println("Purging test object: " + this.m_pid);
        this.m_apim.purgeObject(this.m_pid, "", false);
    }
}

