/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.types.NonNegativeInteger;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Models;
import org.fcrepo.server.access.FedoraAPIA;
import org.fcrepo.server.types.gen.ComparisonOperator;
import org.fcrepo.server.types.gen.Condition;
import org.fcrepo.server.types.gen.DatastreamDef;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.FieldSearchResult;
import org.fcrepo.server.types.gen.MIMETypedStream;
import org.fcrepo.server.types.gen.ObjectFields;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.server.types.gen.ObjectProfile;
import org.fcrepo.server.types.gen.Property;
import org.fcrepo.server.types.gen.RepositoryInfo;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.After;

public class TestAPIA
extends FedoraServerTestCase {
    private FedoraAPIA apia;

    public static Test suite() {
        TestSuite suite = new TestSuite("APIA TestSuite");
        suite.addTestSuite(TestAPIA.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    public void testDescribeRepository() throws Exception {
        RepositoryInfo describe = this.apia.describeRepository();
        TestAPIA.assertTrue((!describe.getRepositoryName().equals("") ? 1 : 0) != 0);
    }

    public void testFindObjects() throws Exception {
        String[] resultFields = new String[]{"pid"};
        NonNegativeInteger maxResults = new NonNegativeInteger("100");
        Condition[] condition = new Condition[]{new Condition("pid", ComparisonOperator.eq, "demo:5")};
        FieldSearchQuery query = new FieldSearchQuery(condition, null);
        FieldSearchResult result = this.apia.findObjects(resultFields, maxResults, query);
        ObjectFields[] fields = result.getResultList();
        TestAPIA.assertEquals((int)1, (int)fields.length);
        TestAPIA.assertEquals((String)"demo:5", (String)fields[0].getPid());
    }

    public void testGetDatastreamDissemination() throws Exception {
        MIMETypedStream ds = null;
        ds = this.apia.getDatastreamDissemination("demo:5", "DC", null);
        String xml = new String(ds.getStream(), "UTF-8");
        this.assertXpathExists("/oai_dc:dc", xml);
        this.assertXpathEvaluatesTo("demo:5", "/oai_dc:dc/dc:identifier/text( )", xml);
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"text/xml");
        ds = this.apia.getDatastreamDissemination("demo:SmileyBeerGlass", "MEDIUM_SIZE", null);
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"image/jpeg");
        TestAPIA.assertTrue((ds.getStream().length > 0 ? 1 : 0) != 0);
        ds = this.apia.getDatastreamDissemination("demo:31", "DS3", null);
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"application/fedora-redirect");
        ds = this.apia.getDatastreamDissemination("demo:5", "THUMBRES_IMG", null);
        TestAPIA.assertEquals((String)ds.getMIMEType(), (String)"image/jpeg");
        TestAPIA.assertTrue((ds.getStream().length > 0 ? 1 : 0) != 0);
    }

    public void testGetDisseminationDefault() throws Exception {
        MIMETypedStream diss = null;
        diss = this.apia.getDissemination("demo:5", "fedora-system:3", "viewDublinCore", new Property[0], null);
        TestAPIA.assertEquals((String)diss.getMIMEType(), (String)"text/html");
        TestAPIA.assertTrue((diss.getStream().length > 0 ? 1 : 0) != 0);
    }

    public void testGetDisseminationUserInput() throws Exception {
        MIMETypedStream diss = null;
        Property[] userInput = new Property[]{new Property("convertTo", "gif")};
        diss = this.apia.getDissemination("demo:29", "demo:27", "convertImage", userInput, null);
        TestAPIA.assertEquals((String)diss.getMIMEType(), (String)"image/gif");
        TestAPIA.assertTrue((diss.getStream().length > 0 ? 1 : 0) != 0);
    }

    public void testObjectHistory() throws Exception {
        String[] timestamps = this.apia.getObjectHistory("demo:5");
        TestAPIA.assertTrue((timestamps.length > 0 ? 1 : 0) != 0);
    }

    public void testGetObjectProfile() throws Exception {
        ObjectProfile profile = this.apia.getObjectProfile("demo:5", null);
        TestAPIA.assertEquals((String)"demo:5", (String)profile.getPid());
        TestAPIA.assertTrue((!profile.getObjDissIndexViewURL().equals("") ? 1 : 0) != 0);
        TestAPIA.assertTrue((!profile.getObjItemIndexViewURL().equals("") ? 1 : 0) != 0);
    }

    public void testGetObjectProfileBasicCModel() throws Exception {
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyGreetingCard"}) {
            ObjectProfile profile = this.apia.getObjectProfile(pid, null);
            boolean found = false;
            for (String objModel : profile.getObjModels()) {
                if (!objModel.equals(Models.FEDORA_OBJECT_CURRENT.uri)) continue;
                found = true;
            }
            TestAPIA.assertTrue((boolean)found);
        }
    }

    public void testListDatastreams() throws Exception {
        DatastreamDef[] dsDefs = this.apia.listDatastreams("demo:5", null);
        TestAPIA.assertEquals((int)6, (int)dsDefs.length);
    }

    public void testListMethods() throws Exception {
        ObjectMethodsDef[] methodDefs = this.apia.listMethods("demo:5", null);
        TestAPIA.assertEquals((int)8, (int)methodDefs.length);
    }

    public void setUp() throws Exception {
        FedoraClient client = TestAPIA.getFedoraClient();
        this.apia = client.getAPIA();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(TestAPIA.OAI_DC.prefix, TestAPIA.OAI_DC.uri);
        nsMap.put(TestAPIA.DC.prefix, TestAPIA.DC.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    public static void main(String[] args) {
        TestRunner.run(TestAPIA.class);
    }
}

