/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.axis.types.NonNegativeInteger;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.common.Constants;
import org.fcrepo.server.access.FedoraAPIA;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.server.types.gen.ComparisonOperator;
import org.fcrepo.server.types.gen.Condition;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.FieldSearchResult;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.TemplatedResourceIterator;

public class TestAPIM2
extends FedoraServerTestCase
implements Constants {
    private FedoraAPIM apim;
    private FedoraAPIA apia;

    public static Test suite() {
        TestSuite suite = new TestSuite("TestAPIM2 TestSuite");
        suite.addTestSuite(TestAPIM2.class);
        return suite;
    }

    public void setUp() throws Exception {
        this.apim = TestAPIM2.getFedoraClient().getAPIM();
        this.apia = TestAPIM2.getFedoraClient().getAPIA();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        nsMap.put("dc", "http://purl.org/dc/elements/1.1/");
        nsMap.put("foxml", "info:fedora/fedora-system:def/foxml#");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        TestAPIM2.purgeDemoObjects();
    }

    public void tearDown() throws Exception {
        TestAPIM2.purgeDemoObjects();
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    public void testIngest() throws Exception {
        byte[] foxml;
        TemplatedResourceIterator tri;
        String resource;
        File resourceFile;
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        String[] resourceFilenames = new File(resourceDirName).list();
        int count = 0;
        for (String resourceFilename : resourceFilenames) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/values");
            while (tri.hasNext()) {
                foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
                ++count;
            }
        }
        TestAPIM2.assertEquals((String)"Ingested object count", (int)count, (int)TestAPIM2.getDemoObjects().size());
        for (String resourceFilename : resourceFilenames) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
                ++count;
            }
        }
        TestAPIM2.assertEquals((String)"Ingested object count", (int)count, (int)TestAPIM2.getDemoObjects().size());
    }

    public void testFieldSearch() throws Exception {
        String[] resourceFilenames;
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        for (String resourceFilename : resourceFilenames = new File(resourceDirName).list()) {
            File resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            TemplatedResourceIterator tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        String[] resultFields = new String[]{"pid", "title"};
        NonNegativeInteger maxResults = new NonNegativeInteger("100");
        String termsTemplate = "$value$";
        TemplatedResourceIterator tri = new TemplatedResourceIterator(termsTemplate, "src/test/resources/APIM2/searchvalues");
        while (tri.hasNext()) {
            FieldSearchResult res;
            FieldSearchQuery query;
            block9: {
                Condition[] conditions = new Condition[]{new Condition("pid", ComparisonOperator.fromString((String)"eq"), tri.getAttributeValue("value"))};
                query = new FieldSearchQuery(conditions, null);
                try {
                    res = this.apia.findObjects(resultFields, maxResults, query);
                }
                catch (RemoteException e) {
                    if (e.getMessage().startsWith("org.fcrepo.server.errors.QueryParseException")) break block9;
                    throw e;
                }
            }
            String terms = tri.next();
            query = new FieldSearchQuery(null, terms);
            try {
                res = this.apia.findObjects(resultFields, maxResults, query);
            }
            catch (RemoteException e) {
                if (e.getMessage().startsWith("org.fcrepo.server.errors.QueryParseException")) continue;
                throw e;
            }
        }
        TestAPIM2.purgeDemoObjects();
        for (String resourceFilename : resourceFilenames) {
            File resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        TestAPIM2.purgeDemoObjects();
    }

    public void testObjectMethods() throws Exception {
        String[] resourceFilenames;
        String resfile = "src/test/resources/APIM2/foxml/demo_SmileyBeerGlass.xml";
        File resourceFile = new File(resfile);
        String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
        TemplatedResourceIterator tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
        while (tri.hasNext()) {
            String label2 = tri.getAttributeValue("label2");
            byte[] foxml = tri.next().getBytes("UTF-8");
            String pid = this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            this.apim.modifyObject(pid, null, label2, null, "updating object label");
        }
        TestAPIM2.purgeDemoObjects();
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        for (String resourceFilename : resourceFilenames = new File(resourceDirName).list()) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        TestAPIM2.purgeDemoObjects();
    }

    public void testDatastreamMethods() throws Exception {
        String[] resourceFilenames;
        String resfile = "src/test/resources/APIM2/foxml/demo_SmileyBeerGlass.xml";
        File resourceFile = new File(resfile);
        String resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
        TemplatedResourceIterator tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
        while (tri.hasNext()) {
            String label2 = tri.getAttributeValue("label2");
            byte[] foxml = tri.next().getBytes("UTF-8");
            String pid = this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            this.apim.modifyDatastreamByValue(pid, "DC", null, label2, null, null, null, null, null, "modify datastream label", false);
        }
        TestAPIM2.purgeDemoObjects();
        String resourceDirName = "src/test/resources/APIM2/foxml/";
        for (String resourceFilename : resourceFilenames = new File(resourceDirName).list()) {
            resourceFile = new File(resourceDirName + resourceFilename);
            if (!resourceFile.isFile()) continue;
            resource = FileUtils.readFileToString((File)resourceFile, (String)"UTF-8");
            tri = new TemplatedResourceIterator(resource, "src/test/resources/APIM2/valuesplain");
            while (tri.hasNext()) {
                byte[] foxml = tri.next().getBytes("UTF-8");
                this.apim.ingest(foxml, TestAPIM2.FOXML1_1.uri, "ingesting new foxml object");
            }
        }
        TestAPIM2.purgeDemoObjects();
    }

    public static void main(String[] args) {
        TestRunner.run(TestAPIM2.class);
    }
}

