/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIA;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.OneEmptyObjectTestSetup;
import org.junit.After;
import org.w3c.dom.Document;

public class TestAuthentication
extends FedoraServerTestCase {
    private static final String TEST_PID = "demo:AuthNTestObject";
    private static final int TIMES_PER_TEST = 50;
    private static FedoraClient CLIENT_VALID_USER_VALID_PASS;
    private static FedoraClient CLIENT_VALID_USER_BOGUS_PASS;
    private static FedoraClient CLIENT_BOGUS_USER;

    public static Test suite() {
        TestSuite suite = new TestSuite("TestAuthentication TestSuite");
        suite.addTestSuite(TestAuthentication.class);
        return new OneEmptyObjectTestSetup((Test)suite, TEST_PID);
    }

    public void testAPIMSOAPAuthNValidUserValidPass() throws Exception {
        int failCount = this.modifyLabel(TestAuthentication.getClient(true, true), 50);
        TestAuthentication.assertEquals((String)("Modifying object label using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    public void testAPIMSOAPAuthNValidUserBogusPass() throws Exception {
        int failCount = this.modifyLabel(TestAuthentication.getClient(true, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Modifying object label using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void testAPIMSOAPAuthNBogusUser() throws Exception {
        int failCount = this.modifyLabel(TestAuthentication.getClient(false, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Modifying object label using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void testAPIMLiteAuthNValidUserValidPass() throws Exception {
        int failCount = this.getNextPID(TestAuthentication.getClient(true, true), 50);
        TestAuthentication.assertEquals((String)("Getting next PID using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    public void testAPIMLiteAuthNValidUserBogusPass() throws Exception {
        int failCount = this.getNextPID(TestAuthentication.getClient(true, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Getting next PID using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void testAPIMLiteAuthNBogusUser() throws Exception {
        int failCount = this.getNextPID(TestAuthentication.getClient(false, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Getting next PID using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void testAPIASOAPAuthNValidUserValidPass() throws Exception {
        int failCount = this.listDatastreams(TestAuthentication.getClient(true, true), 50);
        TestAuthentication.assertEquals((String)("Listing object datastreams using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    public void testAPIASOAPAuthNValidUserBogusPass() throws Exception {
        int failCount = this.listDatastreams(TestAuthentication.getClient(true, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Listing object datastreams using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void testAPIASOAPAuthNBogusUser() throws Exception {
        int failCount = this.listDatastreams(TestAuthentication.getClient(false, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Listing object datastreams using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void testAPIALiteAuthNValidUserValidPass() throws Exception {
        int failCount = this.getDCContent(TestAuthentication.getClient(true, true), 50);
        TestAuthentication.assertEquals((String)("Getting DC content using valid user, valid pass failed " + failCount + " times out of " + 50 + " attempts"), (int)0, (int)failCount);
    }

    public void testAPIALiteAuthNValidUserBogusPass() throws Exception {
        int failCount = this.getDCContent(TestAuthentication.getClient(true, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Getting DC content using valid user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void testAPIALiteAuthNBogusUser() throws Exception {
        int failCount = this.getDCContent(TestAuthentication.getClient(false, false), 50);
        int successCount = 50 - failCount;
        TestAuthentication.assertEquals((String)("Getting DC content using bogus user, bogus pass succeeded " + successCount + " times out of " + 50 + " attempts"), (int)0, (int)successCount);
    }

    public void setUp() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("management", "http://www.fedora.info/definitions/1/0/management/");
        nsMap.put("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    private static FedoraClient getClient(boolean validUser, boolean validPass) throws Exception {
        if (validUser) {
            if (validPass) {
                System.out.println("Using Fedora Client with valid user, valid pass");
                if (CLIENT_VALID_USER_VALID_PASS == null) {
                    CLIENT_VALID_USER_VALID_PASS = TestAuthentication.getFedoraClient();
                }
                return CLIENT_VALID_USER_VALID_PASS;
            }
            System.out.println("Using Fedora Client with valid user, bogus pass");
            if (CLIENT_VALID_USER_BOGUS_PASS == null) {
                CLIENT_VALID_USER_BOGUS_PASS = TestAuthentication.getFedoraClient(TestAuthentication.getBaseURL(), TestAuthentication.getUsername(), "bogus");
            }
            return CLIENT_VALID_USER_BOGUS_PASS;
        }
        System.out.println("Using Fedora Client with bogus user");
        if (CLIENT_BOGUS_USER == null) {
            CLIENT_BOGUS_USER = TestAuthentication.getFedoraClient(TestAuthentication.getBaseURL(), "bogus", "bogus");
        }
        return CLIENT_BOGUS_USER;
    }

    private int modifyLabel(FedoraClient client, int numTimes) {
        System.out.println("Modifying object label via API-M SOAP " + numTimes + " times...");
        int failCount = 0;
        FedoraAPIM apim = null;
        for (int i = 0; i < numTimes; ++i) {
            try {
                if (apim == null) {
                    apim = client.getAPIM();
                }
                apim.modifyObject(TEST_PID, null, null, null, "i=" + i);
                continue;
            }
            catch (Exception e) {
                ++failCount;
            }
        }
        System.out.println("Failed " + failCount + " times");
        return failCount;
    }

    private int getNextPID(FedoraClient client, int numTimes) {
        System.out.println("Getting next PID via API-M Lite " + numTimes + " times...");
        int failCount = 0;
        for (int i = 0; i < numTimes; ++i) {
            try {
                Document result = this.getXMLQueryResult(client, "/management/getNextPID?xml=true");
                this.assertXpathEvaluatesTo("1", "count(//management:pid)", result);
                continue;
            }
            catch (Exception e) {
                ++failCount;
            }
        }
        System.out.println("Failed " + failCount + " times");
        return failCount;
    }

    private int listDatastreams(FedoraClient client, int numTimes) {
        System.out.println("Listing object datastreams via API-A SOAP " + numTimes + " times...");
        int failCount = 0;
        FedoraAPIA apia = null;
        for (int i = 0; i < numTimes; ++i) {
            try {
                if (apia == null) {
                    apia = client.getAPIA();
                }
                apia.listDatastreams(TEST_PID, null);
                continue;
            }
            catch (Exception e) {
                ++failCount;
            }
        }
        System.out.println("Failed " + failCount + " times");
        return failCount;
    }

    private int getDCContent(FedoraClient client, int numTimes) {
        System.out.println("Getting DC content via API-A Lite " + numTimes + " times...");
        int failCount = 0;
        for (int i = 0; i < numTimes; ++i) {
            try {
                Document result = this.getXMLQueryResult(client, "/get/demo:AuthNTestObject/DC");
                this.assertXpathExists("/oai_dc:dc", result);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                ++failCount;
            }
        }
        System.out.println("Failed " + failCount + " times");
        return failCount;
    }

    public static void main(String[] args) {
        TestRunner.run(TestAuthentication.class);
    }
}

