/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.util.Date;
import junit.framework.JUnit4TestAdapter;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.thread.ThreadHelper;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.server.utilities.StringUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.utilities.Foxml11Document;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestManagedDatastreams
extends FedoraServerTestCase {
    private FedoraAPIM apim;
    private Abdera abdera;
    private final String[] copyTempFileLocations = new String[]{"copy:///tmp/foo.txt", "copy://tmp/foo.txt", "copy://../etc/passwd", "temp:///tmp/foo.txt", "temp://tmp/foo.txt", "temp://../etc/passwd"};
    private final String[] uploadedLocations = new String[]{"uploaded:///tmp/foo.txt", "uploaded://tmp/foo.txt"};

    @Before
    public void setUp() throws Exception {
        this.abdera = Abdera.getInstance();
        this.apim = TestManagedDatastreams.getFedoraClient().getAPIM();
        System.setProperty("fedoraServerHost", "localhost");
        System.setProperty("fedoraServerPort", "8080");
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIngest() throws Exception {
        String pid = "demo:m_ds_test";
        for (String contentLocation : this.copyTempFileLocations) {
            try {
                this.apim.ingest(this.getAtomObject(pid, contentLocation), TestManagedDatastreams.ATOM1_1.uri, null);
                TestManagedDatastreams.fail((String)("ingest should have failed with " + contentLocation));
            }
            catch (RemoteException e) {
                TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("ValidationException"));
            }
            try {
                this.apim.ingest(this.getFoxmlObject(pid, contentLocation), TestManagedDatastreams.FOXML1_1.uri, null);
                TestManagedDatastreams.fail((String)("ingest should have failed with " + contentLocation));
            }
            catch (RemoteException e) {
                TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("ObjectIntegrityException"));
            }
        }
        for (String contentLocation : this.uploadedLocations) {
            try {
                this.apim.ingest(this.getAtomObject(pid, contentLocation), TestManagedDatastreams.ATOM1_1.uri, null);
                TestManagedDatastreams.fail((String)("ingest should have failed with " + contentLocation));
            }
            catch (RemoteException e) {
                TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("StreamReadException"));
            }
            try {
                this.apim.ingest(this.getFoxmlObject(pid, contentLocation), TestManagedDatastreams.FOXML1_1.uri, null);
                TestManagedDatastreams.fail((String)("ingest should have failed with " + contentLocation));
            }
            catch (RemoteException e) {
                TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("StreamReadException"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDatastream() throws Exception {
        String pid = "demo:m_ds_test_add";
        this.apim.ingest(this.getAtomObject(pid, null), TestManagedDatastreams.ATOM1_1.uri, null);
        try {
            for (String contentLocation : this.copyTempFileLocations) {
                try {
                    this.addDatastream(pid, contentLocation);
                    TestManagedDatastreams.fail((String)("addDatastream should have failed with " + contentLocation));
                }
                catch (RemoteException e) {
                    TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("ValidationException"));
                }
            }
            for (String contentLocation : this.uploadedLocations) {
                try {
                    this.addDatastream(pid, contentLocation);
                    TestManagedDatastreams.fail((String)("addDatastream should have failed with " + contentLocation));
                }
                catch (RemoteException e) {
                    TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("StreamReadException"));
                }
            }
        }
        finally {
            this.apim.purgeObject(pid, "test", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyDatastreamByReference() throws Exception {
        String pid = "demo:m_ds_test_add";
        String dsLocation = TestManagedDatastreams.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC";
        this.apim.ingest(this.getAtomObject(pid, dsLocation), TestManagedDatastreams.ATOM1_1.uri, null);
        try {
            for (String contentLocation : this.copyTempFileLocations) {
                try {
                    this.modifyDatastreamByReference(pid, contentLocation);
                    TestManagedDatastreams.fail((String)("modifyDatastreamByReference should have failed with " + contentLocation));
                }
                catch (RemoteException e) {
                    TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("ValidationException"));
                }
            }
            for (String contentLocation : this.uploadedLocations) {
                try {
                    this.modifyDatastreamByReference(pid, contentLocation);
                    TestManagedDatastreams.fail((String)("modifyDatastreamByReference should have failed with " + contentLocation));
                }
                catch (RemoteException e) {
                    TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("StreamReadException"));
                }
            }
            this.modifyDatastreamByReference(pid, null);
        }
        finally {
            this.apim.purgeObject(pid, "test", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDatastreamWithChecksum() throws Exception {
        String pid = "demo:m_ds_test_add";
        String checksumType = "MD5";
        this.apim.ingest(this.getAtomObject(pid, null), TestManagedDatastreams.ATOM1_1.uri, null);
        File temp = null;
        try {
            temp = File.createTempFile("foo", "bar");
            String contentLocation = TestManagedDatastreams.getFedoraClient().uploadFile(temp);
            String checksum = this.computeChecksum(checksumType, new FileInputStream(temp));
            String dsId = this.addDatastream(pid, contentLocation, checksumType, checksum);
            TestManagedDatastreams.assertEquals((String)"DS", (String)dsId);
            this.apim.purgeDatastream(pid, dsId, null, null, null, false);
            checksum = "bogus";
            try {
                this.addDatastream(pid, contentLocation, checksumType, checksum);
                TestManagedDatastreams.fail((String)"Adding datastream with bogus checksum should have failed.");
            }
            catch (RemoteException e) {
                TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("Checksum Mismatch"));
            }
        }
        finally {
            this.apim.purgeObject(pid, "test", false);
            if (temp != null) {
                temp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyDatastreamByReferenceWithChecksum() throws Exception {
        String pid = "demo:m_ds_test_add";
        String checksumType = "MD5";
        this.apim.ingest(this.getAtomObject(pid, null), TestManagedDatastreams.ATOM1_1.uri, null);
        File temp = null;
        try {
            temp = File.createTempFile("foo", "bar");
            String contentLocation = TestManagedDatastreams.getFedoraClient().uploadFile(temp);
            String checksum = this.computeChecksum(checksumType, new FileInputStream(temp));
            String dsId = this.addDatastream(pid, contentLocation, checksumType, checksum);
            TestManagedDatastreams.assertEquals((String)"DS", (String)dsId);
            FileOutputStream os = new FileOutputStream(temp);
            os.write("testModifyDatastreamByReferenceWithChecksum".getBytes());
            os.close();
            contentLocation = TestManagedDatastreams.getFedoraClient().uploadFile(temp);
            checksum = this.computeChecksum(checksumType, new FileInputStream(temp));
            this.modifyDatastreamByReference(pid, contentLocation, checksumType, checksum);
            checksum = "bogus";
            try {
                this.modifyDatastreamByReference(pid, contentLocation, checksumType, checksum);
                TestManagedDatastreams.fail((String)"Modifying datastream with bogus checksum should have failed.");
            }
            catch (RemoteException e) {
                TestManagedDatastreams.assertTrue((boolean)e.getMessage().contains("Checksum Mismatch"));
            }
        }
        finally {
            this.apim.purgeObject(pid, "test", false);
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private byte[] getAtomObject(String pid, String contentLocation) throws Exception {
        Feed feed = this.createAtomObject(pid, contentLocation);
        StringWriter sWriter = new StringWriter();
        feed.writeTo("prettyxml", (Writer)sWriter);
        return ((Object)sWriter).toString().getBytes("UTF-8");
    }

    private byte[] getFoxmlObject(String pid, String contentLocation) throws Exception {
        Foxml11Document doc = this.createFoxmlObject(pid, contentLocation);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.serialize((OutputStream)out);
        return out.toByteArray();
    }

    private String addDatastream(String pid, String contentLocation) throws Exception {
        return this.addDatastream(pid, contentLocation, null, null);
    }

    private String addDatastream(String pid, String contentLocation, String checksumType, String checksum) throws Exception {
        return this.apim.addDatastream(pid, "DS", null, "testManagedDatastreams", true, "text/plain", "", contentLocation, "M", "A", checksumType, checksum, "testManagedDatastreams");
    }

    private String modifyDatastreamByReference(String pid, String contentLocation) throws Exception {
        return this.modifyDatastreamByReference(pid, contentLocation, null, null);
    }

    private String modifyDatastreamByReference(String pid, String contentLocation, String checksumType, String checksum) throws Exception {
        return this.apim.modifyDatastreamByReference(pid, "DS", new String[0], "testManagedDatastreams", "text/plain", "", contentLocation, checksumType, checksum, "testManagedDatastreams", false);
    }

    private Feed createAtomObject(String spid, String contentLocation) throws Exception {
        PID pid = PID.getInstance((String)spid);
        Date date = new Date(1L);
        String title = "title";
        String author = "org.fcrepo.test.api.TestManagedDatastreams";
        Feed feed = this.abdera.newFeed();
        feed.setId(pid.toURI());
        feed.setTitle(title);
        feed.setUpdated(date);
        feed.addAuthor(author);
        if (contentLocation != null && contentLocation.length() > 0) {
            this.addAtomManagedDatastream(feed, contentLocation);
        }
        return feed;
    }

    private void addAtomManagedDatastream(Feed feed, String contentLocation) throws Exception {
        String dsId = "DS";
        Entry dsEntry = feed.addEntry();
        dsEntry.setId(feed.getId().toString() + "/" + dsId);
        Entry dsvEntry = feed.addEntry();
        dsvEntry.setId(dsEntry.getId().toString() + "/" + feed.getUpdatedString());
        dsEntry.setTitle(feed.getTitle());
        dsEntry.setUpdated(feed.getUpdated());
        dsEntry.addLink(dsvEntry.getId().toString(), "alternate");
        dsEntry.addCategory(TestManagedDatastreams.MODEL.STATE.uri, "A", null);
        dsEntry.addCategory(TestManagedDatastreams.MODEL.CONTROL_GROUP.uri, "M", null);
        dsEntry.addCategory(TestManagedDatastreams.MODEL.VERSIONABLE.uri, "true", null);
        dsvEntry.setTitle(feed.getTitle());
        dsvEntry.setUpdated(feed.getUpdated());
        ThreadHelper.addInReplyTo((Entry)dsvEntry, (IRI)dsEntry.getId());
        dsvEntry.setSummary("summary");
        dsvEntry.setContent(new IRI(contentLocation), "text/plain");
    }

    private Foxml11Document createFoxmlObject(String spid, String contentLocation) throws Exception {
        PID pid = PID.getInstance((String)spid);
        Date date = new Date(1L);
        Foxml11Document doc = new Foxml11Document(pid.toString());
        doc.addObjectProperty(Foxml11Document.Property.STATE, "A");
        if (contentLocation != null && contentLocation.length() > 0) {
            String ds = "DS";
            String dsv = "DS1.0";
            doc.addDatastream(ds, Foxml11Document.State.A, Foxml11Document.ControlGroup.M, true);
            doc.addDatastreamVersion(ds, dsv, "text/plain", "label", 1, date);
            doc.setContentLocation(dsv, contentLocation, "URL");
        }
        return doc;
    }

    private String computeChecksum(String csType, InputStream is) throws Exception {
        int numread;
        MessageDigest md = MessageDigest.getInstance(csType);
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        byte[] buffer = new byte[5000];
        while ((numread = is.read(buffer, 0, 5000)) > 0) {
            md.update(buffer, 0, numread);
        }
        return StringUtility.byteArraytoHexString((byte[])md.digest());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestManagedDatastreams.class);
    }
}

