/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.JUnit4TestAdapter;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.Parser;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.utility.export.Export;
import org.fcrepo.client.utility.ingest.Ingest;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.test.FedoraTestCase;
import org.fcrepo.test.api.TestAPIM;
import org.fcrepo.utilities.FileUtils;
import org.junit.After;
import org.junit.Test;

public class TestCommandLineFormats
extends FedoraTestCase {
    private FedoraAPIM apim;

    public void setUp() throws Exception {
        this.apim = TestCommandLineFormats.getFedoraClient(TestCommandLineFormats.getBaseURL(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword()).getAPIM();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("foxml", "info:fedora/fedora-system:def/foxml#");
        nsMap.put("METS", "http://www.loc.gov/METS/");
        nsMap.put("", "http://www.w3.org/2005/Atom");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestFOXML10() throws Exception {
        System.out.println("Testing Ingest with FOXML 1.0 format");
        File foxml10 = File.createTempFile("demo_997", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(foxml10);
        fileWriter.write(TestAPIM.demo997FOXML10ObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", foxml10.getAbsolutePath(), TestCommandLineFormats.FOXML1_0.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        foxml10.delete();
        try {
            byte[] objectXML = this.apim.getObjectXML("demo:997");
            TestCommandLineFormats.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:997']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("6", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
        }
        finally {
            this.apim.purgeObject("demo:997", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestFOXML11() throws Exception {
        System.out.println("Testing Ingest with FOXML 1.1 format");
        File foxml11 = File.createTempFile("demo_998", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(foxml11);
        fileWriter.write(TestAPIM.demo998FOXMLObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", foxml11.getAbsolutePath(), TestCommandLineFormats.FOXML1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        foxml11.delete();
        try {
            byte[] objectXML = this.apim.getObjectXML("demo:998");
            TestCommandLineFormats.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:998']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("6", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
        }
        finally {
            this.apim.purgeObject("demo:998", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestMETS11() throws Exception {
        System.out.println("Testing Ingest with METS 1.1 format");
        File mets = File.createTempFile("demo_999", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(mets);
        fileWriter.write(TestAPIM.demo999METSObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", mets.getAbsolutePath(), TestCommandLineFormats.METS_EXT1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        mets.delete();
        try {
            byte[] objectXML = this.apim.getObjectXML("demo:999");
            TestCommandLineFormats.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:999']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("6", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
        }
        finally {
            this.apim.purgeObject("demo:999", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestMETS10() throws Exception {
        System.out.println("Testing Ingest with METS 1.0 format");
        File mets = File.createTempFile("demo_999b", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(mets);
        fileWriter.write(TestAPIM.demo999bMETS10ObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", mets.getAbsolutePath(), TestCommandLineFormats.METS_EXT1_0.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        mets.delete();
        try {
            byte[] objectXML = this.apim.getObjectXML("demo:999b");
            TestCommandLineFormats.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:999b']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("6", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
        }
        finally {
            this.apim.purgeObject("demo:999b", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestATOM() throws Exception {
        System.out.println("Testing Ingest with ATOM format");
        File atom = File.createTempFile("demo_1000", ".xml");
        FileOutputStream fileWriter = new FileOutputStream(atom);
        fileWriter.write(TestAPIM.demo1000ATOMObjectXML);
        fileWriter.close();
        String[] parameters = new String[]{"f ", atom.getAbsolutePath(), TestCommandLineFormats.ATOM1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        atom.delete();
        try {
            byte[] objectXML = this.apim.getObjectXML("demo:1000");
            TestCommandLineFormats.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:1000']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("7", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
        }
        finally {
            this.apim.purgeObject("demo:1000", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngestATOM_ZIP() throws Exception {
        System.out.println("Testing Ingest with ATOM_ZIP format");
        File atom = File.createTempFile("demo_1001", ".zip");
        FileOutputStream fileWriter = new FileOutputStream(atom);
        fileWriter.write(TestAPIM.demo1001ATOMZip);
        fileWriter.close();
        String[] parameters = new String[]{"f ", atom.getAbsolutePath(), TestCommandLineFormats.ATOM_ZIP1_1.uri, TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), TestCommandLineFormats.getProtocol(), "\"Ingest\"", TestCommandLineFormats.getFedoraAppServerContext()};
        Ingest.main((String[])parameters);
        atom.delete();
        try {
            byte[] objectXML = this.apim.getObjectXML("demo:1001");
            TestCommandLineFormats.assertTrue((objectXML.length > 0 ? 1 : 0) != 0);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:1001']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("4", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
        }
        finally {
            this.apim.purgeObject("demo:1001", "", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportFOXML10() throws Exception {
        System.out.println("Testing Export in FOXML 1.0 format");
        this.apim.ingest(TestAPIM.demo998FOXMLObjectXML, TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.FOXML1_0.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File foxml10 = new File(temp.getParent() + "/demo_998.xml");
            FileInputStream fileReader = new FileInputStream(foxml10);
            byte[] objectXML = new byte[fileReader.available()];
            fileReader.read(objectXML);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:998']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("6", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
            this.assertXpathNotExists("foxml:digitalObject[@VERSION='1.1']", xmlIn);
            temp.delete();
            foxml10.delete();
        }
        finally {
            this.apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportFOXML11() throws Exception {
        System.out.println("Testing Export in FOXML 1.1 format");
        this.apim.ingest(TestAPIM.demo998FOXMLObjectXML, TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.FOXML1_1.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File foxml11 = new File(temp.getParent() + "/demo_998.xml");
            FileInputStream fileReader = new FileInputStream(foxml11);
            byte[] objectXML = new byte[fileReader.available()];
            fileReader.read(objectXML);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("foxml:digitalObject[@PID='demo:998']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#state' and @VALUE='Active']", xmlIn);
            this.assertXpathExists("//foxml:objectProperties/foxml:property[@NAME='info:fedora/fedora-system:def/model#label' and @VALUE='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathEvaluatesTo("6", "count(//foxml:datastream)", xmlIn);
            this.assertXpathNotExists("//foxml:disseminator", xmlIn);
            this.assertXpathExists("foxml:digitalObject[@VERSION='1.1']", xmlIn);
            temp.delete();
            foxml11.delete();
        }
        finally {
            this.apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMETS11() throws Exception {
        System.out.println("Testing Export in METS 1.1 format");
        this.apim.ingest(TestAPIM.demo998FOXMLObjectXML, TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.METS_EXT1_1.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File mets = new File(temp.getParent() + "/demo_998.xml");
            FileInputStream fileReader = new FileInputStream(mets);
            byte[] objectXML = new byte[fileReader.available()];
            fileReader.read(objectXML);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("METS:mets[@OBJID='demo:998']", xmlIn);
            this.assertXpathExists("METS:mets[@LABEL='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathExists("METS:mets[@EXT_VERSION='1.1']", xmlIn);
            this.assertXpathEvaluatesTo("4", "count(//METS:fileGrp[@STATUS='A'])", xmlIn);
            temp.delete();
            mets.delete();
        }
        finally {
            this.apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMETS10() throws Exception {
        System.out.println("Testing Export in METS 1.0 format");
        this.apim.ingest(TestAPIM.demo998FOXMLObjectXML, TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.METS_EXT1_0.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File mets = new File(temp.getParent() + "/demo_998.xml");
            FileInputStream fileReader = new FileInputStream(mets);
            byte[] objectXML = new byte[fileReader.available()];
            fileReader.read(objectXML);
            String xmlIn = new String(objectXML, "UTF-8");
            this.assertXpathExists("METS:mets[@OBJID='demo:998']", xmlIn);
            this.assertXpathExists("METS:mets[@LABEL='Data Object (Coliseum) for Local Simple Image Demo']", xmlIn);
            this.assertXpathNotExists("METS:mets[@EXT_VERSION='1.1']", xmlIn);
            this.assertXpathEvaluatesTo("4", "count(//METS:fileGrp[@STATUS='A'])", xmlIn);
            temp.delete();
            mets.delete();
        }
        finally {
            this.apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportATOM() throws Exception {
        System.out.println("Testing Export in ATOM format");
        this.apim.ingest(TestAPIM.demo998FOXMLObjectXML, TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.ATOM1_1.uri, "public", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File atom = new File(temp.getParent() + "/demo_998.xml");
            FileInputStream fileReader = new FileInputStream(atom);
            byte[] objectXML = new byte[fileReader.available()];
            fileReader.read(objectXML);
            String xmlIn = new String(objectXML, "UTF-8");
            TestCommandLineFormats.assertTrue((xmlIn.indexOf("<id>info:fedora/demo:998</id>") > -1 ? 1 : 0) != 0);
            TestCommandLineFormats.assertTrue((xmlIn.indexOf("<title type=\"text\">Data Object (Coliseum) for Local Simple Image Demo</title>") > -1 ? 1 : 0) != 0);
            temp.delete();
            atom.delete();
        }
        finally {
            this.apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExportATOM_ZIP() throws Exception {
        System.out.println("Testing Export in ATOM_ZIP format");
        this.apim.ingest(TestAPIM.demo998FOXMLObjectXML, TestCommandLineFormats.FOXML1_1.uri, "Ingest for test");
        try {
            ZipEntry entry;
            File temp = File.createTempFile("temp", "");
            String[] parameters = new String[]{TestCommandLineFormats.getHost() + ":" + TestCommandLineFormats.getPort(), TestCommandLineFormats.getUsername(), TestCommandLineFormats.getPassword(), "demo:998", TestCommandLineFormats.ATOM_ZIP1_1.uri, "archive", temp.getParent(), "http", TestCommandLineFormats.getFedoraAppServerContext()};
            Export.main((String[])parameters);
            File atom = new File(temp.getParent() + "/demo_998.zip");
            ZipInputStream zip = new ZipInputStream(new FileInputStream(atom));
            int count = 0;
            while ((entry = zip.getNextEntry()) != null) {
                if (!entry.getName().equals("atommanifest.xml")) continue;
                ++count;
                ByteArrayOutputStream manifest = new ByteArrayOutputStream();
                FileUtils.copy((InputStream)zip, (OutputStream)manifest);
                Abdera abdera = Abdera.getInstance();
                Parser parser = abdera.getParser();
                Document feedDoc = parser.parse((Reader)new StringReader(manifest.toString("UTF-8")));
                Feed feed = (Feed)feedDoc.getRoot();
                TestCommandLineFormats.assertEquals((String)PID.getInstance((String)"demo:998").toURI(), (String)feed.getId().toString());
            }
            TestCommandLineFormats.assertEquals((String)"Expected exactly 1 manifest file", (int)1, (int)count);
            zip.close();
            temp.delete();
            atom.delete();
        }
        finally {
            this.apim.purgeObject("demo:998", "Purge test object", false);
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestCommandLineFormats.class);
    }
}

