/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration.cma;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.axis.AxisFault;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIA;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.integration.cma.SharedDeploymentTests;
import org.fcrepo.test.integration.cma.Util;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class SimpleDeploymentTests {
    private static FedoraClient m_client;
    private static final String OBJECT_1_PID = "demo:simple-deployment.object.1";
    private static final String SDEF_1_PID = "demo:simple-deployment.sdef.1";
    private static final String SDEF_2_PID = "demo:simple-deployment.sdef.2";
    private static final String SDEF_1_METHOD = "content";
    private static final String SDEF_2_METHOD = "content2";
    private static final String SIMPLE_DEPLOYMENT_BASE = "cma-examples/simple-deployment";
    private static final String SIMPLE_DEPLOYMENT_PUBLIC_OBJECTS = "cma-examples/simple-deployment/public-objects";
    private static final String SIMPLE_DEPLOYMENT_DEPLOYMENTS = "cma-examples/simple-deployment/deployments";

    public static Test suite() {
        return new JUnit4TestAdapter(SharedDeploymentTests.class);
    }

    @BeforeClass
    public static void bootstrap() throws Exception {
        m_client = new FedoraClient(FedoraServerTestCase.getBaseURL(), FedoraServerTestCase.getUsername(), FedoraServerTestCase.getPassword());
        Util.ingestTestObjects(SIMPLE_DEPLOYMENT_BASE);
    }

    @org.junit.Test
    public void testListMethods() throws Exception {
        FedoraAPIA apia = m_client.getAPIA();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_1_PID, null));
        Assert.assertEquals((String)"Wrong number of methods", (int)2, (int)methods.length);
        Assert.assertNotSame((String)"SDeps are not distinct", (Object)methods[0].getServiceDefinitionPID(), (Object)methods[1].getServiceDefinitionPID());
        Assert.assertNotSame((String)"Methods are not distinct", (Object)methods[0].getMethodName(), (Object)methods[1].getMethodName());
        if (methods[0].getServiceDefinitionPID().equals(SDEF_1_PID)) {
            Assert.assertEquals((String)methods[1].getServiceDefinitionPID(), (String)SDEF_2_PID);
            Assert.assertEquals((String)methods[0].getMethodName(), (String)SDEF_1_METHOD);
            Assert.assertEquals((String)methods[1].getMethodName(), (String)SDEF_2_METHOD);
        } else if (methods[0].getServiceDefinitionPID().equals(SDEF_2_PID)) {
            Assert.assertEquals((String)methods[1].getServiceDefinitionPID(), (String)SDEF_1_PID);
            Assert.assertEquals((String)methods[0].getMethodName(), (String)SDEF_2_METHOD);
            Assert.assertEquals((String)methods[1].getMethodName(), (String)SDEF_1_METHOD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void testListMethodsWithoutSDeps() throws Exception {
        FedoraServerTestCase.purgeDemoObjects();
        Util.ingestTestObjects(SIMPLE_DEPLOYMENT_PUBLIC_OBJECTS);
        try {
            this.testListMethods();
        }
        finally {
            Util.ingestTestObjects(SIMPLE_DEPLOYMENT_DEPLOYMENTS);
        }
    }

    @org.junit.Test
    public void testDissemination1() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_1_PID, SDEF_1_PID, SDEF_1_METHOD).contains("CONTENT_1"));
        try {
            this.getDissemination(OBJECT_1_PID, SDEF_1_PID, SDEF_2_METHOD);
            Assert.fail((String)"Should not have been able to disseminate");
        }
        catch (AxisFault e) {
            // empty catch block
        }
        try {
            this.getDissemination(OBJECT_1_PID, SDEF_2_PID, SDEF_1_METHOD);
            Assert.fail((String)"Should not have been able to disseminate");
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testDissemination2() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_1_PID, SDEF_2_PID, SDEF_2_METHOD).contains("CONTENT_2"));
    }

    private String getDissemination(String pid, String sDef, String method) throws Exception {
        return Util.getDissemination(m_client, pid, sDef, method);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        FedoraServerTestCase.purgeDemoObjects();
    }
}

