/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Date;
import java.util.Map;
import junit.framework.Assert;
import org.fcrepo.common.Constants;
import org.fcrepo.common.PID;
import org.fcrepo.server.Server;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.resourceIndex.ResourceIndexRebuilder;
import org.fcrepo.server.utilities.ServerUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.server.utilities.rebuild.Rebuild;
import org.fcrepo.server.utilities.rebuild.RebuildServer;
import org.fcrepo.server.utilities.rebuild.Rebuilder;
import org.fcrepo.test.FedoraTestCase;
import org.fcrepo.utilities.ExecUtility;
import org.fcrepo.utilities.Foxml11Document;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ResourceIndexRebuilderTest {
    private FedoraAPIMMTOM apim;
    private String osName;

    @Before
    public void setUp() throws Exception {
        this.osName = System.getProperty("os.name");
        if (!this.isTomcatRunning()) {
            this.startTomcat();
        }
        this.apim = FedoraTestCase.getFedoraClient().getAPIMMTOM();
    }

    @After
    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRebuild() throws Exception {
        int count = 10;
        this.rebuild();
        try {
            this.ingestObjects(count);
            this.shutdownTomcat();
            this.rebuild();
            this.startTomcat();
        }
        finally {
            if (!this.isTomcatRunning()) {
                this.startTomcat();
            }
            this.purgeObjects(count);
        }
    }

    private void rebuild() throws Exception {
        Server server = RebuildServer.getInstance((File)new File(Constants.FEDORA_HOME));
        Rebuilder rebuilder = (Rebuilder)server.getBean(ResourceIndexRebuilder.class);
        Map options = rebuilder.getOptions();
        try {
            new Rebuild(rebuilder, options, server);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void startTomcat() throws Exception {
        String cmd = Constants.FEDORA_HOME + "/tomcat/bin/startup";
        if (!this.osName.startsWith("Windows")) {
            cmd = cmd + ".sh";
        }
        ExecUtility.execCommandLineUtility((String)cmd);
        System.out.print("Starting Tomcat ");
        int count = 0;
        int timeout = 30000;
        while (!this.isFedoraRunning()) {
            System.out.print(".");
            Thread.sleep(1000L);
            if ((count += 1000) <= timeout) continue;
            throw new RuntimeException("Tomcat startup timeout");
        }
        System.out.println();
    }

    private boolean isFedoraRunning() throws Exception {
        return ServerUtility.pingServer((String)"http", (String)"fedoraAdmin", (String)"fedoraAdmin");
    }

    private boolean isTomcatRunning() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", 8080);
            return socket.isConnected();
        }
        catch (ConnectException e) {
            return false;
        }
    }

    private void shutdownTomcat() throws Exception {
        if (!this.isTomcatRunning()) {
            System.out.println("Tomcat was already shut down.");
            return;
        }
        String cmd = Constants.FEDORA_HOME + "/tomcat/bin/shutdown";
        String osName = System.getProperty("os.name");
        if (!osName.startsWith("Windows")) {
            cmd = cmd + ".sh";
        }
        System.out.print("Shutting down Tomcat ");
        ExecUtility.execCommandLineUtility((String)cmd);
        int count = 0;
        int timeout = 30000;
        while (this.isTomcatRunning()) {
            System.out.print(".");
            Thread.sleep(1000L);
            if ((count += 1000) <= timeout) continue;
            throw new RuntimeException("Tomcat shutdown timeout");
        }
        Thread.sleep(5000L);
        System.out.println();
    }

    private void ingestObjects(int count) throws Exception {
        String url = "http://www.fedora-commons.org/";
        System.out.print("ingesting " + count + " objects ");
        for (int i = 0; i < count; ++i) {
            String pid = String.format("demo:ri%s", i);
            this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])this.getFoxmlObject(pid, url)), Constants.FOXML1_1.uri, null);
            if (i % 100 == 0) {
                System.out.print("\n\t");
            }
            System.out.print(".");
        }
        System.out.println();
    }

    private void purgeObjects(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            String pid = String.format("demo:ri%s", i);
            this.apim.purgeObject(pid, null, false);
        }
    }

    private byte[] getFoxmlObject(String pid, String contentLocation) throws Exception {
        Foxml11Document doc = this.createFoxmlObject(pid, contentLocation);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.serialize((OutputStream)out);
        return out.toByteArray();
    }

    private Foxml11Document createFoxmlObject(String spid, String contentLocation) throws Exception {
        PID pid = PID.getInstance((String)spid);
        Date date = new Date(1L);
        Foxml11Document doc = new Foxml11Document(pid.toString());
        doc.addObjectProperty(Foxml11Document.Property.STATE, "A");
        if (contentLocation != null && contentLocation.length() > 0) {
            String ds = "DS";
            String dsv = "DS1.0";
            doc.addDatastream(ds, Foxml11Document.State.A, Foxml11Document.ControlGroup.E, true);
            doc.addDatastreamVersion(ds, dsv, "text/html", "label", 1, date);
            doc.setContentLocation(dsv, contentLocation, "URL");
        }
        return doc;
    }
}

