/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.activation.DataHandler;
import junit.framework.TestSuite;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.junit.Test;

public class TestAdminAPI
extends FedoraServerTestCase {
    private FedoraAPIAMTOM apia;
    private FedoraAPIMMTOM apim;
    private static String authAccessProperty = "fedora.authorize.access";
    protected Boolean authorizeAccess = null;
    protected String url;
    private static final String datetime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(new Date());
    private final boolean chunked = false;

    public void setUp() throws Exception {
        this.apia = TestAdminAPI.getFedoraClient().getAPIAMTOM();
        this.apim = TestAdminAPI.getFedoraClient().getAPIMMTOM();
    }

    public void tearDown() throws Exception {
    }

    private boolean getAuthAccess() {
        if (this.authorizeAccess == null) {
            String property = System.getProperty(authAccessProperty);
            if (property.equals("true")) {
                this.authorizeAccess = true;
            } else if (property.equals("false")) {
                this.authorizeAccess = false;
            } else {
                TestAdminAPI.assertTrue((String)("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty), (boolean)false);
                throw new RuntimeException("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty);
            }
        }
        return this.authorizeAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyControlGroup() throws Exception {
        FileWriter fw;
        this.url = "/objects?pid=true&title=false&query=pid~demo%3A*&maxResults=1000&resultFormat=xml";
        HttpResponse res = this.get(this.getAuthAccess());
        TestAdminAPI.assertEquals((int)200, (int)res.getStatusCode());
        File objectsListFile = null;
        try {
            objectsListFile = File.createTempFile("TestAdminAPI", null);
            fw = new FileWriter(objectsListFile);
            String queryResults = res.getResponseBodyString();
            fw.write(queryResults);
            fw.close();
            this.testFileInput(objectsListFile);
        }
        finally {
            if (objectsListFile != null && !objectsListFile.delete()) {
                objectsListFile.deleteOnExit();
            }
        }
        TestAdminAPI.purgeDemoObjects();
        TestAdminAPI.ingestDemoObjects();
        objectsListFile = null;
        try {
            objectsListFile = File.createTempFile("TestAdminAPI", null);
            fw = new FileWriter(objectsListFile);
            Set<String> objects = TestAdminAPI.getDemoObjects();
            for (String pid : objects) {
                fw.write(pid + "\n");
            }
            fw.close();
            this.testFileInput(objectsListFile);
        }
        finally {
            if (objectsListFile != null && !objectsListFile.delete()) {
                objectsListFile.deleteOnExit();
            }
        }
        TestAdminAPI.purgeDemoObjects();
        TestAdminAPI.ingestDemoObjects();
        Set<String> objects = TestAdminAPI.getDemoObjects();
        String pid = objects.toArray(new String[0])[0];
        this.url = this.modifyDatastreamControlGroupUrl(pid + "doesnotexist", "DC", "M", false, false, false);
        res = this.get(true);
        TestAdminAPI.assertEquals((int)404, (int)res.getStatusCode());
        this.url = this.modifyDatastreamControlGroupUrl(pid, "doesnotexist", "M", false, false, false);
        res = this.get(true);
        TestAdminAPI.assertEquals((int)404, (int)res.getStatusCode());
        byte[] before = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(pid, "DC", null).getStream());
        this.url = this.modifyDatastreamControlGroupUrl(pid, "DC", "M", false, false, false);
        res = this.get(true);
        String contents = res.getResponseBodyString();
        TestAdminAPI.assertEquals((int)200, (int)res.getStatusCode());
        Datastream ds = this.apim.getDatastream(pid, "DC", null);
        TestAdminAPI.assertEquals((String)"ControlGroup", (String)"M", (String)ds.getControlGroup().value());
        byte[] after = TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(pid, "DC", null).getStream());
        String beforeString = new String(before, "UTF-8");
        String afterString = new String(after, "UTF-8");
        TestAdminAPI.assertEquals((String)"Datastream contents ", (String)beforeString, (String)afterString);
        String pid1 = objects.toArray(new String[0])[1];
        String pid2 = objects.toArray(new String[0])[2];
        this.url = this.modifyDatastreamControlGroupUrl(pid1 + "," + pid2, "DC", "M", false, false, false);
        res = this.get(true);
        TestAdminAPI.assertEquals((int)200, (int)res.getStatusCode());
        contents = res.getResponseBodyString();
        int[] counts = this.getCounts(contents);
        TestAdminAPI.assertEquals((String)"Object count", (int)2, (int)counts[0]);
        TestAdminAPI.assertEquals((String)"Datastream count", (int)2, (int)counts[1]);
        ds = this.apim.getDatastream(pid1, "DC", null);
        TestAdminAPI.assertEquals((String)"ControlGroup", (String)"M", (String)ds.getControlGroup().value());
        ds = this.apim.getDatastream(pid2, "DC", null);
        TestAdminAPI.assertEquals((String)"ControlGroup", (String)"M", (String)ds.getControlGroup().value());
    }

    private void testFileInput(File objectsListFile) throws Exception {
        Set<String> objects = TestAdminAPI.getDemoObjects();
        int managedObjects = 0;
        for (String pid : objects) {
            if (!pid.endsWith("_M")) continue;
            ++managedObjects;
        }
        this.url = this.modifyDatastreamControlGroupUrl("file:///" + objectsListFile.getAbsolutePath(), "DC", "M", false, false, false);
        HttpResponse res = this.get(true);
        TestAdminAPI.assertEquals((int)200, (int)res.getStatusCode());
        String modified = res.getResponseBodyString();
        String logExpected = "Updated " + (objects.size() - managedObjects) + " objects and " + (objects.size() - managedObjects) + " datastreams";
        TestAdminAPI.assertTrue((String)("Wrong number of objects/datastreams updated.  Expected " + logExpected + "\n" + "Log file shows:" + "\n" + modified), (boolean)modified.contains(logExpected));
        res = this.get(true);
        modified = res.getResponseBodyString();
        TestAdminAPI.assertEquals((int)200, (int)res.getStatusCode());
        logExpected = "Updated 0 objects and 0 datastreams";
        TestAdminAPI.assertTrue((String)"Wrong number of objects/datastreams updated", (boolean)modified.contains(logExpected));
        this.url = this.modifyDatastreamControlGroupUrl("file:///" + objectsListFile.getAbsolutePath(), "DC,RELS-EXT", "M", false, false, false);
        res = this.get(true);
        modified = res.getResponseBodyString();
        TestAdminAPI.assertEquals((int)200, (int)res.getStatusCode());
        int[] counts = this.getCounts(modified);
        int objectCount = counts[0];
        int datastreamCount = counts[1];
        if (objectCount <= 0 || objectCount > objects.size() - managedObjects - 1 || datastreamCount <= 0 || datastreamCount > objects.size() - managedObjects - 1) {
            TestAdminAPI.fail((String)("Incorrect number of objects and datastreams modified: objects " + objectCount + " datastreams " + datastreamCount));
        }
    }

    private int[] getCounts(String response) {
        int objectCountPos = response.lastIndexOf("Updated ");
        int datastreamCountPos = response.lastIndexOf(" objects and ");
        int datastreamEndCountPos = response.lastIndexOf(" datastreams");
        int objectCount = Integer.parseInt(response.substring(objectCountPos + "Updated ".length(), datastreamCountPos));
        int datastreamCount = Integer.parseInt(response.substring(datastreamCountPos + " objects and ".length(), datastreamEndCountPos));
        int[] res = new int[]{objectCount, datastreamCount};
        return res;
    }

    private String modifyDatastreamControlGroupUrl(String pid, String dsID, String controlGroup, boolean addXMLHeader, boolean reformat, boolean setMIMETypeCharset) {
        String ret;
        try {
            ret = "/management/control?action=modifyDatastreamControlGroup&pid=" + URLEncoder.encode(pid, "UTF-8") + "&dsID=" + URLEncoder.encode(dsID, "UTF-8") + "&controlGroup=" + controlGroup + "&addXMLHeader=" + addXMLHeader + "&reformat=" + reformat + "&setMIMETypeCharset=" + setMIMETypeCharset;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    private HttpClient getClient(boolean auth) {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        if (auth) {
            client.getState().setCredentials(new AuthScope(TestAdminAPI.getHost(), Integer.valueOf(TestAdminAPI.getPort()).intValue(), "realm"), (Credentials)new UsernamePasswordCredentials(TestAdminAPI.getUsername(), TestAdminAPI.getPassword()));
        }
        return client;
    }

    protected HttpResponse get(boolean authenticate) throws Exception {
        return this.getOrDelete("GET", authenticate);
    }

    protected HttpResponse delete(boolean authenticate) throws Exception {
        return this.getOrDelete("DELETE", authenticate);
    }

    protected HttpResponse put(boolean authenticate) throws Exception {
        return this.putOrPost("PUT", null, authenticate);
    }

    protected HttpResponse put(String requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("PUT", requestContent, authenticate);
    }

    protected HttpResponse post(String requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("POST", requestContent, authenticate);
    }

    protected HttpResponse put(File requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("PUT", requestContent, authenticate);
    }

    protected HttpResponse post(File requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("POST", requestContent, authenticate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse getOrDelete(String method, boolean authenticate) throws Exception {
        if (this.url == null || this.url.length() == 0) {
            throw new IllegalArgumentException("url must be a non-empty value");
        }
        if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
            this.url = TestAdminAPI.getBaseURL() + this.url;
        }
        GetMethod httpMethod = null;
        try {
            if (method.equals("GET")) {
                httpMethod = new GetMethod(this.url);
            } else if (method.equals("DELETE")) {
                httpMethod = new DeleteMethod(this.url);
            } else {
                throw new IllegalArgumentException("method must be one of GET or DELETE.");
            }
            httpMethod.setDoAuthentication(authenticate);
            httpMethod.getParams().setParameter("Connection", (Object)"Keep-Alive");
            this.getClient(authenticate).executeMethod((HttpMethod)httpMethod);
            HttpResponse httpResponse = new HttpResponse((HttpMethod)httpMethod);
            return httpResponse;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse putOrPost(String method, Object requestContent, boolean authenticate) throws Exception {
        if (this.url == null || this.url.length() == 0) {
            throw new IllegalArgumentException("url must be a non-empty value");
        }
        if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
            this.url = TestAdminAPI.getBaseURL() + this.url;
        }
        PutMethod httpMethod = null;
        try {
            if (method.equals("PUT")) {
                httpMethod = new PutMethod(this.url);
            } else if (method.equals("POST")) {
                httpMethod = new PostMethod(this.url);
            } else {
                throw new IllegalArgumentException("method must be one of PUT or POST.");
            }
            httpMethod.setDoAuthentication(authenticate);
            httpMethod.getParams().setParameter("Connection", (Object)"Keep-Alive");
            if (requestContent != null) {
                httpMethod.setContentChunked(false);
                if (requestContent instanceof String) {
                    httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity((String)requestContent, "text/xml", "utf-8"));
                } else if (requestContent instanceof File) {
                    Part[] parts = new Part[]{new StringPart("param_name", "value"), new FilePart(((File)requestContent).getName(), (File)requestContent)};
                    httpMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, httpMethod.getParams()));
                } else {
                    throw new IllegalArgumentException("requestContent must be a String or File");
                }
            }
            this.getClient(authenticate).executeMethod((HttpMethod)httpMethod);
            HttpResponse httpResponse = new HttpResponse((HttpMethod)httpMethod);
            return httpResponse;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    public static junit.framework.Test suite() {
        TestSuite suite = new TestSuite("Admin API TestSuite");
        suite.addTestSuite(TestAdminAPI.class);
        return new DemoObjectTestSetup((junit.framework.Test)suite);
    }

    class HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final Header[] responseHeaders;
        private final Header[] responseFooters;

        HttpResponse(int status, byte[] body, Header[] headers, Header[] footers) {
            this.statusCode = status;
            this.responseBody = body;
            this.responseHeaders = headers;
            this.responseFooters = footers;
        }

        HttpResponse(HttpMethod method) throws IOException {
            this.statusCode = method.getStatusCode();
            InputStream is = method.getResponseBodyAsStream();
            this.responseBody = IOUtils.toByteArray((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            this.responseHeaders = method.getResponseHeaders();
            this.responseFooters = method.getResponseFooters();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] getResponseBody() {
            return this.responseBody;
        }

        public String getResponseBodyString() {
            try {
                return new String(this.responseBody, "UTF-8");
            }
            catch (UnsupportedEncodingException wontHappen) {
                throw new Error(wontHappen);
            }
        }

        public Header[] getResponseHeaders() {
            return this.responseHeaders;
        }

        public Header[] getResponseFooters() {
            return this.responseFooters;
        }

        public Header getResponseHeader(String headerName) {
            for (Header header : this.responseHeaders) {
                if (!header.getName().equalsIgnoreCase(headerName)) continue;
                return header;
            }
            return null;
        }
    }
}

