/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.Date;
import javax.xml.ws.soap.SOAPFaultException;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.common.PID;
import org.fcrepo.server.access.FedoraAPIA;
import org.fcrepo.server.management.FedoraAPIM;
import org.fcrepo.server.types.gen.MIMETypedStream;
import org.fcrepo.server.utilities.StringUtility;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.utilities.Foxml11Document;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestExternalDatastreams
extends FedoraServerTestCase {
    private FedoraAPIM apim;
    private FedoraAPIA apia;

    @Before
    public void setUp() throws Exception {
        this.apim = TestExternalDatastreams.getFedoraClient().getAPIM();
        this.apia = TestExternalDatastreams.getFedoraClient().getAPIA();
        System.setProperty("fedoraServerHost", "localhost");
        System.setProperty("fedoraServerPort", "8080");
    }

    @After
    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIngest() throws Exception {
        String dsLocation;
        String pid = "demo:e_ds_test";
        File content = null;
        try {
            content = this.getTempFile(true);
            dsLocation = content.getCanonicalFile().toURI().toString();
            System.out.println("Expect to succeed: " + dsLocation);
            this.apim.ingest(this.getFoxmlObject(pid, dsLocation), TestExternalDatastreams.FOXML1_1.uri, null);
            this.apia.getDatastreamDissemination(pid, "DS", null);
        }
        finally {
            if (content != null) {
                content.delete();
            }
            this.apim.purgeObject(pid, "test", false);
        }
        try {
            content = this.getTempFile(false);
            dsLocation = content.getCanonicalFile().toURI().toString();
            System.out.println("Expect to fail: " + dsLocation);
            this.apim.ingest(this.getFoxmlObject(pid, dsLocation), TestExternalDatastreams.FOXML1_1.uri, null);
            this.apia.getDatastreamDissemination(pid, "DS", null);
            TestExternalDatastreams.fail((String)"Datastream Dissemination with unallowed dsLocation should have failed.");
        }
        catch (SOAPFaultException e) {
            System.out.println("Checking failure :\"" + e.getMessage() + "\" for \"Policy blocked datastream resolution\"");
            TestExternalDatastreams.assertTrue((boolean)e.getMessage().contains("Policy blocked datastream resolution"));
        }
        finally {
            if (content != null) {
                content.delete();
            }
            this.apim.purgeObject(pid, "test", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDatastream() throws Exception {
        String dsLocation;
        String pid = "demo:e_ds_test_add";
        File content = null;
        this.apim.ingest(this.getFoxmlObject(pid, null), TestExternalDatastreams.FOXML1_1.uri, null);
        try {
            content = this.getTempFile(true);
            dsLocation = content.getCanonicalFile().toURI().toString();
            this.addDatastream(pid, dsLocation);
            this.apia.getDatastreamDissemination(pid, "DS", null);
        }
        finally {
            if (content != null) {
                content.delete();
            }
            this.apim.purgeObject(pid, "test", false);
        }
        this.apim.ingest(this.getFoxmlObject(pid, null), TestExternalDatastreams.FOXML1_1.uri, null);
        try {
            content = this.getTempFile(false);
            dsLocation = content.getCanonicalFile().toURI().toString();
            this.addDatastream(pid, dsLocation);
            this.apia.getDatastreamDissemination(pid, "DS", null);
            TestExternalDatastreams.fail((String)"Datastream Dissemination with unallowed dsLocation should have failed.");
        }
        catch (SOAPFaultException e) {
            System.out.println("Checking failure :\"" + e.getMessage() + "\" for \"Policy blocked datastream resolution\"");
            TestExternalDatastreams.assertTrue((boolean)e.getMessage().contains("Policy blocked datastream resolution"));
        }
        finally {
            if (content != null) {
                content.delete();
            }
            this.apim.purgeObject(pid, "test", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyDatastreamByReference() throws Exception {
        String pid = "demo:e_ds_test_add";
        String dsLocation = TestExternalDatastreams.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC";
        this.apim.ingest(this.getFoxmlObject(pid, dsLocation), TestExternalDatastreams.FOXML1_1.uri, null);
        this.apia.getDatastreamDissemination(pid, "DS", null);
        try {
            dsLocation = TestExternalDatastreams.getBaseURL() + "/get/fedora-system:ContentModel-3.0/RELS-EXT";
            this.modifyDatastreamByReference(pid, dsLocation);
        }
        finally {
            this.apim.purgeObject(pid, "test", false);
        }
        File content = null;
        dsLocation = TestExternalDatastreams.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC";
        this.apim.ingest(this.getFoxmlObject(pid, dsLocation), TestExternalDatastreams.FOXML1_1.uri, null);
        try {
            content = this.getTempFile(false);
            dsLocation = content.getCanonicalFile().toURI().toString();
            this.modifyDatastreamByReference(pid, dsLocation);
            this.apia.getDatastreamDissemination(pid, "DS", null);
            TestExternalDatastreams.fail((String)"Pointing a datastream to an unallowed dsLocation should have failed.");
        }
        catch (SOAPFaultException e) {
            System.out.println("Checking failure :\"" + e.getMessage() + "\" for \"Policy blocked datastream resolution\"");
            TestExternalDatastreams.assertTrue((boolean)e.getMessage().contains("Policy blocked datastream resolution"));
        }
        finally {
            if (content != null) {
                content.delete();
            }
            this.apim.purgeObject(pid, "test", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDatastreamWithChecksum() throws Exception {
        String dsLocation;
        String pid = "demo:e_ds_test_add";
        String checksumType = "MD5";
        this.apim.ingest(this.getFoxmlObject(pid, null), TestExternalDatastreams.FOXML1_1.uri, null);
        File temp = null;
        try {
            temp = this.getTempFile(true);
            dsLocation = temp.getCanonicalFile().toURI().toString();
            String checksum = this.computeChecksum(checksumType, new FileInputStream(temp));
            String dsId = this.addDatastream(pid, dsLocation, checksumType, checksum);
            TestExternalDatastreams.assertEquals((String)"DS", (String)dsId);
            this.apim.purgeDatastream(pid, dsId, null, null, null, false);
            this.addDatastream(pid, dsLocation, checksumType, checksum);
            this.apim.purgeDatastream(pid, dsId, null, null, null, false);
            checksum = "bogus";
            try {
                this.addDatastream(pid, dsLocation, checksumType, checksum);
                TestExternalDatastreams.fail((String)"Adding datastream with bogus checksum should have failed.");
            }
            catch (SOAPFaultException e) {
                TestExternalDatastreams.assertTrue((boolean)e.getMessage().contains("Checksum Mismatch"));
            }
        }
        finally {
            this.apim.purgeObject(pid, "test", false);
            if (temp != null) {
                temp.delete();
            }
        }
        pid = "demo:e_ds_test_add_portable";
        this.apim.ingest(this.getFoxmlObject(pid, null), TestExternalDatastreams.FOXML1_1.uri, null);
        try {
            dsLocation = "http://local.fedora.server/fedora/objects/fedora-system:ContentModel-3.0/datastreams/DC/content";
            MIMETypedStream dc_content = this.apia.getDatastreamDissemination("fedora-system:ContentModel-3.0", "DC", null);
            String checksum = this.computeChecksum(checksumType, new ByteArrayInputStream(dc_content.getStream()));
            String dsId = this.addDatastream(pid, dsLocation, checksumType, checksum);
            TestExternalDatastreams.assertEquals((String)"DS", (String)dsId);
        }
        finally {
            this.apim.purgeObject(pid, "testAddDatastreamWithChecksumType", false);
            if (temp != null) {
                temp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDatastreamWithChecksumType() throws Exception {
        String dsId;
        String dsLocation;
        String pid = "demo:e_ds_test_add";
        String checksumType = "MD5";
        this.apim.ingest(this.getFoxmlObject(pid, null), TestExternalDatastreams.FOXML1_1.uri, "testAddDatastreamWithChecksumType");
        File temp = null;
        try {
            temp = this.getTempFile(true);
            dsLocation = temp.getCanonicalFile().toURI().toString();
            dsId = this.addDatastream(pid, dsLocation, checksumType, null);
            TestExternalDatastreams.assertEquals((String)"DS", (String)dsId);
            String checksum = this.computeChecksum(checksumType, new FileInputStream(temp));
            TestExternalDatastreams.assertEquals((String)this.apim.getDatastream(pid, "DS", null).getChecksum(), (String)checksum);
        }
        finally {
            this.apim.purgeObject(pid, "testAddDatastreamWithChecksumType", false);
            if (temp != null) {
                temp.delete();
            }
        }
        pid = "demo:e_ds_test_portable";
        this.apim.ingest(this.getFoxmlObject(pid, null), TestExternalDatastreams.FOXML1_1.uri, "testAddDatastreamWithChecksumType");
        try {
            dsLocation = "http://local.fedora.server/fedora/objects/fedora-system:ContentModel-3.0/datastreams/DC/content";
            dsId = this.addDatastream(pid, dsLocation, checksumType, null);
            TestExternalDatastreams.assertEquals((String)"DS", (String)dsId);
        }
        finally {
            this.apim.purgeObject(pid, "testAddDatastreamWithChecksumType", false);
            if (temp != null) {
                temp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyDatastreamByReferenceWithChecksum() throws Exception {
        String pid = "file:e_ds_test_add";
        String checksumType = "MD5";
        this.apim.ingest(this.getFoxmlObject(pid, null), TestExternalDatastreams.FOXML1_1.uri, null);
        File temp = null;
        try {
            temp = this.getTempFile(true);
            String contentLocation = temp.getCanonicalFile().toURI().toString();
            String checksum = this.computeChecksum(checksumType, new FileInputStream(temp));
            String dsId = this.addDatastream(pid, contentLocation, checksumType, checksum);
            TestExternalDatastreams.assertEquals((String)"DS", (String)dsId);
            FileOutputStream os = new FileOutputStream(temp);
            os.write("testModifyDatastreamByReferenceWithChecksum".getBytes());
            os.close();
            checksum = this.computeChecksum(checksumType, new FileInputStream(temp));
            this.modifyDatastreamByReference(pid, contentLocation, checksumType, checksum);
            checksum = "bogus";
            try {
                this.modifyDatastreamByReference(pid, contentLocation, checksumType, checksum);
                TestExternalDatastreams.fail((String)"Modifying datastream with bogus checksum should have failed.");
            }
            catch (SOAPFaultException e) {
                TestExternalDatastreams.assertTrue((boolean)e.getMessage().contains("Checksum Mismatch"));
            }
        }
        finally {
            this.apim.purgeObject(pid, "test", false);
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private File getTempFile(boolean allowed) throws IOException {
        File temp = allowed ? File.createTempFile("foo", "isallowed") : File.createTempFile("foo", "banned");
        FileWriter writer = new FileWriter(temp);
        writer.write("Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit");
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return temp;
    }

    private byte[] getFoxmlObject(String pid, String contentLocation) throws Exception {
        Foxml11Document doc = this.createFoxmlObject(pid, contentLocation);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.serialize((OutputStream)out);
        return out.toByteArray();
    }

    private String addDatastream(String pid, String contentLocation) throws Exception {
        return this.addDatastream(pid, contentLocation, null, null);
    }

    private String addDatastream(String pid, String dsLocation, String checksumType, String checksum) throws Exception {
        return this.apim.addDatastream(pid, "DS", null, "testExternalDatastreams", true, "text/plain", "", dsLocation, "E", "A", checksumType, checksum, "testExternalDatastreams");
    }

    private String modifyDatastreamByReference(String pid, String contentLocation) throws Exception {
        return this.modifyDatastreamByReference(pid, contentLocation, null, null);
    }

    private String modifyDatastreamByReference(String pid, String contentLocation, String checksumType, String checksum) throws Exception {
        return this.apim.modifyDatastreamByReference(pid, "DS", TypeUtility.convertStringtoAOS((String[])new String[0]), "testExternalDatastreams", "text/plain", "", contentLocation, checksumType, checksum, "testExternalDatastreams", false);
    }

    private Foxml11Document createFoxmlObject(String spid, String contentLocation) throws Exception {
        PID pid = PID.getInstance((String)spid);
        Date date = new Date(1L);
        Foxml11Document doc = new Foxml11Document(pid.toString());
        doc.addObjectProperty(Foxml11Document.Property.STATE, "A");
        if (contentLocation != null && contentLocation.length() > 0) {
            String ds = "DS";
            String dsv = "DS1.0";
            doc.addDatastream(ds, Foxml11Document.State.A, Foxml11Document.ControlGroup.E, true);
            doc.addDatastreamVersion(ds, dsv, "text/plain", "label", 1, date);
            doc.setContentLocation(dsv, contentLocation, "URL");
        }
        return doc;
    }

    private String computeChecksum(String csType, InputStream is) throws Exception {
        int numread;
        MessageDigest md = MessageDigest.getInstance(csType);
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        byte[] buffer = new byte[5000];
        while ((numread = is.read(buffer, 0, 5000)) > 0) {
            md.update(buffer, 0, numread);
        }
        return StringUtility.byteArraytoHexString((byte[])md.digest());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestExternalDatastreams.class);
    }
}

