/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;

public class TestManagementNotifications
extends FedoraServerTestCase
implements MessageListener {
    private FedoraAPIMMTOM apim;
    private final ArrayBlockingQueue<TextMessage> messages = new ArrayBlockingQueue(10, true);
    private final int messageTimeout = 5000;
    private Connection jmsConnection;
    private Session jmsSession;
    private Destination destination;
    private MessageConsumer messageConsumer;
    public static byte[] dsXML;
    public static byte[] demo998FOXMLObjectXML;

    public static Test suite() {
        TestSuite suite = new TestSuite("Management Notifications TestSuite");
        suite.addTestSuite(TestManagementNotifications.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    public void setUp() throws Exception {
        this.apim = TestManagementNotifications.getFedoraClient().getAPIMMTOM();
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        props.setProperty("java.naming.provider.url", "tcp://localhost:61616");
        props.setProperty("topic.notificationTopic", "fedora.apim.update");
        InitialContext jndi = new InitialContext(props);
        ConnectionFactory jmsConnectionFactory = (ConnectionFactory)jndi.lookup("ConnectionFactory");
        this.jmsConnection = jmsConnectionFactory.createConnection();
        this.jmsSession = this.jmsConnection.createSession(false, 1);
        this.destination = (Topic)jndi.lookup("notificationTopic");
        this.messageConsumer = this.jmsSession.createConsumer(this.destination);
        this.messageConsumer.setMessageListener((MessageListener)this);
        this.jmsConnection.start();
    }

    public void tearDown() throws Exception {
        this.jmsConnection.stop();
        this.jmsSession.close();
        this.jmsConnection.close();
    }

    public void testObjectMethodNotifications() throws Exception {
        System.out.println("Running TestManagementNotifications.testIngest...");
        String pid = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])demo998FOXMLObjectXML), TestManagementNotifications.FOXML1_1.uri, "ingesting new foxml object");
        TestManagementNotifications.assertNotNull((Object)pid);
        this.checkNotification(pid, "ingest");
        System.out.println("Running TestManagementNotifications.testModifyObject...");
        String modifyResult = this.apim.modifyObject(pid, "I", "Updated Object Label", null, "Changed state to inactive and updated label");
        TestManagementNotifications.assertNotNull((Object)modifyResult);
        this.checkNotification(pid, "modifyObject");
        System.out.println("Running TestManagementNotifications.testAddRelationship...");
        boolean addRelResult = this.apim.addRelationship(pid, "rel:isRelatedTo", "demo:5", false, null);
        TestManagementNotifications.assertTrue((boolean)addRelResult);
        this.checkNotification(pid, "addRelationship");
        System.out.println("Running TestManagementNotifications.testAddRelationship...");
        addRelResult = this.apim.addRelationship(PID.toURI((String)pid), "rel:isRelatedTo", "demo:6", false, null);
        TestManagementNotifications.assertTrue((boolean)addRelResult);
        this.checkNotification(pid, "addRelationship");
        System.out.println("Running TestManagementNotifications.testAddRelationship...");
        addRelResult = this.apim.addRelationship(PID.toURI((String)pid) + "/DS1", "rel:isRelatedTo", "demo:7", false, null);
        TestManagementNotifications.assertTrue((boolean)addRelResult);
        this.checkNotification(pid, "addRelationship");
        System.out.println("Running TestManagementNotifications.testPurgeRelationship...");
        boolean purgeRelResult = this.apim.purgeRelationship(pid, "rel:isRelatedTo", "demo:5", false, null);
        TestManagementNotifications.assertTrue((boolean)purgeRelResult);
        this.checkNotification(pid, "purgeRelationship");
        System.out.println("Running TestManagementNotifications.testPurgeRelationship...");
        purgeRelResult = this.apim.purgeRelationship(PID.toURI((String)pid), "rel:isRelatedTo", "demo:6", false, null);
        TestManagementNotifications.assertTrue((boolean)purgeRelResult);
        this.checkNotification(pid, "purgeRelationship");
        System.out.println("Running TestManagementNotifications.testPurgeRelationship...");
        purgeRelResult = this.apim.purgeRelationship(PID.toURI((String)pid) + "/DS1", "rel:isRelatedTo", "demo:7", false, null);
        TestManagementNotifications.assertTrue((boolean)purgeRelResult);
        this.checkNotification(pid, "purgeRelationship");
        System.out.println("Running TestManagementNotifications.testPurgeObject...");
        String purgeResult = this.apim.purgeObject(pid, "Purging object " + pid, false);
        TestManagementNotifications.assertNotNull((Object)purgeResult);
        this.checkNotification(pid, "purgeObject");
    }

    public void testDatastreamMethodNotifications() throws Exception {
        System.out.println("Running TestManagementNotifications.testAddDatastream...");
        String[] altIds = new String[]{"Datastream Alternate ID"};
        String pid = "demo:14";
        String datastreamId = this.apim.addDatastream(pid, "NEWDS1", TypeUtility.convertStringtoAOS((String[])altIds), "A New M-type Datastream", true, "text/xml", "info:myFormatURI/Mtype/stuff#junk", TestManagementNotifications.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", "M", "A", null, null, "adding new datastream");
        TestManagementNotifications.assertEquals((String)datastreamId, (String)"NEWDS1");
        this.checkNotification(pid, "addDatastream");
        datastreamId = this.apim.addDatastream(pid, "NEWDS2", TypeUtility.convertStringtoAOS((String[])altIds), "A New X-type Datastream", true, "text/xml", "info:myFormatURI/Mtype/stuff#junk", TestManagementNotifications.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", "X", "A", null, null, "adding new datastream");
        TestManagementNotifications.assertEquals((String)datastreamId, (String)"NEWDS2");
        this.checkNotification(pid, "addDatastream");
        System.out.println("Running TestManagementNotifications.testModifyDatastreamByReference...");
        String updateTimestamp = this.apim.modifyDatastreamByReference(pid, "NEWDS1", TypeUtility.convertStringtoAOS((String[])altIds), "Modified Datastream by Reference", "text/xml", "info:newMyFormatURI/Mtype/stuff#junk", TestManagementNotifications.getBaseURL() + "/get/fedora-system:ContentModel-3.0/DC", null, null, "modified datastream by reference notification test", false);
        TestManagementNotifications.assertNotNull((Object)updateTimestamp);
        this.checkNotification(pid, "modifyDatastreamByReference");
        System.out.println("Running TestManagementNotifications.testModifyDatastreamByValue...");
        updateTimestamp = this.apim.modifyDatastreamByValue(pid, "NEWDS2", TypeUtility.convertStringtoAOS((String[])altIds), "Modified Datastream by Value", "text/xml", "info:newMyFormatURI/Xtype/stuff#junk", TypeUtility.convertBytesToDataHandler((byte[])dsXML), null, null, "modified datastream by value notification test", false);
        TestManagementNotifications.assertNotNull((Object)updateTimestamp);
        this.checkNotification(pid, "modifyDatastreamByValue");
        System.out.println("Running TestManagementNotifications.testSetDatastreamState...");
        String setStateresult = this.apim.setDatastreamState(pid, "NEWDS1", "I", "Changed state of datstream DC to Inactive");
        TestManagementNotifications.assertNotNull((Object)setStateresult);
        this.checkNotification(pid, "setDatastreamState");
        System.out.println("Running TestManagementNotifications.testSetDatastreamVersionable...");
        String setVersionableResult = this.apim.setDatastreamVersionable(pid, "NEWDS2", false, "Changed versionable on datastream NEWDS1 to false");
        TestManagementNotifications.assertNotNull((Object)setVersionableResult);
        this.checkNotification(pid, "setDatastreamVersionable");
        System.out.println("Running TestManagementNotifications.testPurgeDatastream...");
        List results = this.apim.purgeDatastream(pid, "NEWDS1", null, null, "purging datastream NEWDS1", false);
        TestManagementNotifications.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.checkNotification(pid, "purgeDatastream");
        results = this.apim.purgeDatastream(pid, "NEWDS2", null, null, "purging datastream NEWDS2", false);
        TestManagementNotifications.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        this.checkNotification(pid, "purgeDatastream");
    }

    public void testSelectors() throws Exception {
        System.out.println("Running TestManagementNotifications.testSelectors...");
        this.messageConsumer.close();
        String messageSelector = "methodName LIKE 'ingest%'";
        this.messageConsumer = this.jmsSession.createConsumer(this.destination, messageSelector);
        this.messageConsumer.setMessageListener((MessageListener)this);
        String pid = this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])demo998FOXMLObjectXML), TestManagementNotifications.FOXML1_1.uri, "ingesting new foxml object");
        TestManagementNotifications.assertNotNull((Object)pid);
        this.checkNotification(pid, "ingest");
        String purgeResult = this.apim.purgeObject(pid, "Purging object " + pid, false);
        TestManagementNotifications.assertNotNull((Object)purgeResult);
        this.checkNoNotifications();
    }

    private void checkNotification(String pid, String methodName) throws Exception {
        TextMessage message = this.messages.poll(5000L, TimeUnit.MILLISECONDS);
        if (message == null) {
            TestManagementNotifications.fail((String)("Timeout reached waiting for notification on message regarding: " + methodName));
        }
        String failureText = "Notification <<" + message.getText() + ">> did not include text: " + methodName;
        TestManagementNotifications.assertTrue((String)failureText, (boolean)message.getText().contains(methodName));
        failureText = "Notification <<" + message.getStringProperty("methodName") + ">> did not include methodName property with " + "value: " + methodName;
        TestManagementNotifications.assertTrue((String)failureText, (boolean)methodName.equals(message.getStringProperty("methodName")));
        failureText = "Notification did not include pid property with value: " + pid;
        TestManagementNotifications.assertTrue((String)failureText, (boolean)pid.equals(message.getStringProperty("pid")));
    }

    private void checkNoNotifications() throws Exception {
        TextMessage message = this.messages.poll(5000L, TimeUnit.MILLISECONDS);
        if (message != null) {
            TestManagementNotifications.fail((String)"No messages should be received during this test.");
        }
    }

    public void onMessage(Message msg) {
        if (msg instanceof TextMessage) {
            this.messages.add((TextMessage)msg);
        }
    }

    public static void main(String[] args) {
        TestRunner.run(TestManagementNotifications.class);
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("<oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">");
        sb.append("<dc:title>Dublin Core Record</dc:title>");
        sb.append("<dc:creator>Author</dc:creator>");
        sb.append("<dc:subject>Subject</dc:subject>");
        sb.append("<dc:description>Description</dc:description>");
        sb.append("<dc:publisher>Publisher</dc:publisher>");
        sb.append("<dc:format>MIME type</dc:format>");
        sb.append("<dc:identifier>Identifier</dc:identifier>");
        sb.append("</oai_dc:dc>");
        try {
            dsXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"demo:998\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"Image of Coliseum in Rome\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#createdDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/view#lastModifiedDate\" VALUE=\"2004-12-10T00:21:57Z\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("</foxml:digitalObject>");
        try {
            demo998FOXMLObjectXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

