/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.TestSuite;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.Datastream;
import org.fcrepo.server.types.gen.FieldSearchQuery;
import org.fcrepo.server.types.gen.FieldSearchResult;
import org.fcrepo.server.types.gen.ObjectFactory;
import org.fcrepo.server.types.gen.ObjectFields;
import org.fcrepo.server.types.mtom.gen.MIMETypedStream;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.ValidatorEntityResolver;
import org.jrdf.graph.Triple;
import org.junit.Test;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.io.TripleIteratorFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TestRESTAPI
extends FedoraServerTestCase {
    private FedoraAPIAMTOM apia;
    private FedoraAPIMMTOM apim;
    private static String authAccessProperty = "fedora.authorize.access";
    protected Boolean authorizeAccess = null;
    private static String DEMO_OWNERID = "nondefaultOwner";
    private static String DEMO_REST;
    private static byte[] DEMO_REST_FOXML;
    private static String DEMO_MIN;
    private static String DEMO_MIN_PID;
    private final PID pid = PID.getInstance((String)"demo:REST");
    private static final String REST_RESOURCE_PATH;
    private static String DS1RelsFilename;
    private static String DS2LabelFilename;
    private static String DS3LabelFilename;
    private static String DodgyChars;
    private static String DS4LabelFilenameOriginal;
    private static String DS4LabelFilename;
    private static String DS5ID;
    private static String DS6ID;
    protected String url;
    static SimpleDateFormat df;
    private static final Date now;
    private static final String datetime;
    private static final String laterDateTime;
    private static final String earlierDateTime = "2001-01-01T00:00:00.000Z";
    private boolean chunked = false;

    public void setUp() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("management", "http://www.fedora.info/definitions/1/0/management/");
        nsMap.put("access", "http://www.fedora.info/definitions/1/0/access/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        if (DEMO_MIN == null) {
            DEMO_MIN = FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/demo_min.xml"), (String)"UTF-8");
        }
        if (DEMO_MIN_PID == null) {
            DEMO_MIN_PID = FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/demo_min_pid.xml"), (String)"UTF-8");
        }
        if (DEMO_REST == null) {
            StringTemplate tpl = new StringTemplate(FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/demo_rest.xml"), (String)"UTF-8"));
            tpl.setAttribute("MODEL_DOWNLOAD_FILENAME", (Object)TestRESTAPI.MODEL.DOWNLOAD_FILENAME.localName);
            tpl.setAttribute("DS1_RELS_FILENAME", (Object)DS1RelsFilename);
            tpl.setAttribute("MODEL_URI", (Object)TestRESTAPI.MODEL.uri);
            tpl.setAttribute("DATETIME", (Object)datetime);
            tpl.setAttribute("FEDORA_BASE_URL", (Object)TestRESTAPI.getBaseURL());
            tpl.setAttribute("DS2_LABEL_FILENAME", (Object)DS2LabelFilename);
            tpl.setAttribute("DS3_LABEL_FILENAME", (Object)DS3LabelFilename);
            tpl.setAttribute("DS4_LABEL_FILENAME_ORIGINAL", (Object)DS4LabelFilenameOriginal);
            DEMO_REST = tpl.toString();
            DEMO_REST_FOXML = DEMO_REST.getBytes("UTF-8");
        }
        this.apia = TestRESTAPI.getFedoraClient().getAPIAMTOM();
        this.apim = TestRESTAPI.getFedoraClient().getAPIMMTOM();
        this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])DEMO_REST_FOXML), TestRESTAPI.FOXML1_1.uri, "TestRESTAPI.setUp: ingesting new foxml object " + this.pid);
    }

    public void tearDown() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
        this.apim.purgeObject(this.pid.toString(), "TestRESTAPI.tearDown: purging " + this.pid, false);
    }

    private boolean getAuthAccess() {
        if (this.authorizeAccess == null) {
            String property = System.getProperty(authAccessProperty);
            if (property.equals("true")) {
                this.authorizeAccess = true;
            } else if (property.equals("false")) {
                this.authorizeAccess = false;
            } else {
                TestRESTAPI.assertTrue((String)("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty), (boolean)false);
                throw new RuntimeException("Failed to determine whether to perform authorization on Access requests from: " + authAccessProperty);
            }
        }
        return this.authorizeAccess;
    }

    @Test
    public void testGetWADL() throws Exception {
        this.url = "/objects/application.wadl";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false, false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess(), false).getStatusCode());
    }

    @Test
    public void testGetObjectProfile() throws Exception {
        this.url = String.format("/objects/%s", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s?format=xml", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        String responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<objLabel>"));
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<objOwnerId>"));
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<objCreateDate>"));
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<objLastModDate>"));
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<objDissIndexViewURL>"));
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<objItemIndexViewURL>"));
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<objState>"));
        this.url = String.format("/objects/%s?asOfDateTime=%s", this.pid.toString(), datetime);
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s", "demo:BOGUS_PID");
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)404, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testListMethods() throws Exception {
        this.url = String.format("/objects/%s/methods", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s/methods?format=xml", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s/methods?asOfDateTime=%s", this.pid.toString(), datetime);
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testListMethodsForSDep() throws Exception {
        this.url = String.format("/objects/%s/methods/fedora-system:3", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s/methods/fedora-system:3?format=xml", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        String responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseXML.contains("sDef=\"fedora-system:3\""));
        this.url = String.format("/objects/%s/methods/fedora-system:3?asOfDateTime=%s", this.pid.toString(), datetime);
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testGETMethodBuiltInBadMethod() throws Exception {
        this.url = String.format("/objects/%s/methods/fedora-system:3/noSuchMethod", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertFalse((200 == this.get(this.getAuthAccess()).getStatusCode() ? 1 : 0) != 0);
    }

    public void testGETMethodBuiltInBadUserArg() throws Exception {
        this.url = String.format("/objects/%s/methods/fedora-system:3/viewMethodIndex?noSuchArg=foo", this.pid.toString());
        TestRESTAPI.assertFalse((200 == this.get(this.getAuthAccess()).getStatusCode() ? 1 : 0) != 0);
    }

    public void testGETMethodBuiltInNoArg() throws Exception {
        this.url = String.format("/objects/%s/methods/fedora-system:3/viewMethodIndex", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testGETMethodCustomBadMethod() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/noSuchMethod";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertFalse((200 == this.get(this.getAuthAccess()).getStatusCode() ? 1 : 0) != 0);
    }

    public void testGETMethodCustomBadUserArg() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/getDocumentStyle1?noSuchArg=foo";
        TestRESTAPI.assertFalse((200 == this.get(this.getAuthAccess()).getStatusCode() ? 1 : 0) != 0);
    }

    public void testGETMethodCustomNoArg() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/getDocumentStyle1";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testGETMethodCustomGoodUserArg() throws Exception {
        this.url = "/objects/demo:29/methods/demo:27/resizeImage?width=50";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertEquals((String)"image/jpeg", (String)response.getResponseHeader("Content-Type").getValue());
    }

    public void testGETMethodCustomGoodUserArgGoodDate() throws Exception {
        this.url = "/objects/demo:29/methods/demo:27/resizeImage?width=50&asOfDateTime=" + datetime;
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertEquals((String)"image/jpeg", (String)response.getResponseHeader("Content-Type").getValue());
    }

    public void testGETMethodCustomUserArgBadDate() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/getDocumentStyle1?width=50&asOfDateTime=badDate";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertFalse((200 == this.get(this.getAuthAccess()).getStatusCode() ? 1 : 0) != 0);
    }

    public void testGETMethodCustomUserArgEarlyDate() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/getDocumentStyle1?width=50&asOfDateTime=1999-11-21T16:38:32.200Z";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)404, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testGETMethodCustomGoodDate() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/getDocumentStyle1?asOfDateTime=" + datetime;
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testGETMethodCustomBadDate() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/getDocumentStyle1?asOfDateTime=badDate";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertFalse((200 == this.get(this.getAuthAccess()).getStatusCode() ? 1 : 0) != 0);
    }

    public void testGETMethodCustomEarlyDate() throws Exception {
        this.url = "/objects/demo:14/methods/demo:12/getDocumentStyle1?asOfDateTime=1999-11-21T16:38:32.200Z";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)404, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testListDatastreams() throws Exception {
        this.url = String.format("/objects/%s/datastreams", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s/datastreams?format=xml", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s/datastreams?asOfDateTime=%s", this.pid.toString(), datetime);
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s/datastreams?format=xml&profiles=true", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        HttpResponse response = this.get(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertTrue((response.getResponseBodyString().indexOf("datastreamProfile") > -1 ? 1 : 0) != 0);
    }

    public void testDeletedObject() throws Exception {
        if (!this.getAuthAccess()) {
            this.apim.modifyObject(this.pid.toString(), "D", null, null, "Mark object as deleted");
            this.url = String.format("/objects/%s/datastreams", this.pid.toString());
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
            TestRESTAPI.assertEquals((int)200, (int)this.get(true).getStatusCode());
        }
    }

    public void testGetDatastreamProfile() throws Exception {
        this.url = String.format("/objects/%s/datastreams/RELS-EXT", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        HttpResponse response = this.get(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        String responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<html>"));
        this.url = String.format("/objects/%s/datastreams/RELS-EXT?format=xml", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        response = this.get(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<dsLabel>"));
        this.url = String.format("/objects/%s/datastreams/RELS-EXT?asOfDateTime=%s&format=xml", this.pid.toString(), datetime);
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        response = this.get(true, false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseXML.contains("<dsLabel>"));
        this.url = String.format("/objects/%s/datastreams/BOGUS_DSID", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        TestRESTAPI.assertEquals((int)404, (int)this.get(true).getStatusCode());
    }

    public void testGetDatastreamHistory() throws Exception {
        this.url = "/objects/new";
        TestRESTAPI.assertEquals((int)401, (int)this.post(DEMO_MIN_PID, false).getStatusCode());
        HttpResponse response = this.post(DEMO_MIN_PID, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        this.url = String.format("/objects/demo:1234/datastreams/DS1/history?format=xml", new Object[0]);
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        response = this.get(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        String responseXML = new String(response.responseBody, "UTF-8");
        String control = FileUtils.readFileToString((File)new File(REST_RESOURCE_PATH + "/datastreamHistory.xml"), (String)"UTF-8");
        StringTemplate tpl = new StringTemplate(control);
        tpl.setAttribute("FEDORA_BASE_URL", (Object)(TestRESTAPI.getProtocol() + "://" + TestRESTAPI.getHost() + ":" + TestRESTAPI.getPort()));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff xmldiff = new Diff(tpl.toString(), responseXML);
        TestRESTAPI.assertTrue((String)xmldiff.toString(), (boolean)xmldiff.identical());
        this.url = "/objects/demo:1234/datastreams/BOGUS_DSID";
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        TestRESTAPI.assertEquals((int)404, (int)this.get(true).getStatusCode());
        this.url = "/objects/demo:1234";
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
    }

    public void testGetDatastreamDissemination() throws Exception {
        this.url = String.format("/objects/%s/datastreams/RELS-EXT/content", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        Header length = response.getResponseHeader("content-length");
        TestRESTAPI.assertNotNull((Object)length);
        TestRESTAPI.assertNotNull((Object)length.getValue());
        long lengthlong = Long.parseLong(length.getValue());
        TestRESTAPI.assertTrue((lengthlong > 0L ? 1 : 0) != 0);
        String responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseXML.contains("rdf:Description"));
        this.url = String.format("/objects/%s/datastreams/RELS-EXT/content?asOfDateTime=%s", this.pid.toString(), datetime);
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        length = response.getResponseHeader("content-length");
        TestRESTAPI.assertNotNull((Object)length);
        TestRESTAPI.assertNotNull((Object)length.getValue());
        lengthlong = Long.parseLong(length.getValue());
        TestRESTAPI.assertTrue((lengthlong > 0L ? 1 : 0) != 0);
        responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseXML.contains("rdf:Description"));
        this.url = String.format("/objects/%s/datastreams/BOGUS_DSID/content", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)404, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testFindObjects() throws Exception {
        this.url = String.format("/objects?pid=true&terms=%s&query=&resultFormat=xml", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess(), false).getStatusCode());
    }

    public void testFindObjectWithSingleQuote() throws Exception {
        this.url = String.format("/objects?pid=true&description=true&terms='Coliseum'&query&maxResults=20&resultFormat=xml", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse resp = this.get(this.getAuthAccess(), false);
        String xmlResult = new String(resp.getResponseBody());
        TestRESTAPI.assertEquals((int)200, (int)resp.getStatusCode());
        TestRESTAPI.assertTrue((xmlResult.indexOf("<pid>demo:REST</pid>") > 0 ? 1 : 0) != 0);
    }

    public void testResumeFindObjects() throws Exception {
        this.url = "/objects?pid=true&query=&resultFormat=xml";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse response = this.get(this.getAuthAccess(), false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        String responseXML = new String(response.responseBody, "UTF-8");
        String sessionToken = responseXML.substring(responseXML.indexOf("<token>") + 7, responseXML.indexOf("</token>"));
        this.url = String.format("/objects?pid=true&query=&resultFormat=xml&sessionToken=%s", sessionToken);
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    public void testFindObjectsBadSyntax() throws Exception {
        this.url = "/objects?pid=true&query=label%3D%3F&maxResults=20";
        for (int i = 0; i < 101; ++i) {
            TestRESTAPI.assertEquals((int)500, (int)this.get(this.getAuthAccess()).getStatusCode());
        }
    }

    public void testGetObjectHistory() throws Exception {
        this.url = String.format("/objects/%s/versions", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/%s/versions?format=xml", this.pid.toString());
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        TestRESTAPI.assertEquals((int)200, (int)this.get(this.getAuthAccess()).getStatusCode());
    }

    private String extractPid(String source) {
        Matcher m = Pattern.compile("^.*/([^/]+$)").matcher(source);
        String pid = null;
        if (m.find() && m.groupCount() == 1) {
            pid = m.group(1);
        }
        pid = pid.replaceAll("\n", "").replaceAll("\r", "").replaceAll("%3A", ":");
        return pid;
    }

    public void testIngest() throws Exception {
        this.url = String.format("/objects/new", new Object[0]);
        TestRESTAPI.assertEquals((int)401, (int)this.post("", false).getStatusCode());
        HttpResponse response = this.post("", true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        String emptyObjectPid = this.extractPid(response.getResponseHeader("Location").getValue());
        TestRESTAPI.assertNotNull((Object)emptyObjectPid);
        String responseBody = new String(response.getResponseBody(), "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseBody.equals(emptyObjectPid));
        this.url = String.format("/objects/%s", emptyObjectPid);
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
        TestRESTAPI.assertEquals((int)404, (int)this.get(this.getAuthAccess()).getStatusCode());
        this.url = String.format("/objects/new?namespace=test", new Object[0]);
        TestRESTAPI.assertEquals((int)401, (int)this.post("", false).getStatusCode());
        response = this.post("", true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        emptyObjectPid = this.extractPid(response.getResponseHeader("Location").getValue());
        TestRESTAPI.assertTrue((boolean)emptyObjectPid.startsWith("test"));
        this.url = String.format("/objects/%s", emptyObjectPid);
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
        this.url = String.format("/objects/%s", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
        this.url = String.format("/objects/%s?ownerId=%s", this.pid.toString(), DEMO_OWNERID);
        TestRESTAPI.assertEquals((int)401, (int)this.post((String)null, false).getStatusCode());
        response = this.post((String)null, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        Header locationHeader = response.getResponseHeader("location");
        TestRESTAPI.assertNotNull((Object)locationHeader);
        TestRESTAPI.assertTrue((boolean)locationHeader.getValue().contains(URLEncoder.encode(this.pid.toString(), "UTF-8")));
        responseBody = new String(response.getResponseBody(), "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseBody.equals(this.pid.toString()));
        response = this.get(true);
        responseBody = new String(response.getResponseBody(), "UTF-8");
        TestRESTAPI.assertTrue((responseBody.indexOf(DEMO_OWNERID) > 0 ? 1 : 0) != 0);
        this.url = String.format("/objects/%s", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
        this.url = String.format("/objects/%s", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.post(DEMO_REST, false).getStatusCode());
        response = this.post(DEMO_REST, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        locationHeader = response.getResponseHeader("location");
        TestRESTAPI.assertNotNull((Object)locationHeader);
        TestRESTAPI.assertTrue((boolean)locationHeader.getValue().contains(URLEncoder.encode(this.pid.toString(), "UTF-8")));
        responseBody = new String(response.getResponseBody(), "UTF-8");
        TestRESTAPI.assertTrue((boolean)responseBody.equals(this.pid.toString()));
        this.url = String.format("/objects/new", new Object[0]);
        TestRESTAPI.assertEquals((int)401, (int)this.post(DEMO_MIN, false).getStatusCode());
        response = this.post(DEMO_MIN, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        String minimalObjectPid = this.extractPid(response.getResponseHeader("Location").getValue());
        this.url = String.format("/objects/%s", minimalObjectPid);
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
    }

    public void testIngestWithParameterPid() throws Exception {
        this.url = String.format("/objects/new", new Object[0]);
        TestRESTAPI.assertEquals((int)401, (int)this.post(DEMO_MIN_PID, false).getStatusCode());
        HttpResponse response = this.post(DEMO_MIN_PID, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        this.url = String.format("/objects/%s", "demo:1234");
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
        this.url = String.format("/objects/%s", "demo:234");
        TestRESTAPI.assertEquals((int)401, (int)this.post(DEMO_MIN_PID, false).getStatusCode());
        response = this.post(DEMO_MIN_PID, true);
        TestRESTAPI.assertEquals((int)500, (int)response.getStatusCode());
        this.url = String.format("/objects/%s", "demo:1234");
        TestRESTAPI.assertEquals((int)401, (int)this.post(DEMO_MIN_PID, false).getStatusCode());
        response = this.post(DEMO_MIN_PID, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        this.url = String.format("/objects/%s", "demo:1234");
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
        this.url = String.format("/objects/%s", "demo:234");
        TestRESTAPI.assertEquals((int)401, (int)this.post(DEMO_MIN, false).getStatusCode());
        response = this.post(DEMO_MIN, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        this.url = String.format("/objects/%s", "demo:234");
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
    }

    public void testModifyObject() throws Exception {
        this.url = String.format("/objects/%s?label=%s", this.pid.toString(), "foo");
        TestRESTAPI.assertEquals((int)401, (int)this.put("", false).getStatusCode());
        HttpResponse response = this.put("", true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertEquals((String)"foo", (String)this.apia.getObjectProfile(this.pid.toString(), null).getObjLabel());
    }

    public void testGetObjectXML() throws Exception {
        this.url = String.format("/objects/%s/objectXML", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.get(true).getStatusCode());
    }

    public void testValidate() throws Exception {
        String[] resultFields = new String[]{"pid"};
        BigInteger maxResults = new BigInteger("1000");
        FieldSearchQuery query = new FieldSearchQuery();
        ObjectFactory factory = new ObjectFactory();
        query.setTerms(factory.createFieldSearchQueryTerms("*"));
        FieldSearchResult result = this.apia.findObjects(TypeUtility.convertStringtoAOS((String[])resultFields), maxResults, query);
        List fields = result.getResultList().getObjectFields();
        String pid = "";
        for (ObjectFields objectFields : fields) {
            if (objectFields == null) continue;
            pid = objectFields.getPid() != null ? (String)objectFields.getPid().getValue() : "";
            this.url = String.format("/objects/%s/validate", pid.toString());
            HttpResponse getTrue = this.get(true);
            TestRESTAPI.assertEquals((String)pid.toString(), (int)401, (int)this.get(false).getStatusCode());
            TestRESTAPI.assertEquals((String)pid.toString(), (int)200, (int)getTrue.getStatusCode());
            String responseXML = getTrue.getResponseBodyString();
            this.assertXpathExists("/management:validation[@valid='true']", responseXML);
        }
        this.url = String.format("/objects/%s/validate?asOfDateTime=%s", pid.toString(), df.format(new Date()));
        HttpResponse getTrue = this.get(true);
        TestRESTAPI.assertEquals((String)pid.toString(), (int)401, (int)this.get(false).getStatusCode());
        TestRESTAPI.assertEquals((String)pid.toString(), (int)200, (int)getTrue.getStatusCode());
        String responseXML = getTrue.getResponseBodyString();
        this.assertXpathExists("/management:validation[@valid='true']", responseXML);
        this.url = String.format("/objects/%s/validate?asOfDateTime=%s", pid.toString(), earlierDateTime);
        getTrue = this.get(true);
        TestRESTAPI.assertEquals((String)pid.toString(), (int)401, (int)this.get(false).getStatusCode());
        TestRESTAPI.assertEquals((String)pid.toString(), (int)200, (int)getTrue.getStatusCode());
        responseXML = getTrue.getResponseBodyString();
        this.assertXpathExists("/management:validation[@valid='false']", responseXML);
    }

    public void testExportObject() throws Exception {
        this.url = String.format("/objects/%s/export", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.get(true).getStatusCode());
        this.url = String.format("/objects/%s/export?context=public", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.get(true).getStatusCode());
    }

    public void testPurgeObject() throws Exception {
        this.url = "/objects/demo:TEST_PURGE";
        TestRESTAPI.assertEquals((int)401, (int)this.post("", false).getStatusCode());
        TestRESTAPI.assertEquals((int)201, (int)this.post("", true).getStatusCode());
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
    }

    public void testAddDatastream() throws Exception {
        String xmlData = "<foo>bar</foo>";
        String dsPath = "/objects/" + this.pid + "/datastreams/FOO";
        this.url = dsPath + "?controlGroup=X&dsLabel=foo";
        TestRESTAPI.assertEquals((int)401, (int)this.post(xmlData, false).getStatusCode());
        HttpResponse response = this.post(xmlData, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        Header locationHeader = response.getResponseHeader("location");
        TestRESTAPI.assertNotNull((Object)locationHeader);
        TestRESTAPI.assertEquals((String)new URL(this.url.substring(0, this.url.indexOf(63))).toString(), (String)locationHeader.getValue());
        TestRESTAPI.assertEquals((String)"text/xml", (String)response.getResponseHeader("Content-Type").getValue());
        this.url = dsPath + "?format=xml";
        TestRESTAPI.assertEquals((String)response.getResponseBodyString(), (String)this.get(true).getResponseBodyString());
        String mimeType = "text/plain";
        Datastream ds = this.apim.getDatastream(this.pid.toString(), "BAR", null);
        TestRESTAPI.assertNull((Object)ds);
        dsPath = "/objects/" + this.pid + "/datastreams/BAR";
        this.url = dsPath + "?controlGroup=M&dsLabel=bar&mimeType=" + mimeType;
        File temp = File.createTempFile("test", null);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(temp));
        os.write(42);
        os.close();
        TestRESTAPI.assertEquals((int)401, (int)this.post(temp, false).getStatusCode());
        response = this.post(temp, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        locationHeader = response.getResponseHeader("location");
        TestRESTAPI.assertNotNull((Object)locationHeader);
        TestRESTAPI.assertEquals((String)new URL(this.url.substring(0, this.url.indexOf(63))).toString(), (String)locationHeader.getValue());
        TestRESTAPI.assertEquals((String)"text/xml", (String)response.getResponseHeader("Content-Type").getValue());
        this.url = dsPath + "?format=xml";
        TestRESTAPI.assertEquals((String)response.getResponseBodyString(), (String)this.get(true).getResponseBodyString());
        ds = this.apim.getDatastream(this.pid.toString(), "BAR", null);
        TestRESTAPI.assertNotNull((Object)ds);
        TestRESTAPI.assertEquals((String)ds.getMIMEType(), (String)mimeType);
    }

    public void testModifyDatastreamByReference() throws Exception {
        this.url = String.format("/objects/%s/datastreams/BAR?controlGroup=M&dsLabel=testModifyDatastreamByReference(bar)", this.pid.toString());
        File temp = File.createTempFile("test", null);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(temp));
        os.write(42);
        os.close();
        TestRESTAPI.assertEquals((int)401, (int)this.post(temp, false).getStatusCode());
        TestRESTAPI.assertEquals((int)201, (int)this.post(temp, true).getStatusCode());
        this.url = String.format("/objects/%s/datastreams/BAR", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.put(temp, false).getStatusCode());
        HttpResponse response = this.put(temp, true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertEquals((String)"text/xml", (String)response.getResponseHeader("Content-Type").getValue());
        this.url = this.url + "?format=xml";
        TestRESTAPI.assertEquals((String)response.getResponseBodyString(), (String)this.get(true).getResponseBodyString());
        this.url = "/objects/" + this.pid + "/datastreams/BOGUS_DS";
        TestRESTAPI.assertEquals((int)404, (int)this.put(temp, true).getStatusCode());
        this.url = String.format("/objects/%s/datastreams/BAR", this.pid.toString());
        response = this.post(temp, true);
        TestRESTAPI.assertEquals((int)201, (int)response.getStatusCode());
        Header locationHeader = response.getResponseHeader("location");
        TestRESTAPI.assertNotNull((Object)locationHeader);
        TestRESTAPI.assertEquals((String)this.url, (String)locationHeader.getValue());
        TestRESTAPI.assertEquals((String)"text/xml", (String)response.getResponseHeader("Content-Type").getValue());
        this.url = this.url + "?format=xml";
        TestRESTAPI.assertEquals((String)response.getResponseBodyString(), (String)this.get(true).getResponseBodyString());
        String newLabel = "tikibar";
        this.url = String.format("/objects/%s/datastreams/BAR?dsLabel=%s", this.pid.toString(), newLabel);
        TestRESTAPI.assertEquals((int)401, (int)this.put(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put(true).getStatusCode());
        TestRESTAPI.assertEquals((String)newLabel, (String)this.apim.getDatastream(this.pid.toString(), "BAR", null).getLabel());
        String newLocation = "http://" + TestRESTAPI.getHost() + ":" + TestRESTAPI.getPort() + "/" + TestRESTAPI.getFedoraAppServerContext() + "/get/demo:REST/DC";
        this.url = String.format("/objects/%s/datastreams/EXTDS?dsLocation=%s", this.pid.toString(), newLocation);
        TestRESTAPI.assertEquals((int)401, (int)this.put(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put(true).getStatusCode());
        TestRESTAPI.assertEquals((String)newLocation, (String)this.apim.getDatastream(this.pid.toString(), "EXTDS", null).getLocation());
        String dcDS = new String(TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(this.pid.toString(), "DC", null).getStream()));
        String extDS = new String(TypeUtility.convertDataHandlerToBytes((DataHandler)this.apia.getDatastreamDissemination(this.pid.toString(), "EXTDS", null).getStream()));
        TestRESTAPI.assertEquals((String)dcDS, (String)extDS);
        if (this.getAuthAccess()) {
            this.url = String.format("/objects/%s/datastreams/DS1?dsLocation=%s", this.pid.toString(), newLocation);
            TestRESTAPI.assertEquals((int)401, (int)this.put(false).getStatusCode());
            TestRESTAPI.assertEquals((int)500, (int)this.put(true).getStatusCode());
        }
        newLocation = TestRESTAPI.getBaseURL() + "/ri/index.xsl";
        this.url = String.format("/objects/%s/datastreams/DS1?dsLocation=%s", this.pid.toString(), newLocation);
        TestRESTAPI.assertEquals((int)401, (int)this.put(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put(true).getStatusCode());
    }

    public void testModifyDatastreamByValue() throws Exception {
        String xmlData = "<baz>quux</baz>";
        this.url = String.format("/objects/%s/datastreams/DS1?dsLabel=testModifyDatastreamByValue", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.put(xmlData, false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put(xmlData, true).getStatusCode());
        MIMETypedStream ds1 = this.apia.getDatastreamDissemination(this.pid.toString(), "DS1", null);
        this.assertXMLEqual(xmlData, new String(TypeUtility.convertDataHandlerToBytes((DataHandler)ds1.getStream()), "UTF-8"));
    }

    public void testModifyDatastreamNoContent() throws Exception {
        String label = "testModifyDatastreamNoContent";
        this.url = String.format("/objects/%s/datastreams/DS1?dsLabel=%s", this.pid.toString(), label);
        TestRESTAPI.assertEquals((int)401, (int)this.put("", false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put("", true).getStatusCode());
        Datastream ds1 = this.apim.getDatastream(this.pid.toString(), "DS1", null);
        TestRESTAPI.assertEquals((String)label, (String)ds1.getLabel());
    }

    public void testSetDatastreamState() throws Exception {
        String state = "D";
        this.url = String.format("/objects/%s/datastreams/DS1?dsState=%s", this.pid.toString(), state);
        TestRESTAPI.assertEquals((int)401, (int)this.put("", false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put("", true).getStatusCode());
        Datastream ds1 = this.apim.getDatastream(this.pid.toString(), "DS1", null);
        TestRESTAPI.assertEquals((String)state, (String)ds1.getState());
    }

    public void testSetDatastreamVersionable() throws Exception {
        boolean versionable = false;
        this.url = String.format("/objects/%s/datastreams/DS1?versionable=%s", this.pid.toString(), versionable);
        TestRESTAPI.assertEquals((int)401, (int)this.put("", false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put("", true).getStatusCode());
        Datastream ds1 = this.apim.getDatastream(this.pid.toString(), "DS1", null);
        TestRESTAPI.assertEquals((boolean)versionable, (boolean)ds1.isVersionable());
    }

    public void testPurgeDatastream() throws Exception {
        this.url = String.format("/objects/%s/datastreams/RELS-EXT", this.pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
    }

    public void testGetNextPID() throws Exception {
        this.url = "/objects/nextPID";
        TestRESTAPI.assertEquals((int)401, (int)this.post("", false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.post("", true, false).getStatusCode());
    }

    public void testLifecycle() throws Exception {
        HttpResponse response = null;
        this.url = "/objects/nextPID?format=xml";
        TestRESTAPI.assertEquals((int)401, (int)this.post("", false).getStatusCode());
        response = this.post("", true, false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        String responseXML = new String(response.responseBody, "UTF-8");
        String pid = responseXML.substring(responseXML.indexOf("<pid>") + 5, responseXML.indexOf("</pid>"));
        String label = "Lifecycle-Test-Label";
        this.url = String.format("/objects/%s?label=%s", pid, label);
        TestRESTAPI.assertEquals((int)401, (int)this.post("", false).getStatusCode());
        TestRESTAPI.assertEquals((int)201, (int)this.post("", true).getStatusCode());
        String datastreamData = "<test>Test Datastream</test>";
        this.url = String.format("/objects/%s/datastreams/TESTDS?controlGroup=X&dsLabel=Test", pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.post(datastreamData, false).getStatusCode());
        TestRESTAPI.assertEquals((int)201, (int)this.post(datastreamData, true).getStatusCode());
        this.url = String.format("/objects/%s/objectXML", pid);
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        response = this.get(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((responseXML.indexOf(label) > 0 ? 1 : 0) != 0);
        TestRESTAPI.assertTrue((responseXML.indexOf(datastreamData) > 0 ? 1 : 0) != 0);
        label = "Updated-Label";
        this.url = String.format("/objects/%s?label=%s", pid.toString(), label);
        TestRESTAPI.assertEquals((int)401, (int)this.put("", false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put("", true).getStatusCode());
        datastreamData = "<test>Update Test</test>";
        this.url = String.format("/objects/%s/datastreams/TESTDS", pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.put(datastreamData, false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.put(datastreamData, true).getStatusCode());
        this.url = String.format("/objects/%s/export", pid.toString());
        TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        response = this.get(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        responseXML = new String(response.responseBody, "UTF-8");
        TestRESTAPI.assertTrue((responseXML.indexOf(label) > 0 ? 1 : 0) != 0);
        TestRESTAPI.assertTrue((responseXML.indexOf(datastreamData) > 0 ? 1 : 0) != 0);
        this.url = String.format("/objects/%s/datastreams/TESTDS", pid);
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
        this.url = String.format("/objects/%s", pid);
        TestRESTAPI.assertEquals((int)401, (int)this.delete(false).getStatusCode());
        TestRESTAPI.assertEquals((int)200, (int)this.delete(true).getStatusCode());
    }

    public void testChunked() throws Exception {
        this.chunked = true;
        this.testIngest();
        this.testModifyDatastreamByValue();
        this.testModifyDatastreamNoContent();
        this.testLifecycle();
    }

    public void testResponseOverride() throws Exception {
        this.url = String.format("/objects/%s", "demo:BOGUS_PID");
        TestRESTAPI.assertEquals((int)404, (int)this.put("", true).getStatusCode());
        this.url = String.format("/objects/%s?flash=true", "demo:BOGUS_PID");
        TestRESTAPI.assertEquals((int)200, (int)this.put("", true).getStatusCode());
    }

    @Test
    public void testDatastreamDisseminationContentDispositionFromRels() throws Exception {
        this.url = "/objects/demo:REST/datastreams/DS1/content";
        HttpResponse response = this.get(this.getAuthAccess(), false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.CheckCDHeader(response, "inline", DS1RelsFilename);
        this.url = this.url + "?download=true";
        response = this.get(this.getAuthAccess(), false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.CheckCDHeader(response, "attachment", DS1RelsFilename);
    }

    @Test
    public void testDatastreamDisseminationContentDispositionFromLabel() throws Exception {
        this.url = "/objects/demo:REST/datastreams/DS2/content?download=true";
        HttpResponse response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.CheckCDHeader(response, "attachment", DS2LabelFilename + ".jpg");
        this.url = "/objects/demo:REST/datastreams/DS3/content?download=true";
        response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.CheckCDHeader(response, "attachment", DS3LabelFilename + ".bin");
        this.url = "/objects/demo:REST/datastreams/DS4/content?download=true";
        response = this.get(this.getAuthAccess(), false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.CheckCDHeader(response, "attachment", DS4LabelFilename + ".xml");
    }

    @Test
    public void testDatastreamDisseminationContentDispositionFromId() throws Exception {
        this.url = "/objects/demo:REST/datastreams/DS5/content?download=true";
        HttpResponse response = this.get(this.getAuthAccess(), false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.CheckCDHeader(response, "attachment", DS5ID + ".xml");
        this.url = "/objects/demo:REST/datastreams/DS6.xml/content?download=true";
        response = this.get(this.getAuthAccess(), false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.CheckCDHeader(response, "attachment", DS6ID);
    }

    @Test
    public void testUpload() throws Exception {
        String uploadUrl = "/upload";
        this.url = TestRESTAPI.getBaseURL() + uploadUrl;
        HttpResponse response = this._doUploadPost(this.url);
        if (response.getStatusCode() == 302) {
            this.url = response.getResponseHeader("Location").getValue();
            response = this._doUploadPost(this.url);
        }
        TestRESTAPI.assertEquals((int)202, (int)response.getStatusCode());
        TestRESTAPI.assertTrue((boolean)response.getResponseBodyString().startsWith("uploaded://"));
        response = this._doUploadPost(this.url, new Part[0]);
        TestRESTAPI.assertEquals((int)400, (int)response.getStatusCode());
    }

    @Test
    public void testGetRelationships() throws Exception {
        String s = "info:fedora/" + this.pid;
        String p = Constants.MODEL.HAS_MODEL.uri;
        String o = Models.FEDORA_OBJECT_CURRENT.uri;
        this.url = "/objects/" + this.pid + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8");
        HttpResponse response = this.get(true, false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.checkRelationship(response.getResponseBody(), s, p, o, true);
    }

    @Test
    public void testAddRelationship() throws Exception {
        String s = "info:fedora/" + this.pid;
        String p = "http://www.example.org/test#relationship";
        String o = "foo";
        this.url = "/objects/" + this.pid + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8");
        HttpResponse response = this.get(true, false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.checkRelationship(response.getResponseBody(), s, p, o, false);
        this.url = "/objects/" + this.pid + "/relationships/new" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true";
        response = this.putOrPost("POST", null, true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.url = "/objects/" + this.pid + "/relationships";
        response = this.get(true, false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.checkRelationship(response.getResponseBody(), s, p, o, true);
    }

    @Test
    public void testPurgeRelationship() throws Exception {
        String s = "info:fedora/" + this.pid;
        String p = "http://www.example.org/test#relationship";
        String o = "foo";
        this.url = "/objects/" + this.pid + "/relationships/new" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true";
        HttpResponse response = this.putOrPost("POST", null, true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.url = "/objects/" + this.pid + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8");
        response = this.get(true, false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.checkRelationship(response.getResponseBody(), s, p, o, true);
        this.url = "/objects/" + this.pid + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true";
        response = this.delete(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertEquals((String)"Purge relationship", (String)"true", (String)response.getResponseBodyString());
        this.url = "/objects/" + this.pid + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8");
        response = this.get(true, false);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        this.checkRelationship(response.getResponseBody(), s, p, o, false);
        this.url = "/objects/" + this.pid + "/relationships" + "?subject=" + URLEncoder.encode(s, "UTF-8") + "&predicate=" + URLEncoder.encode(p, "UTF-8") + "&object=" + URLEncoder.encode(o, "UTF-8") + "&isLiteral=true";
        response = this.delete(true);
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertEquals((String)"Purge relationship", (String)"false", (String)response.getResponseBodyString());
    }

    @Test
    public void testDisseminationContentLengthWhenKnown() throws Exception {
        this.url = "/objects/demo:SmileyBeerGlass/methods/demo:DualResolution/mediumSize";
        if (this.getAuthAccess()) {
            TestRESTAPI.assertEquals((int)401, (int)this.get(false).getStatusCode());
        }
        HttpResponse response = this.get(this.getAuthAccess());
        TestRESTAPI.assertEquals((int)200, (int)response.getStatusCode());
        TestRESTAPI.assertEquals((String)"17109", (String)response.getResponseHeader("Content-Length").getValue());
    }

    private HttpResponse _doUploadPost(String path) throws Exception {
        File temp = File.createTempFile("test.txt", null);
        FileUtils.writeStringToFile((File)temp, (String)"This is the upload test file");
        Part[] parts = new Part[]{new FilePart("file", temp)};
        return this._doUploadPost(path, parts);
    }

    private HttpResponse _doUploadPost(String path, Part[] parts) throws Exception {
        PostMethod post = new PostMethod(path);
        MultipartRequestEntity entity = new MultipartRequestEntity(parts, post.getParams());
        post.setRequestEntity((RequestEntity)entity);
        this.getClient(true).executeMethod((HttpMethod)post);
        return new HttpResponse((HttpMethod)post);
    }

    private void CheckCDHeader(HttpResponse response, String expectedType, String expectedFilename) {
        Header[] headers;
        String contentDisposition = "";
        for (Header header : headers = response.responseHeaders) {
            if (!header.getName().equalsIgnoreCase("content-disposition")) continue;
            contentDisposition = header.getValue();
        }
        TestRESTAPI.assertEquals((String)(expectedType + "; " + "filename=\"" + expectedFilename + "\""), (String)contentDisposition);
    }

    private HttpClient getClient(boolean auth) {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(auth);
        if (auth) {
            client.getState().setCredentials(new AuthScope(TestRESTAPI.getHost(), Integer.valueOf(this._getPort()).intValue(), "realm"), (Credentials)new UsernamePasswordCredentials(TestRESTAPI.getUsername(), TestRESTAPI.getPassword()));
        }
        return client;
    }

    private String _getPort() {
        if (this.url != null && this.url.startsWith("https")) {
            return TestRESTAPI.getServerConfiguration().getParameter("fedoraRedirectPort");
        }
        return TestRESTAPI.getServerConfiguration().getParameter("fedoraServerPort");
    }

    protected HttpResponse get(boolean authenticate) throws Exception {
        return this.get(authenticate, true);
    }

    protected HttpResponse get(boolean authenticate, boolean validate) throws Exception {
        HttpResponse res = this.getOrDelete("GET", authenticate);
        if (validate) {
            this.validateResponse(res);
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateResponse(HttpResponse res) throws Exception {
        if (res.getStatusCode() < 200 || res.getStatusCode() > 299 || this.url.contains("flash=true") || res.getResponseHeader("Content-Type") == null || !res.getResponseHeader("Content-Type").getValue().contains("text/xml") && !res.getResponseHeader("Content-Type").getValue().contains("application/xml")) return;
        String xmlResponse = res.getResponseBodyString();
        if (xmlResponse.contains(":schemaLocation=\"")) {
            String offline = System.getProperty("offline");
            String online = System.getProperty("online");
            if (!("false".equals(online) || offline != null && "true".equals(offline))) {
                this.onlineValidate(xmlResponse);
            }
            if ("false".equals(offline)) return;
        }
        TestRESTAPI.fail((String)("No schema location specified in response - " + this.url));
    }

    protected HttpResponse delete(boolean authenticate) throws Exception {
        return this.getOrDelete("DELETE", authenticate);
    }

    protected HttpResponse put(boolean authenticate) throws Exception {
        return this.putOrPost("PUT", null, authenticate);
    }

    protected HttpResponse put(String requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("PUT", requestContent, authenticate);
    }

    protected HttpResponse post(String requestContent, boolean authenticate) throws Exception {
        return this.post(requestContent, authenticate, true);
    }

    protected HttpResponse post(String requestContent, boolean authenticate, boolean validate) throws Exception {
        HttpResponse res = this.putOrPost("POST", requestContent, authenticate);
        if (validate) {
            this.validateResponse(res);
        }
        return res;
    }

    protected HttpResponse put(File requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("PUT", requestContent, authenticate);
    }

    protected HttpResponse post(File requestContent, boolean authenticate) throws Exception {
        return this.putOrPost("POST", requestContent, authenticate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse getOrDelete(String method, boolean authenticate) throws Exception {
        if (this.url == null || this.url.length() == 0) {
            throw new IllegalArgumentException("url must be a non-empty value");
        }
        if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
            this.url = TestRESTAPI.getBaseURL() + this.url;
        }
        GetMethod httpMethod = null;
        try {
            String redir;
            if (method.equals("GET")) {
                httpMethod = new GetMethod(this.url);
            } else if (method.equals("DELETE")) {
                httpMethod = new DeleteMethod(this.url);
            } else {
                throw new IllegalArgumentException("method must be one of GET or DELETE.");
            }
            httpMethod.setDoAuthentication(authenticate);
            httpMethod.setFollowRedirects(false);
            httpMethod.getParams().setParameter("Connection", (Object)"Keep-Alive");
            this.getClient(authenticate).executeMethod((HttpMethod)httpMethod);
            HttpResponse response = new HttpResponse((HttpMethod)httpMethod);
            if (response.getStatusCode() == 302 && (redir = response.getResponseHeader("Location").getValue()) != this.url) {
                this.url = redir;
                response = this.getOrDelete(method, authenticate);
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse putOrPost(String method, Object requestContent, boolean authenticate) throws Exception {
        if (this.url == null || this.url.length() == 0) {
            throw new IllegalArgumentException("url must be a non-empty value");
        }
        if (!this.url.startsWith("http://") && !this.url.startsWith("https://")) {
            this.url = TestRESTAPI.getBaseURL() + this.url;
        }
        PutMethod httpMethod = null;
        try {
            String redir;
            if (method.equals("PUT")) {
                httpMethod = new PutMethod(this.url);
            } else if (method.equals("POST")) {
                httpMethod = new PostMethod(this.url);
            } else {
                throw new IllegalArgumentException("method must be one of PUT or POST.");
            }
            httpMethod.setDoAuthentication(authenticate);
            httpMethod.getParams().setParameter("Connection", (Object)"Keep-Alive");
            if (requestContent != null) {
                httpMethod.setContentChunked(this.chunked);
                if (requestContent instanceof String) {
                    httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity((String)requestContent, "text/xml", "utf-8"));
                } else if (requestContent instanceof File) {
                    Part[] parts = new Part[]{new StringPart("param_name", "value"), new FilePart(((File)requestContent).getName(), (File)requestContent)};
                    httpMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, httpMethod.getParams()));
                } else {
                    throw new IllegalArgumentException("requestContent must be a String or File");
                }
            }
            this.getClient(authenticate).executeMethod((HttpMethod)httpMethod);
            HttpResponse response = new HttpResponse((HttpMethod)httpMethod);
            if (response.getStatusCode() == 302 && (redir = response.getResponseHeader("Location").getValue()) != this.url) {
                this.url = redir;
                response = this.putOrPost(method, requestContent, authenticate);
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    private void checkRelationship(byte[] rdf, String s, String p, String o, boolean exists) throws TrippiException, UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("RDF: " + new String(rdf, "UTF-8"));
        TripleIterator it = TripleIteratorFactory.defaultInstance().fromStream((InputStream)new ByteArrayInputStream(rdf), null, RDFFormat.RDF_XML);
        boolean found = false;
        while (it.hasNext()) {
            Triple t = it.next();
            sb.append(t.getSubject().stringValue() + ", ");
            sb.append(t.getPredicate().stringValue() + ", ");
            sb.append(t.getObject().stringValue() + "\n");
            sb.append("matching: " + s + " " + t.getSubject().stringValue() + " " + s.equals(t.getSubject().stringValue()) + "\n");
            sb.append("matching: " + p + " " + t.getPredicate().stringValue() + " " + p.equals(t.getPredicate().stringValue()) + "\n");
            sb.append("matching: " + o + " " + t.getObject().stringValue() + " " + o.equals(t.getObject().stringValue()) + "\n");
            if (!s.equals(t.getSubject().stringValue()) || !p.equals(t.getPredicate().stringValue()) || !o.equals(t.getObject().stringValue())) continue;
            sb.append("Matched\n");
            found = true;
        }
        TestRESTAPI.assertTrue((String)("Testing if relationship present: " + exists + " [ " + s + ", " + p + ", " + o + " ] \n " + sb.toString()), (exists == found ? 1 : 0) != 0);
    }

    private List<File> getSchemaFiles(String xml, List<File> state) throws Exception {
        File schemaDir = new File(Constants.FEDORA_HOME, "server" + File.separator + "xsd");
        ArrayList<File> result = new ArrayList<File>();
        Pattern p = Pattern.compile("schemaLocation=\"(.+?)\"");
        Matcher m = p.matcher(xml);
        while (m.find()) {
            String[] content;
            for (String frag : content = m.group(1).split("\\s+")) {
                if (!frag.contains(".xsd")) continue;
                String[] paths = frag.split("/");
                File newSchema = new File(schemaDir, paths[paths.length - 1]);
                if (state != null && state.contains(newSchema)) continue;
                result.add(newSchema);
            }
        }
        ArrayList<File> included = new ArrayList<File>();
        for (File f : result) {
            xml = IOUtils.toString((InputStream)new FileInputStream(f));
            included.addAll(this.getSchemaFiles(xml, result));
        }
        result.addAll(included);
        return result;
    }

    private void offlineValidate(String xml, List<File> schemas) throws Exception {
        Schema schema;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        System.out.println(sf.getClass().getName());
        ArrayList<StreamSource> schemata = new ArrayList<StreamSource>();
        for (File schemaFile : schemas) {
            schemata.add(new StreamSource(schemaFile));
        }
        try {
            schema = sf.newSchema(schemata.toArray(new Source[0]));
        }
        catch (SAXException e) {
            throw new RuntimeException("Could not parse schema " + schemas.toString(), e);
        }
        Validator v = schema.newValidator();
        StringBuilder errors = new StringBuilder();
        v.setErrorHandler(new ValidatorErrorHandler(errors));
        v.validate(new StreamSource(new StringReader(xml)));
        TestRESTAPI.assertTrue((String)("Offline validation failed for " + this.url + ". Errors: " + errors.toString() + "\n xml:\n" + xml), (0 == errors.length() ? 1 : 0) != 0);
    }

    private void onlineValidate(String xml) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        StringBuilder errors = new StringBuilder();
        XMLReader reader = parser.getXMLReader();
        reader.setEntityResolver(new ValidatorEntityResolver());
        reader.setErrorHandler(new ValidatorErrorHandler(errors));
        reader.parse(new InputSource(new StringReader(xml)));
        if (errors.length() > 0) {
            System.out.println(xml);
        }
        TestRESTAPI.assertTrue((String)("Online Validation failed for " + this.url + ". Errors: " + errors.toString()), (0 == errors.length() ? 1 : 0) != 0);
    }

    public static junit.framework.Test suite() {
        TestSuite suite = new TestSuite("REST API TestSuite");
        suite.addTestSuite(TestRESTAPI.class);
        return new DemoObjectTestSetup((junit.framework.Test)suite);
    }

    static {
        REST_RESOURCE_PATH = System.getProperty("fcrepo-integrationtest-core.classes") != null ? System.getProperty("fcrepo-integrationtest-core.classes") + "rest" : "src/test/resources/rest";
        DS1RelsFilename = "Datastream 1 filename from rels.extension";
        DS2LabelFilename = "Datastream 2 filename from label";
        DS3LabelFilename = "Datastream 3 filename from label";
        DodgyChars = "\\/*?&lt;&gt;:|";
        DS4LabelFilenameOriginal = "Datastream 4 filename " + DodgyChars + "from label";
        DS4LabelFilename = "Datastream 4 filename from label";
        DS5ID = "DS5";
        DS6ID = "DS6.xml";
        df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        now = new Date();
        datetime = df.format(now);
        laterDateTime = df.format(new Date(now.getTime() + 600000L));
    }

    class HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final Header[] responseHeaders;
        private final Header[] responseFooters;

        HttpResponse(int status, byte[] body, Header[] headers, Header[] footers) {
            this.statusCode = status;
            this.responseBody = body;
            this.responseHeaders = headers;
            this.responseFooters = footers;
        }

        HttpResponse(HttpMethod method) throws IOException {
            this.statusCode = method.getStatusCode();
            InputStream response = method.getResponseBodyAsStream();
            this.responseBody = response == null ? new byte[]{} : IOUtils.toByteArray((InputStream)response);
            this.responseHeaders = method.getResponseHeaders();
            this.responseFooters = method.getResponseFooters();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] getResponseBody() {
            return this.responseBody;
        }

        public String getResponseBodyString() {
            try {
                return new String(this.responseBody, "UTF-8");
            }
            catch (UnsupportedEncodingException wontHappen) {
                throw new Error(wontHappen);
            }
        }

        public Header[] getResponseHeaders() {
            return this.responseHeaders;
        }

        public Header[] getResponseFooters() {
            return this.responseFooters;
        }

        public Header getResponseHeader(String headerName) {
            for (Header header : this.responseHeaders) {
                if (!header.getName().equalsIgnoreCase(headerName)) continue;
                return header;
            }
            return null;
        }
    }

    class ValidatorErrorHandler
    implements ErrorHandler {
        private final StringBuilder m_errors;

        ValidatorErrorHandler(StringBuilder errors) {
            this.m_errors = errors;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.m_errors.append(e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.m_errors.append(e.getMessage());
        }
    }
}

