/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URLEncoder;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.test.DemoObjectTestSetup;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.api.RISearchUtil;

public class TestRISearch
extends FedoraServerTestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite("TestRISearch TestSuite");
        suite.addTestSuite(TestRISearch.class);
        return new DemoObjectTestSetup((Test)suite);
    }

    public void testRISearchBasicCModel() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyPens_M", "demo:SmileyGreetingCard"}) {
            String query = "<" + PID.toURI((String)pid) + ">" + " <" + Constants.MODEL.HAS_MODEL.uri + ">" + " <" + Models.FEDORA_OBJECT_CURRENT.uri + ">";
            RISearchUtil.checkSPOCount(client, query, 1);
        }
    }

    public void testRISearchSparqlW3cResult() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        String query = "select $object $modified from <#ri> where  $object <fedora-model:hasModel> <info:fedora/fedora-system:ServiceDefinition-3.0> and $object <fedora-view:lastModifiedDate> $modified";
        String xml = client.getResponseAsString("/risearch?lang=itql&format=Sparql_W3C&query=" + URLEncoder.encode(query, "UTF-8"), true, true).trim();
        this.validateXML(xml, ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("schema/sparql/sparql_result.xsd"));
    }

    private void validateXML(String xml, InputStream schemaIn) throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(new StreamSource(schemaIn));
        Validator validator = schema.newValidator();
        StringBuilder errorBuilder = new StringBuilder();
        try {
            validator.validate(new StreamSource(new StringReader(xml)));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestRISearch.fail((String)("Error during validation of XML:\n" + e.getLocalizedMessage()));
        }
    }

    public void testRISearchRelsExtCollection() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        String collectionPid = "demo:SmileyStuff";
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyPens_M", "demo:SmileyGreetingCard"}) {
            String query = "<" + PID.toURI((String)pid) + ">" + " <" + Constants.RELS_EXT.IS_MEMBER_OF.uri + ">" + " <" + PID.toURI((String)collectionPid) + ">";
            RISearchUtil.checkSPOCount(client, query, 1);
        }
    }

    public void testRISearchRelsInt() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        for (String pid : new String[]{"demo:SmileyPens", "demo:SmileyPens_M", "demo:SmileyGreetingCard"}) {
            String query = "<" + PID.toURI((String)pid) + "/MEDIUM_SIZE" + ">" + " <" + "http://ns.adobe.com/exif/1.0/PixelXDimension" + ">" + " \"320\"";
            RISearchUtil.checkSPOCount(client, query, 1);
        }
    }

    public void testSpringTripleGenerators() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        String query = "<info:fedora/demo:5> <info:fedora/fedora-system:test/tests#tripleGenerator> \"true\"";
        RISearchUtil.checkSPOCount(client, query, 1);
    }

    public void testLanguageAttributes() throws Exception {
        FedoraClient client = TestRISearch.getFedoraClient();
        String query = "PREFIX skos: <http://www.w3.org/2004/02/skos/core#>\nSELECT ?x FROM <#ri>\nWHERE { ?x skos:prefLabel \"Immagine del Colosseo a Roma\"@it }";
        RISearchUtil.checkSPARQLCount(client, query, 1);
    }
}

