/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.api;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.ws.soap.SOAPFaultException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.client.HttpInputStream;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.gen.RelationshipTuple;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.ManagedContentTranslator;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.trippi.TripleIterator;
import org.trippi.io.RIOTripleIterator;

public class TestRelationships
extends FedoraServerTestCase
implements Constants {
    private FedoraAPIMMTOM apim;
    private final ExecutorService exec = Executors.newFixedThreadPool(4);
    private static final String RISEARCH_QUERY = "/risearch?type=triples&lang=spo&format=NTriples&stream=on&flush=true&query=";
    private static byte[] DEMO_888_FOXML;
    private static byte[] DEMO_777_FOXML;
    private static String MULTIBYTE_UTF8;
    private final String[] subject = new String[]{"demo:777", "info:fedora/demo:777", "info:fedora/demo:777/DS1", "info:fedora/demo:777/DS2", "demo:888", "info:fedora/demo:888", "info:fedora/demo:888/DS1", "info:fedora/demo:888/DS2", "demo:777m", "info:fedora/demo:777m", "info:fedora/demo:777m/DS1", "info:fedora/demo:777m/DS2", "demo:888m", "info:fedora/demo:888m", "info:fedora/demo:888m/DS1", "info:fedora/demo:888m/DS2"};

    public static Test suite() {
        TestSuite suite = new TestSuite("TestRelationships TestSuite");
        suite.addTestSuite(TestRelationships.class);
        return suite;
    }

    public void setUp() throws Exception {
        this.apim = TestRelationships.getFedoraClient().getAPIMMTOM();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("oai_dc", "http://www.openarchives.org/OAI/2.0/oai_dc/");
        nsMap.put("dc", "http://purl.org/dc/elements/1.1/");
        nsMap.put("foxml", "info:fedora/fedora-system:def/foxml#");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])DEMO_888_FOXML), TestRelationships.FOXML1_1.uri, "ingesting new foxml object");
        this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])DEMO_777_FOXML), TestRelationships.FOXML1_1.uri, "ingesting new foxml object");
        ManagedContentTranslator.createManagedClone(this.apim, "demo:888", "demo:888m");
        ManagedContentTranslator.createManagedClone(this.apim, "demo:777", "demo:777m");
    }

    public void tearDown() throws Exception {
        this.apim.purgeObject("demo:777", "", false);
        this.apim.purgeObject("demo:888", "", false);
        this.apim.purgeObject("demo:777m", "", false);
        this.apim.purgeObject("demo:888m", "", false);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
        this.exec.shutdown();
    }

    public void testAddRelationship() throws Exception {
        int relNum = 0;
        for (String s : this.subject) {
            String p = "urn:bar" + relNum++;
            String o = "urn:baz";
            this.addRelationship(s, p, o, false, null);
            o = "quux";
            this.addRelationship(s, p, o, true, null);
            o = "1970-01-01T00:00:00Z";
            this.addRelationship(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri);
            o = MULTIBYTE_UTF8;
            this.addRelationship(s, p, o, true, null);
        }
    }

    public void testValidation() {
        int relNum = 0;
        for (String s : this.subject) {
            String p = "http://purl.org/dc/elements/1.1/title";
            String o = "A Dictionary of Maqiao" + relNum++;
            if (!s.endsWith("DS1") && !s.endsWith("DS2")) {
                try {
                    this.apim.addRelationship(s, p, o, true, null);
                    TestRelationships.fail((String)("Adding Dublin Core relationship should have failed - " + s));
                }
                catch (SOAPFaultException se) {
                    TestRelationships.assertTrue((String)se.getMessage(), (boolean)se.getMessage().contains("improper relationship assertion"));
                }
            }
            p = "info:fedora/fedora-system:def/model#foo";
            try {
                this.apim.addRelationship(s, p, o, true, null);
                TestRelationships.fail((String)("Adding Fedora Model relationship should have failed - " + s));
            }
            catch (SOAPFaultException se) {
                TestRelationships.assertTrue((String)se.getMessage(), (boolean)se.getMessage().contains("Disallowed predicate"));
            }
            p = "urn:bar" + relNum;
            o = "2009-10-05T16:02:26+0100";
            try {
                this.apim.addRelationship(s, p, o, true, Constants.RDF_XSD.DATE_TIME.uri);
                TestRelationships.fail((String)("Adding invalid date/time literal in relationship should have failed - " + s));
            }
            catch (SOAPFaultException se) {
                TestRelationships.assertTrue((String)se.getMessage(), (boolean)se.getMessage().contains("is not a valid 'dateTime' value"));
            }
        }
    }

    public void testBadSubjectURI() {
        String s = "info:fedora/does:notexist";
        String p = "urn:foo";
        String o = "urn:bar";
        try {
            this.apim.addRelationship(s, p, o, false, null);
            TestRelationships.fail((String)"Adding relationship with subject as a Fedora DO that does not exist should have failed");
        }
        catch (SOAPFaultException se) {
            // empty catch block
        }
        s = "info:fedora/does:notexist/DS1";
        p = "urn:foo";
        o = "urn:baz";
        try {
            this.apim.addRelationship(s, p, o, false, null);
            TestRelationships.fail((String)"Adding relationship with subject as a Fedora object datastream where DO does not exist should have failed");
        }
        catch (SOAPFaultException se) {
            // empty catch block
        }
        s = "http://www.example.org/test";
        p = "urn:foo";
        o = "urn:quux";
        try {
            this.apim.addRelationship(s, p, o, false, null);
            TestRelationships.fail((String)"Adding relationship with subject uri not in the info:fedora scheme should have failed");
        }
        catch (SOAPFaultException se) {
            // empty catch block
        }
        s = "demo:888/DS1";
        p = "urn:foo";
        o = "urn:quux";
        try {
            this.apim.addRelationship(s, p, o, false, null);
            TestRelationships.fail((String)"Adding relationship with invalid short URI should have failed");
        }
        catch (SOAPFaultException se) {
            // empty catch block
        }
    }

    public void testGetRelationships() throws Exception {
        int relNum = 0;
        for (String s : this.subject) {
            String p = "urn:bar" + relNum++;
            String o = "urn:baz";
            this.getRelationship(s, p, o, false, null);
            p = "urn:title" + relNum;
            o = "asdf";
            this.getRelationship(s, p, o, true, null);
            p = "urn:temperature" + relNum;
            o = "98.6";
            this.getRelationship(s, p, o, true, Constants.RDF_XSD.FLOAT.uri);
            p = "urn:utf8literal" + relNum;
            o = MULTIBYTE_UTF8;
            this.getRelationship(s, p, o, true, null);
        }
    }

    public void testGetAllRelationships() throws Exception {
        List tuples = this.apim.getRelationships("demo:777", null);
        TestRelationships.assertEquals((int)1, (int)tuples.size());
    }

    public void testBasicCModelRelationships() throws Exception {
        for (String pid : new String[]{"info:fedora/demo:777", "info:fedora/demo:888"}) {
            this.checkExistsViaGetRelationships(pid, Constants.MODEL.HAS_MODEL.uri, Models.FEDORA_OBJECT_CURRENT.uri);
        }
    }

    public void testPurgeRelationships() throws Exception {
        int relNum = 0;
        for (String s : this.subject) {
            String p = "urn:p" + relNum++;
            String o = "urn:o";
            this.purgeRelationship(s, p, o, false, null);
            p = "urn:title" + relNum;
            o = "asdf";
            this.purgeRelationship(s, p, o, true, null);
            p = "urn:temperature" + relNum;
            o = "98.6";
            this.purgeRelationship(s, p, o, true, Constants.RDF_XSD.FLOAT.uri);
            p = "urn:utf8literal" + relNum;
            o = MULTIBYTE_UTF8;
            this.purgeRelationship(s, p, o, true, null);
            TestRelationships.assertFalse((String)"Purging non-existant relation should have failed", (boolean)this.apim.purgeRelationship(s, "urn:asdf", "867-5309", true, null));
        }
    }

    private void checkExistsViaGetRelationships(String subject, String predicate, String object) throws Exception {
        boolean found = false;
        for (RelationshipTuple tuple : this.apim.getRelationships(subject, predicate)) {
            if (!tuple.getSubject().equals(this.subjectAsURI(subject)) || !tuple.getPredicate().equals(predicate) || !tuple.getObject().equals(object)) continue;
            found = true;
        }
        TestRelationships.assertTrue((String)("Relationship not found via getRelationships (subject=" + subject + ", predicate=" + predicate + ", object=" + object), (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationship(String subject, String predicate, String object, boolean isLiteral, String datatype) throws Exception {
        TestRelationships.assertTrue((boolean)this.apim.addRelationship(subject, predicate, object, isLiteral, datatype));
        TestRelationships.assertFalse((String)"Adding duplicate relationship should return false", (boolean)this.apim.addRelationship(subject, predicate, object, isLiteral, datatype));
        String query = "";
        query = isLiteral ? (datatype != null ? String.format("* <%s> '%s'^^%s", predicate, object, datatype) : String.format("* <%s> '%s'", predicate, object)) : String.format("* <%s> <%s>", predicate, object);
        TripleIterator triples = this.queryRI(query);
        try {
            TestRelationships.assertTrue((String)("Relationship not found in RI (query = " + query + ")"), (boolean)triples.hasNext());
            while (triples.hasNext()) {
                TestRelationships.assertEquals((String)triples.next().getSubject().stringValue(), (String)this.subjectAsURI(subject));
            }
        }
        finally {
            triples.close();
        }
    }

    private String subjectAsURI(String subj) {
        if (subj.startsWith(Constants.FEDORA.uri)) {
            return subj;
        }
        return PID.toURI((String)subj);
    }

    private void getRelationship(String subject, String predicate, String object, boolean isLiteral, String datatype) throws Exception {
        this.addRelationship(subject, predicate, object, isLiteral, datatype);
        List tuples = this.apim.getRelationships(subject, predicate);
        TestRelationships.assertNotNull((Object)tuples);
        TestRelationships.assertEquals((int)1, (int)tuples.size());
        TestRelationships.assertEquals((String)this.subjectAsURI(subject), (String)((RelationshipTuple)tuples.get(0)).getSubject());
        TestRelationships.assertEquals((String)predicate, (String)((RelationshipTuple)tuples.get(0)).getPredicate());
        TestRelationships.assertEquals((String)object, (String)((RelationshipTuple)tuples.get(0)).getObject());
        TestRelationships.assertEquals((boolean)isLiteral, (boolean)((RelationshipTuple)tuples.get(0)).isIsLiteral());
        TestRelationships.assertEquals((String)datatype, (String)((RelationshipTuple)tuples.get(0)).getDatatype());
    }

    private void purgeRelationship(String subject, String predicate, String object, boolean isLiteral, String datatype) throws Exception {
        this.addRelationship(subject, predicate, object, isLiteral, datatype);
        TestRelationships.assertTrue((boolean)this.apim.purgeRelationship(subject, predicate, object, isLiteral, datatype));
    }

    private TripleIterator queryRI(String query) throws Exception {
        FedoraClient client = TestRelationships.getFedoraClient();
        HttpInputStream results = client.get(RISEARCH_QUERY + URLEncoder.encode(query, "UTF-8"), true);
        return new RIOTripleIterator((InputStream)results, (RDFParser)new NTriplesParser(), "info/fedora", this.exec);
    }

    public static void main(String[] args) {
        TestRunner.run(TestRelationships.class);
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"demo:888\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("  <foxml:datastream ID=\"RELS-EXT\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion FORMAT_URI=\"info:fedora/fedora-system:FedoraRELSExt-1.0\" ID=\"RELS-EXT.0\" MIMETYPE=\"application/rdf+xml\" LABEL=\"RDF Statements about this object\">");
        sb.append("      <foxml:xmlContent>");
        sb.append("        <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"                 xmlns:fedora-model=\"info:fedora/fedora-system:def/model#\">");
        sb.append("          <rdf:Description rdf:about=\"info:fedora/demo:888\">");
        sb.append("            <fedora-model:hasModel rdf:resource=\"info:fedora/demo:UVA_STD_IMAGE_1\"/>");
        sb.append("            <fedora-model:hasModel rdf:resource=\"" + Models.FEDORA_OBJECT_CURRENT.uri + "\"/>");
        sb.append("          </rdf:Description>");
        sb.append("        </rdf:RDF>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("  <foxml:datastream ID=\"RELS-INT\" CONTROL_GROUP=\"M\" STATE=\"A\">");
        sb.append("    <foxml:datastreamVersion FORMAT_URI=\"info:fedora/fedora-system:FedoraRELSInt-1.0\" ID=\"RELS-INT.0\" MIMETYPE=\"application/rdf+xml\" LABEL=\"RDF Statements about datastreams in this object\">");
        sb.append("      <foxml:xmlContent>");
        sb.append("        <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"                 xmlns:myns=\"http://www.example.org/testns#\">");
        sb.append("          <rdf:Description rdf:about=\"info:fedora/demo:888/DS1\">");
        sb.append("            <myns:test1 rdf:resource=\"info:fedora/demo:UVA_STD_IMAGE_1\"/>");
        sb.append("          </rdf:Description>");
        sb.append("          <rdf:Description rdf:about=\"info:fedora/demo:888/DS3\">");
        sb.append("            <myns:test2 rdf:resource=\"info:fedora/demo:11223344\"/>");
        sb.append("          </rdf:Description>");
        sb.append("        </rdf:RDF>");
        sb.append("      </foxml:xmlContent>");
        sb.append("    </foxml:datastreamVersion>");
        sb.append("  </foxml:datastream>");
        sb.append("</foxml:digitalObject>");
        try {
            DEMO_888_FOXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"demo:777\" xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("</foxml:digitalObject>");
        try {
            DEMO_777_FOXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        try {
            MULTIBYTE_UTF8 = new String(new byte[]{-30, -128, -100, -50, -111, 32, -62, -65, -30, -128, -99}, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

