/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.fesl.policy;

import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.common.Constants;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.fesl.util.AuthorizationDeniedException;
import org.fcrepo.test.fesl.util.FedoraUtil;
import org.fcrepo.test.fesl.util.HttpUtils;
import org.fcrepo.test.fesl.util.LoadDataset;
import org.fcrepo.test.fesl.util.PolicyUtils;
import org.fcrepo.test.fesl.util.RemoveDataset;
import org.junit.After;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHierarchy
extends FedoraServerTestCase
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(TestHierarchy.class);
    private static final String PROPERTIES = "fedora";
    private static HttpUtils httpUtils = null;
    private PolicyUtils policyUtils = null;

    public static Test suite() {
        return new JUnit4TestAdapter(TestHierarchy.class);
    }

    public void setUp() {
        PropertyResourceBundle prop = (PropertyResourceBundle)ResourceBundle.getBundle(PROPERTIES);
        String username = prop.getString("fedora.admin.username");
        String password = prop.getString("fedora.admin.password");
        String fedoraUrl = FedoraUtil.getBaseURL();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Setting up...");
            }
            this.policyUtils = new PolicyUtils(TestHierarchy.getFedoraClient());
            httpUtils = new HttpUtils(fedoraUrl, username, password);
            String policyId = this.policyUtils.addPolicy("test-access-admin.xml");
            LoadDataset.load("fesl-hierarchy", fedoraUrl, username, password);
            this.policyUtils.delPolicy(policyId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        PropertyResourceBundle prop = (PropertyResourceBundle)ResourceBundle.getBundle(PROPERTIES);
        String username = prop.getString("fedora.admin.username");
        String password = prop.getString("fedora.admin.password");
        String fedoraUrl = FedoraUtil.getBaseURL();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Tearing down...");
            }
            String policyId = this.policyUtils.addPolicy("test-access-admin.xml");
            RemoveDataset.remove("fesl-hierarchy", fedoraUrl, username, password);
            this.policyUtils.delPolicy(policyId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void testHierarchicalResourceID() throws Exception {
        String url = "/fedora/objects/test:1000004?format=xml";
        String response = httpUtils.get(url);
        TestHierarchy.assertTrue((String)"No access to test:1000004", (boolean)response.contains("Chuck Versus the First Date"));
        String policyId = this.policyUtils.addPolicy("test-policy-H.xml");
        url = "/fedora/objects/test:1000004?format=xml";
        try {
            response = httpUtils.get(url);
            Assert.fail((String)"Access was permitted to test:1000004 when it should have been denied");
        }
        catch (AuthorizationDeniedException e) {
        }
        finally {
            this.policyUtils.delPolicy(policyId);
        }
    }
}

