/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import javax.activation.DataHandler;
import junit.framework.JUnit4TestAdapter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.management.FedoraAPIMMTOM;
import org.fcrepo.server.types.mtom.gen.MIMETypedStream;
import org.fcrepo.server.utilities.TypeUtility;
import org.fcrepo.test.FedoraTestCase;
import org.junit.Test;

public class TestLargeDatastreams
extends FedoraTestCase {
    private FedoraClient fedoraClient;
    private FedoraAPIMMTOM apim;
    private FedoraAPIAMTOM apia;
    private static final String pid = "demo:LargeDatastreams";
    private static byte[] DEMO_FOXML;
    private static long gigabyte;
    private final long fileSize = gigabyte * 5L;

    public void setUp() throws Exception {
        this.fedoraClient = TestLargeDatastreams.getFedoraClient();
        this.apim = this.fedoraClient.getAPIMMTOM();
        this.apia = this.fedoraClient.getAPIAMTOM();
    }

    @Test
    public void testLargeDatastreamIO() throws Exception {
        System.out.println("Running testLargeDatastreams...");
        System.out.println("  Uploading a file of size " + this.fileSize + " bytes...");
        String uploadId = this.upload();
        System.out.println("  Creating data object...");
        this.apim.ingest(TypeUtility.convertBytesToDataHandler((byte[])DEMO_FOXML), TestLargeDatastreams.FOXML1_1.uri, "new foxml object");
        System.out.println("  Adding uploaded file as a datastream...");
        this.apim.addDatastream(pid, "DS1", null, "Large Datastream", false, "text/plain", null, uploadId, "M", "A", null, null, "Adding Large Datastream");
        System.out.println("  Exporting datastream via API-A-Lite...");
        long exportFileAPIALiteSize = this.exportAPIALite("DS1");
        TestLargeDatastreams.assertEquals((long)this.fileSize, (long)exportFileAPIALiteSize);
        System.out.println("  Exporting datastream via API-A...");
        long exportFileAPIASize = this.exportAPIA("DS1");
        if (exportFileAPIASize >= 0L) {
            TestLargeDatastreams.assertEquals((long)this.fileSize, (long)exportFileAPIASize);
        }
        this.apim.purgeObject(pid, "Removing Test Object", false);
        System.out.println("  Test Complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String upload() throws Exception {
        String url = this.fedoraClient.getUploadURL();
        PostMethod httpMethod = new PostMethod(url);
        httpMethod.setDoAuthentication(true);
        httpMethod.getParams().setParameter("Connection", (Object)"Keep-Alive");
        httpMethod.setContentChunked(true);
        Part[] parts = new Part[]{new FilePart("file", (PartSource)new SizedPartSource())};
        httpMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, httpMethod.getParams()));
        HttpClient client = this.fedoraClient.getHttpClient();
        try {
            int status = client.executeMethod((HttpMethod)httpMethod);
            String response = new String(httpMethod.getResponseBody());
            if (status != 201) {
                throw new IOException("Upload failed: " + HttpStatus.getStatusText((int)status) + ": " + TestLargeDatastreams.replaceNewlines(response, " "));
            }
            String string = response = response.replaceAll("\r", "").replaceAll("\n", "");
            return string;
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    private long exportAPIALite(String dsId) throws Exception {
        String url = this.apia.describeRepository().getRepositoryBaseURL() + "/get/" + pid + "/" + dsId;
        GetMethod httpMethod = new GetMethod(url);
        httpMethod.setDoAuthentication(true);
        httpMethod.getParams().setParameter("Connection", (Object)"Keep-Alive");
        HttpClient client = this.fedoraClient.getHttpClient();
        client.executeMethod((HttpMethod)httpMethod);
        BufferedInputStream dataStream = new BufferedInputStream(httpMethod.getResponseBodyAsStream());
        long bytesRead = 0L;
        while (dataStream.read() >= 0) {
            ++bytesRead;
        }
        return bytesRead;
    }

    private long exportAPIA(String dsId) throws Exception {
        MIMETypedStream fileStream = null;
        try {
            fileStream = this.apia.getDatastreamDissemination(pid, dsId, null);
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("The datastream you are attempting to retrieve is too large") > 0) {
                System.out.println("  Expected error generated in API-A export:");
                System.out.println("    Error text: " + e.getMessage());
                return -1L;
            }
            TestLargeDatastreams.fail((String)("  Unexpected exception encountered in exportAPIA: " + e.getMessage()));
        }
        return TypeUtility.convertDataHandlerToBytes((DataHandler)fileStream.getStream()).length;
    }

    private static String replaceNewlines(String in, String replaceWith) {
        return in.replaceAll("\r", replaceWith).replaceAll("\n", replaceWith);
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestLargeDatastreams.class);
    }

    static {
        gigabyte = 0x40000000L;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<foxml:digitalObject VERSION=\"1.1\" PID=\"demo:LargeDatastreams\" ");
        sb.append("  xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\" ");
        sb.append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        sb.append("  xsi:schemaLocation=\"info:fedora/fedora-system:def/foxml# ");
        sb.append("  http://www.fedora.info/definitions/1/0/foxml1-1.xsd\">");
        sb.append("  <foxml:objectProperties>");
        sb.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>");
        sb.append("  </foxml:objectProperties>");
        sb.append("</foxml:digitalObject>");
        try {
            DEMO_FOXML = sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private class SizedInputStream
    extends InputStream {
        private long bytesRead = 0L;
        Random generator = new Random(System.currentTimeMillis());

        private SizedInputStream() {
        }

        @Override
        public int available() throws IOException {
            return (int)(TestLargeDatastreams.this.fileSize - this.bytesRead);
        }

        @Override
        public int read() throws IOException {
            if (this.bytesRead < TestLargeDatastreams.this.fileSize) {
                ++this.bytesRead;
                return this.generator.nextInt(100);
            }
            return -1;
        }
    }

    private class SizedPartSource
    implements PartSource {
        private SizedPartSource() {
        }

        public InputStream createInputStream() throws IOException {
            return new SizedInputStream();
        }

        public String getFileName() {
            return "file";
        }

        public long getLength() {
            return TestLargeDatastreams.this.fileSize;
        }
    }
}

