/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test.integration.cma;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.client.FedoraClient;
import org.fcrepo.server.access.FedoraAPIAMTOM;
import org.fcrepo.server.types.gen.ObjectMethodsDef;
import org.fcrepo.test.FedoraServerTestCase;
import org.fcrepo.test.integration.cma.Util;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class ContentModelDSInputTest {
    private static FedoraClient m_client;
    private static final String OBJECT_PID = "demo:dc2mods.1";
    private static final String SDEF_PID = "demo:dc2mods.sdef";
    private static final String SDEF_METHOD = "transform";
    private static final String DC2MODS_DEPLOYMENT_BASE = "cma-examples/dc2mods";

    public static Test suite() {
        return new JUnit4TestAdapter(ContentModelDSInputTest.class);
    }

    @BeforeClass
    public static void bootstrap() throws Exception {
        m_client = new FedoraClient(FedoraServerTestCase.getBaseURL(), FedoraServerTestCase.getUsername(), FedoraServerTestCase.getPassword());
        Util.ingestTestObjects(DC2MODS_DEPLOYMENT_BASE);
    }

    @org.junit.Test
    public void testListMethods() throws Exception {
        FedoraAPIAMTOM apia = m_client.getAPIAMTOM();
        ObjectMethodsDef[] methods = Util.filterMethods(apia.listMethods(OBJECT_PID, null).toArray(new ObjectMethodsDef[0]));
        Assert.assertEquals((String)"Wrong number of methods", (int)1, (int)methods.length);
        Assert.assertEquals((String)methods[0].getServiceDefinitionPID(), (String)SDEF_PID);
        Assert.assertEquals((String)methods[0].getMethodName(), (String)SDEF_METHOD);
    }

    @org.junit.Test
    public void testDissemination() throws Exception {
        Assert.assertTrue((String)"Wrong dissemination content", (boolean)this.getDissemination(OBJECT_PID, SDEF_PID, SDEF_METHOD).contains("<mods xmlns="));
    }

    private String getDissemination(String pid, String sDef, String method) throws Exception {
        return Util.getDissemination(m_client, pid, sDef, method);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        FedoraServerTestCase.purgeDemoObjects();
    }
}

