/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.test;

import java.io.FileInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;

public class TemplatedResourceIterator
implements Iterator<String> {
    private final String m_templateSource;
    private final String m_valuesFilename;
    private final Properties m_values;
    private final Set<String> m_propertyNames;
    private final int m_setCount;
    private int m_nextSet = 0;
    int m_lastAttributeCount = -1;
    private final boolean m_escapeXML;

    public TemplatedResourceIterator(String template, String valuesFilename) throws Exception {
        this(template, valuesFilename, false);
    }

    public TemplatedResourceIterator(String template, String valuesFilename, boolean escapeXML) throws Exception {
        this.m_escapeXML = escapeXML;
        this.m_values = new Properties();
        this.m_valuesFilename = valuesFilename;
        this.m_values.load(new FileInputStream(this.m_valuesFilename));
        this.m_setCount = Integer.parseInt(this.m_values.getProperty("template.attribute.sets.count"));
        this.m_propertyNames = this.m_values.stringPropertyNames();
        this.m_templateSource = template;
    }

    @Override
    public boolean hasNext() {
        return this.m_nextSet < this.m_setCount;
    }

    @Override
    public String next() {
        if (this.m_nextSet >= this.m_setCount) {
            throw new NoSuchElementException();
        }
        String setPropertyNamePrefix = "template.attribute.set." + this.m_nextSet + ".";
        StringTemplate tpl = new StringTemplate(this.m_templateSource);
        int attributeCount = 0;
        for (String propertyName : this.m_propertyNames) {
            if (!propertyName.startsWith(setPropertyNamePrefix)) continue;
            String attributeName = propertyName.replace(setPropertyNamePrefix, "");
            String attributeValue = this.m_values.getProperty(propertyName);
            String value = this.m_escapeXML ? this.escapeXML(attributeValue) : attributeValue;
            tpl.setAttribute(attributeName, (Object)value);
            ++attributeCount;
        }
        if (attributeCount == 0) {
            throw new RuntimeException("No attributes found for set " + this.m_nextSet + " (" + this.m_valuesFilename + ")");
        }
        if (this.m_lastAttributeCount != -1 && this.m_lastAttributeCount != attributeCount) {
            throw new RuntimeException("Number of attributes is different in sets " + (this.m_nextSet - 1) + " and " + this.m_nextSet + " (" + this.m_valuesFilename + ")");
        }
        this.m_lastAttributeCount = attributeCount;
        ++this.m_nextSet;
        return tpl.toString();
    }

    public String getAttributeValue(String attributeName) {
        String propertyName = "template.attribute.set." + this.m_nextSet + "." + attributeName;
        return this.m_values.getProperty(propertyName);
    }

    @Override
    public void remove() {
        throw new RuntimeException("Method remove() is not supported");
    }

    private String escapeXML(String toEscape) {
        String res = toEscape;
        res = res.replace("\"", "&quot;");
        res = res.replace("'", "&apos;");
        res = res.replace("&", "&amp;");
        res = res.replace("<", "&lt;");
        res = res.replace(">", "&gt;");
        return res;
    }
}

